/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.ecm.schema.impl;

import com.ibm.xml.ecm.schema.DatatypeFormatException;
import com.ibm.xml.ecm.schema.FloatingNumberOverflowWarning;
import com.ibm.xml.ecm.schema.FloatingNumberUnderflowWarning;
import com.ibm.xml.ecm.schema.impl.BuiltInDatatypeFactory;
import com.ibm.xml.ecm.schema.impl.Debug;
import com.ibm.xml.ecm.schema.impl.NumericLiteral;

public class FloatLiteral
extends NumericLiteral
implements Cloneable {
    public static final String copyright = "Licensed Materials - Property of IBM (C) Copyright IBM Corp. 2000, 2001, 2002    All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private String specialValue;
    private String valueAsString;
    private Exception warning;

    private FloatLiteral() {
    }

    public FloatLiteral(String string) throws DatatypeFormatException {
        super(string);
    }

    public Object clone() {
        FloatLiteral floatLiteral = new FloatLiteral();
        floatLiteral.value = new Float(this.value.floatValue());
        return floatLiteral;
    }

    public int compareTo(Object object) {
        if (object instanceof FloatLiteral) {
            float f;
            FloatLiteral floatLiteral = (FloatLiteral)object;
            float f2 = ((Number)this.getValue()).floatValue();
            if (f2 == (f = ((Number)((FloatLiteral)object).getValue()).floatValue())) {
                if (this.specialValue != null) {
                    if (this.specialValue.trim().equals("0")) {
                        return floatLiteral.specialValue.trim().equals("0") ? 0 : 1;
                    }
                    if (this.specialValue.trim().equals("-0")) {
                        return floatLiteral.specialValue.trim().equals("-0") ? 0 : -1;
                    }
                }
                return 0;
            }
            if (Float.isNaN(f2) && Float.isNaN(f)) {
                return 0;
            }
            if (Float.isNaN(f2)) {
                throw new IllegalArgumentException(object + " and " + this + " are not comparable");
            }
            if (Float.isNaN(f)) {
                throw new IllegalArgumentException(object + " and " + this + " are not comparable");
            }
            if (f < f2) {
                return 1;
            }
            return -1;
        }
        return super.compareTo(object);
    }

    protected void conversion(String string) throws DatatypeFormatException {
        this.valueAsString = string;
        try {
            if (string.trim().equals("INF")) {
                this.specialValue = "INF";
                this.value = new Float(Float.POSITIVE_INFINITY);
            } else if (string.trim().equals("-INF")) {
                this.specialValue = "-INF";
                this.value = new Float(Float.NEGATIVE_INFINITY);
            } else if (string.trim().equals("NaN")) {
                this.specialValue = "NaN";
                this.value = new Float(Float.NaN);
            } else if (string.trim().equals("0")) {
                this.specialValue = "0";
                this.value = Float.valueOf("0");
            } else if (string.trim().equals("-0")) {
                this.specialValue = "-0";
                this.value = Float.valueOf("-0");
            } else {
                this.value = Float.valueOf(string.trim());
                float f = this.value.floatValue();
                boolean bl = false;
                if (f < 0.0f) {
                    f = -f;
                    bl = true;
                }
                if (f > Float.MAX_VALUE) {
                    this.warning = new FloatingNumberOverflowWarning(string.trim(), false);
                    if (!bl) {
                        this.specialValue = "INF";
                        this.value = new Float(Float.POSITIVE_INFINITY);
                    } else {
                        this.specialValue = "-INF";
                        this.value = new Float(Float.NEGATIVE_INFINITY);
                    }
                } else if (f == 0.0f && !FloatLiteral.isZero(string.trim())) {
                    this.warning = new FloatingNumberUnderflowWarning(string.trim(), false);
                    if (string.trim().length() > 0) {
                        bl = string.trim().substring(0, 1).equals("-");
                    }
                    if (!bl) {
                        this.specialValue = "0";
                        this.value = Float.valueOf("0");
                    } else {
                        this.specialValue = "-0";
                        this.value = Float.valueOf("-0");
                    }
                } else if (f == 0.0f) {
                    if (string.trim().length() > 0) {
                        bl = string.trim().substring(0, 1).equals("-");
                    }
                    if (bl) {
                        this.specialValue = "-0";
                        this.value = Float.valueOf("-0");
                    } else {
                        this.specialValue = "0";
                        this.value = Float.valueOf("0");
                    }
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            if (Debug.DEBUG) {
                numberFormatException.printStackTrace(System.err);
            }
            throw new DatatypeFormatException(BuiltInDatatypeFactory.getInstance().getBuiltInDatatype("float"), string);
        }
    }

    public Object getValue() {
        return this.value;
    }

    public Exception getWarning() {
        return this.warning;
    }

    private static boolean hasANoneZeroDigit(String string) {
        int n = 0;
        while (n < string.length()) {
            try {
                int n2 = Integer.parseInt(string.substring(n, n + 1));
                if (n2 > 0) {
                    return true;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            ++n;
        }
        return false;
    }

    static boolean isZero(String string) {
        int n = string.indexOf("e");
        if (n == -1) {
            n = string.indexOf("E");
        }
        if (n == -1) {
            return !FloatLiteral.hasANoneZeroDigit(string);
        }
        String string2 = string.substring(0, n);
        return !FloatLiteral.hasANoneZeroDigit(string2);
    }

    public static void main(String[] stringArray) {
        Float f = new Float("3.4028236692093846346337460743e-20038");
        Float f2 = new Float("0");
        System.out.println(f.floatValue() > Float.MAX_VALUE);
        System.out.println(f.compareTo(f2));
        System.out.println(f.compareTo(new Float("-2.3509887016445750159374730744e-38")));
    }

    public String toString() {
        return this.valueAsString;
    }

    public boolean isTotallyOrdered() {
        return false;
    }

    public boolean isComparable(Object object, boolean[] blArray) {
        if (object instanceof FloatLiteral) {
            FloatLiteral floatLiteral = (FloatLiteral)object;
            boolean bl = ((Float)this.getValue()).isNaN();
            boolean bl2 = ((Float)floatLiteral.getValue()).isNaN();
            if (bl || bl2) {
                if (bl && bl2) {
                    if (blArray == null) {
                        return true;
                    }
                    blArray[0] = true;
                    return true;
                }
                return false;
            }
            if (blArray == null) {
                return true;
            }
            blArray[0] = this.inOrder(object);
            return true;
        }
        return false;
    }
}

