/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.ecm.schema.impl;

import com.ibm.mof.mof13.extn.impl.MOFAttributeSetting;
import com.ibm.sketch.viewandvisitor.SchemaObjectVisitor;
import com.ibm.xmi.xmi11temp.IBMXMIDocument;
import com.ibm.xml.ecm.schema.AttributeRef;
import com.ibm.xml.ecm.schema.DatatypeRef;
import com.ibm.xml.ecm.schema.DatatypeSpec;
import com.ibm.xml.ecm.schema.GlobalAttributeDecl;
import com.ibm.xml.ecm.schema.Reference;
import com.ibm.xml.ecm.schema.ReferenceResolutionException;
import com.ibm.xml.ecm.schema.Schema;
import com.ibm.xml.ecm.schema.SchemaObject;
import com.ibm.xml.ecm.schema.SimpleType;
import com.ibm.xml.ecm.schema.State;
import com.ibm.xml.ecm.schema.TopComponent;
import com.ibm.xml.ecm.schema.TypeInfo;
import com.ibm.xml.ecm.schema.TypeRef;
import com.ibm.xml.ecm.schema.URI;
import com.ibm.xml.ecm.schema.gen.impl.FactoryImplGen;
import com.ibm.xml.ecm.schema.gen.impl.GlobalAttributeDeclImplGen;
import com.ibm.xml.ecm.schema.impl.AttributeXmlnsNotAllowed_Checker;
import com.ibm.xml.ecm.schema.impl.AttributeXsiNotAllowed_Checker;
import com.ibm.xml.ecm.schema.impl.AttributesIncompatible_Checker;
import com.ibm.xml.ecm.schema.impl.Checker;
import com.ibm.xml.ecm.schema.impl.DatatypeSpecImpl;
import com.ibm.xml.ecm.schema.impl.FactoryImpl;
import com.ibm.xml.ecm.schema.impl.SchemaImpl;
import com.ibm.xml.ecm.schema.impl.SchemaObjectImpl;
import com.ibm.xml.ecm.schema.impl.SimpleType_Checker;
import com.ibm.xml.ecm.schema.impl.TypeSpecImpl;
import com.ibm.xml.ecm.schema.impl.WhiteSpaceFacetStrategy;
import java.util.Arrays;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class GlobalAttributeDeclImpl
extends GlobalAttributeDeclImplGen
implements GlobalAttributeDecl {
    public static final String copyright = "Licensed Materials - Property of IBM (C) Copyright IBM Corp. 2000, 2001, 2002    All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private boolean mustReturnTypeSpec = false;
    private Checker checkers;

    public void accept(SchemaObjectVisitor schemaObjectVisitor) {
        schemaObjectVisitor.visitGlobalAttributeDecl(this);
    }

    public void applied(MOFAttributeSetting mOFAttributeSetting) {
        super.applied(mOFAttributeSetting);
        this.primApplied(mOFAttributeSetting);
    }

    public void applied(MOFAttributeSetting mOFAttributeSetting, int n, MOFAttributeSetting mOFAttributeSetting2) {
        super.applied(mOFAttributeSetting, n, mOFAttributeSetting2);
        this.primApplied(mOFAttributeSetting);
    }

    public boolean equals(Object object) {
        if (object instanceof GlobalAttributeDecl) {
            GlobalAttributeDecl globalAttributeDecl = (GlobalAttributeDecl)object;
            return this.fNCName.trim().equals(globalAttributeDecl.getNCName().trim());
        }
        return false;
    }

    public Checker[] getCheckers() {
        Object var1_1 = null;
        Vector<Checker> vector = new Vector<Checker>();
        vector.addAll(Arrays.asList(super.getCheckers()));
        Object[] objectArray = null;
        if (this.fNCName != null) {
            vector.add(new AttributeXsiNotAllowed_Checker(this));
            vector.add(new AttributeXmlnsNotAllowed_Checker(this));
        }
        if (this.fdatatypeSpec != null && this.ffixed != null) {
            vector.add(new SimpleType_Checker(this.fdatatypeSpec, this, this.ffixed, -2));
        }
        if (this.fdatatypeSpec != null && this.fdefault != null) {
            vector.add(new SimpleType_Checker(this.fdatatypeSpec, this, this.fdefault, -3));
        }
        if (vector.size() > 0) {
            objectArray = new Checker[vector.size()];
            vector.copyInto(objectArray);
        }
        return objectArray;
    }

    public int getComponentType() {
        return 6;
    }

    public String getDefaultAsString() {
        return this.getDefault();
    }

    public String getFixedAsString() {
        return this.getFixed();
    }

    public SchemaObject[] getSchemaObjectChildrenForVSD() {
        if (this.mustReturnTypeSpec && this.fdatatypeSpec != null) {
            return new SchemaObject[]{this.fdatatypeSpec};
        }
        return ((DatatypeSpecImpl)this.fdatatypeSpec).getSchemaObjectChildrenForVSD();
    }

    public State getState(boolean bl) {
        State state = super.getState(bl);
        return state;
    }

    public SimpleType getType() throws ReferenceResolutionException {
        if (this.mustReturnTypeSpec) {
            return this.fdatatypeSpec;
        }
        if (this.fdatatypeSpec != null && ((DatatypeSpecImpl)this.fdatatypeSpec).isIdenticalToItsBasetype()) {
            TypeInfo typeInfo = this.fdatatypeSpec.getBasetype();
            if (typeInfo != null) {
                return (SimpleType)typeInfo.resolveToType();
            }
            return null;
        }
        return this.fdatatypeSpec;
    }

    public DatatypeRef getTypeRef() {
        if (this.mustReturnTypeSpec) {
            return null;
        }
        if (this.fdatatypeSpec != null && ((TypeSpecImpl)((Object)this.fdatatypeSpec)).isIdenticalToItsBasetype()) {
            TypeInfo typeInfo = this.fdatatypeSpec.getBasetype();
            if (typeInfo != null) {
                return (DatatypeRef)typeInfo.asTypeRef();
            }
            return null;
        }
        return null;
    }

    public int getUse() {
        return 0;
    }

    public Reference makeReference(int n, Schema schema, String string, Vector vector) {
        AttributeRef attributeRef = null;
        FactoryImpl factoryImpl = (FactoryImpl)FactoryImpl.instance();
        IBMXMIDocument iBMXMIDocument = factoryImpl.getCurrentDocument();
        if (schema != null) {
            factoryImpl.setCurrentDocument((IBMXMIDocument)schema.getXMIDocument());
        } else {
            factoryImpl.setCurrentDocument(SchemaObjectImpl.getDefaultXMIDocument());
        }
        URI uRI = ((SchemaImpl)this.getSchema()).getTargetNamespace();
        if (uRI == null && schema != this.getSchema()) {
            attributeRef = null;
        } else {
            attributeRef = factoryImpl.createAttributeRef(this.getNCName(), ((SchemaImpl)this.getSchema()).getTargetNamespaceOrDefaultTargetNamespace(), string, vector);
            this.addReference(attributeRef);
        }
        factoryImpl.setCurrentDocument(iBMXMIDocument);
        return attributeRef;
    }

    private void primApplied(MOFAttributeSetting mOFAttributeSetting) {
        if (mOFAttributeSetting.getMetaObject() == FactoryImplGen.TopComponent_NCName) {
            this.handleErrorInInteractiveMode(new AttributeXmlnsNotAllowed_Checker(this));
            return;
        }
        if (mOFAttributeSetting.getMetaObject() == FactoryImplGen.GlobalAttributeDecl_datatypeSpec) {
            if (this.ffixed != null) {
                this.handleErrorInInteractiveMode(new SimpleType_Checker(this.fdatatypeSpec, this, WhiteSpaceFacetStrategy.normalize(this.ffixed, this.fdatatypeSpec), -2));
            } else if (this.fdefault != null) {
                this.handleErrorInInteractiveMode(new SimpleType_Checker(this.fdatatypeSpec, this, WhiteSpaceFacetStrategy.normalize(this.fdefault, this.fdatatypeSpec), -3));
            }
            return;
        }
        if (mOFAttributeSetting.getMetaObject() == FactoryImplGen.GlobalAttributeDecl_fixed) {
            if (this.ffixed != null) {
                if (this.fdatatypeSpec != null) {
                    this.handleErrorInInteractiveMode(new SimpleType_Checker(this.fdatatypeSpec, this, WhiteSpaceFacetStrategy.normalize(this.ffixed, this.fdatatypeSpec), -2));
                }
                this.handleErrorInInteractiveMode(new AttributesIncompatible_Checker(this, this.fdatatypeSpec, "fixed", this.ffixed, "default", this.fdefault));
            }
            return;
        }
        if (mOFAttributeSetting.getMetaObject() == FactoryImplGen.GlobalAttributeDecl_default) {
            if (this.fdefault != null) {
                if (this.fdatatypeSpec != null) {
                    this.handleErrorInInteractiveMode(new SimpleType_Checker(this.fdatatypeSpec, this, WhiteSpaceFacetStrategy.normalize(this.fdefault, this.fdatatypeSpec), -3));
                }
                this.handleErrorInInteractiveMode(new AttributesIncompatible_Checker(this, this.fdatatypeSpec, "fixed", this.ffixed, "default", this.fdefault));
            }
            return;
        }
        if (mOFAttributeSetting.getMetaObject() == FactoryImplGen.TopComponent_schema) {
            this.handleErrorInInteractiveMode(new AttributeXsiNotAllowed_Checker(this));
            return;
        }
    }

    public void setType(DatatypeRef datatypeRef) {
        if (this.fdatatypeSpec == null) {
            DatatypeSpec datatypeSpec = (DatatypeSpec)((Object)((IBMXMIDocument)this.getXMIDocument()).newInstance(FactoryImplGen.DatatypeSpec_MOFClass));
            datatypeSpec.setParent(this);
            datatypeSpec.setDerivationType(1000);
            datatypeSpec.addUsedtypeRef(datatypeRef);
            this.setDatatypeSpec(datatypeSpec);
        } else {
            ((DatatypeSpecImpl)this.fdatatypeSpec).removeAllUsedtypes();
            this.fdatatypeSpec.addUsedtypeRef(datatypeRef);
        }
        this.mustReturnTypeSpec = false;
    }

    public void setType(SimpleType simpleType) {
        if (simpleType.isAnonymous()) {
            this.setDatatypeSpec((DatatypeSpec)simpleType);
            this.mustReturnTypeSpec = true;
        } else {
            DatatypeRef datatypeRef = (DatatypeRef)((TopComponent)((Object)simpleType)).makeReference(-1, this.getTopComponentAncestor().getSchema(), "a", null);
            this.setType(datatypeRef);
        }
    }

    public Node toXMLRepresentation(Document document) {
        Element element = document.createElement(this.getTagNameWithPrefix("attribute"));
        this.addNamespaceDeclaration(element);
        if (this.fNCName != null) {
            element.setAttribute("name", this.fNCName);
        }
        if (this.getID() != null) {
            element.setAttribute("id", this.getID());
        }
        if (this.ffixed != null) {
            element.setAttribute("fixed", this.ffixed);
        }
        if (this.fdefault != null) {
            element.setAttribute("default", this.fdefault);
        }
        if (this.fannotation != null) {
            element.appendChild(this.fannotation.toXMLRepresentation(document));
        }
        if (this.fdatatypeSpec != null) {
            TypeRef typeRef;
            TypeRef typeRef2 = typeRef = this.fdatatypeSpec.getBasetype() == null ? null : this.fdatatypeSpec.getBasetype().asTypeRef();
            if (((DatatypeSpecImpl)this.fdatatypeSpec).isIdenticalToItsBasetype() && typeRef != null) {
                element.setAttribute("type", typeRef.getQName());
                ((SchemaObjectImpl)((Object)typeRef)).addNamespaceDeclaration(element);
            } else {
                element.appendChild(this.fdatatypeSpec.toXMLRepresentation(document));
            }
        }
        return element;
    }
}

