/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.ecm.schema.impl;

import com.ibm.sketch.util.CollectionWithDuplications;
import com.ibm.sketch.viewandvisitor.IdentityConstraintFinder;
import com.ibm.xml.ecm.schema.IdentityConstraint;
import com.ibm.xml.ecm.schema.impl.CheckerManagerImpl;
import com.ibm.xml.ecm.schema.impl.SchemaImpl;
import com.ibm.xml.ecm.schema.impl.SchemaObjectImpl;
import com.ibm.xml.ecm.schema.impl.VeryFastAlreadyDefinedIdentityConstraint_Checker;
import java.util.Arrays;

public class IdConstraintHelper {
    public static final String copyright = "Licensed Materials - Property of IBM (C) Copyright IBM Corp. 2000, 2001, 2002    All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    static void addedToItsParent(SchemaObjectImpl schemaObjectImpl) {
        SchemaImpl schemaImpl = (SchemaImpl)schemaObjectImpl.getSchema();
        if (schemaImpl == null) {
            return;
        }
        IdentityConstraintFinder identityConstraintFinder = new IdentityConstraintFinder();
        schemaObjectImpl.accept(identityConstraintFinder);
        IdentityConstraint[] identityConstraintArray = identityConstraintFinder.getIdentityConstraint();
        if (identityConstraintArray == null || identityConstraintArray.length == 0) {
            return;
        }
        CollectionWithDuplications collectionWithDuplications = schemaImpl.getIdentityConstraints();
        if (collectionWithDuplications != null) {
            collectionWithDuplications.addAll(Arrays.asList(identityConstraintArray));
        }
        if (schemaImpl instanceof SchemaImpl) {
            CheckerManagerImpl checkerManagerImpl = CheckerManagerImpl.getInstance();
            int n = 0;
            while (n < identityConstraintArray.length) {
                VeryFastAlreadyDefinedIdentityConstraint_Checker veryFastAlreadyDefinedIdentityConstraint_Checker = new VeryFastAlreadyDefinedIdentityConstraint_Checker(schemaImpl, identityConstraintArray[n]);
                if (!checkerManagerImpl.check(veryFastAlreadyDefinedIdentityConstraint_Checker, true)) {
                    schemaImpl.handleError(veryFastAlreadyDefinedIdentityConstraint_Checker.getExceptions());
                }
                ++n;
            }
        }
    }

    static void removedFromItsParent(SchemaObjectImpl schemaObjectImpl) {
        SchemaImpl schemaImpl = (SchemaImpl)schemaObjectImpl.getSchema();
        if (schemaImpl == null) {
            return;
        }
        IdentityConstraintFinder identityConstraintFinder = new IdentityConstraintFinder();
        schemaObjectImpl.accept(identityConstraintFinder);
        IdentityConstraint[] identityConstraintArray = identityConstraintFinder.getIdentityConstraint();
        if (identityConstraintArray == null || identityConstraintArray.length == 0) {
            return;
        }
        CollectionWithDuplications collectionWithDuplications = schemaImpl.getIdentityConstraints();
        if (collectionWithDuplications != null) {
            int n = 0;
            while (n < identityConstraintArray.length) {
                collectionWithDuplications.remove(identityConstraintArray[n], true);
                ++n;
            }
        }
    }
}

