/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.ecm.schema.impl;

import com.ibm.xml.ecm.schema.IdentityConstraint;
import com.ibm.xml.ecm.schema.KeyRef;
import com.ibm.xml.ecm.schema.KeyRefNumberOfFieldsIncompatibleWithKeyException;
import com.ibm.xml.ecm.schema.SchemaException;
import com.ibm.xml.ecm.schema.impl.AbstractChecker;
import com.ibm.xml.ecm.schema.impl.CheckType;
import com.ibm.xml.ecm.schema.impl.Debug;

public class KeyRefNumberOfFields_Checker
extends AbstractChecker {
    public static final String copyright = "Licensed Materials - Property of IBM (C) Copyright IBM Corp. 2000, 2001, 2002    All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private SchemaException[] fExceptions;
    public static CheckType ID = new CheckType("KeyRef number of fields checker");
    static /* synthetic */ Class class$com$ibm$xml$ecm$schema$KeyRef;

    public KeyRefNumberOfFields_Checker(KeyRef keyRef) {
        super(keyRef);
    }

    public boolean check(boolean bl) {
        block7: {
            this.fExceptions = null;
            try {
                KeyRef keyRef = (KeyRef)this.subject;
                IdentityConstraint identityConstraint = keyRef.resolve(true);
                if (identityConstraint != null) {
                    String[] stringArray = identityConstraint.getFields();
                    String[] stringArray2 = keyRef.getFields();
                    if (stringArray != null && stringArray.length > 0) {
                        if (stringArray2 == null || stringArray.length != stringArray2.length) {
                            this.fExceptions = new SchemaException[]{new KeyRefNumberOfFieldsIncompatibleWithKeyException(keyRef, identityConstraint)};
                            return false;
                        }
                    } else if (stringArray2 != null && stringArray2.length > 0) {
                        this.fExceptions = new SchemaException[]{new KeyRefNumberOfFieldsIncompatibleWithKeyException(keyRef, identityConstraint)};
                        return false;
                    }
                }
            }
            catch (SchemaException schemaException) {
                if (!Debug.DEBUG) break block7;
                schemaException.printStackTrace(System.err);
            }
        }
        return true;
    }

    public CheckType getCheckType() {
        return ID;
    }

    public int getCost() {
        return 3;
    }

    public SchemaException[] getExceptions() {
        return this.fExceptions;
    }

    public Class getSubjectClass() {
        return class$com$ibm$xml$ecm$schema$KeyRef == null ? (class$com$ibm$xml$ecm$schema$KeyRef = KeyRefNumberOfFields_Checker.class$("com.ibm.xml.ecm.schema.KeyRef")) : class$com$ibm$xml$ecm$schema$KeyRef;
    }

    public boolean isNeverActivateInInterativeMode() {
        return true;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        CheckType.register(ID);
    }
}

