/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.ecm.schema.impl;

import com.ibm.xml.ecm.schema.DatatypeFormatException;
import com.ibm.xml.ecm.schema.Facet;
import com.ibm.xml.ecm.schema.FacetConstraintException;
import com.ibm.xml.ecm.schema.InvalidStateException;
import com.ibm.xml.ecm.schema.MutuallyExclusiveFacetsException;
import com.ibm.xml.ecm.schema.SchemaException;
import com.ibm.xml.ecm.schema.SimpleType;
import com.ibm.xml.ecm.schema.Type;
import com.ibm.xml.ecm.schema.impl.BuiltInDatatypeFactory;
import com.ibm.xml.ecm.schema.impl.Debug;
import com.ibm.xml.ecm.schema.impl.FacetImpl;
import com.ibm.xml.ecm.schema.impl.FacetStrategy;
import java.math.BigInteger;

abstract class LengthFacetStrategy
extends FacetStrategy {
    public static final String copyright = "Licensed Materials - Property of IBM (C) Copyright IBM Corp. 2000, 2001, 2002    All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    LengthFacetStrategy() {
    }

    SchemaException[] compatibleWithOtherFacet(Type type, Facet facet, Facet facet2, boolean bl) {
        try {
            if (facet.getFacetType() != 7) {
                return null;
            }
            SchemaException[] schemaExceptionArray = super.compatibleWithOtherFacet(type, facet, facet2, bl);
            if (schemaExceptionArray != null) {
                return schemaExceptionArray;
            }
            switch (facet2.getFacetType()) {
                case 10: 
                case 11: {
                    if (bl) {
                        return new SchemaException[]{new MutuallyExclusiveFacetsException(type, facet, facet2, !bl)};
                    }
                    if (facet2.getFacetType() == 11) {
                        if (this.getValue(facet).compareTo(facet2.getValueAsObject()) >= 0) break;
                        return new SchemaException[]{new FacetConstraintException(type, facet, facet2, !bl, "less than")};
                    }
                    if (this.getValue(facet).compareTo(facet2.getValueAsObject()) <= 0) break;
                    return new SchemaException[]{new FacetConstraintException(type, facet, facet2, !bl, "great than")};
                }
            }
            return null;
        }
        catch (SchemaException schemaException) {
            if (Debug.DEBUG) {
                schemaException.printStackTrace();
            }
            return null;
        }
    }

    Object convertToAppropriatedObject(String[] stringArray) throws DatatypeFormatException {
        try {
            BigInteger bigInteger = new BigInteger(stringArray[0].trim());
            if (bigInteger.signum() < 0) {
                throw new DatatypeFormatException((SimpleType)BuiltInDatatypeFactory.getInstance().getBuiltInDatatype("nonNegativeInteger"), stringArray[0], 7);
            }
            return bigInteger;
        }
        catch (NumberFormatException numberFormatException) {
            if (Debug.DEBUG) {
                numberFormatException.printStackTrace();
            }
            throw new DatatypeFormatException((SimpleType)BuiltInDatatypeFactory.getInstance().getBuiltInDatatype("nonNegativeInteger"), stringArray[0], 7);
        }
    }

    protected BigInteger getValue(Facet facet) throws ClassCastException, DatatypeFormatException, InvalidStateException {
        BigInteger bigInteger = null;
        if (facet instanceof FacetImpl) {
            bigInteger = (BigInteger)((FacetImpl)facet).getValueAsObject();
        }
        if (bigInteger == null) {
            bigInteger = (BigInteger)this.convertToAppropriatedObject(facet.getValuesAsString());
        }
        return bigInteger;
    }

    boolean inOrder(Facet facet, Facet facet2) {
        try {
            if (facet == null || facet2 == null) {
                return false;
            }
            return this.getValue(facet).compareTo(this.getValue(facet2)) < 1;
        }
        catch (InvalidStateException invalidStateException) {
            if (Debug.DEBUG) {
                invalidStateException.printStackTrace();
            }
            return false;
        }
        catch (DatatypeFormatException datatypeFormatException) {
            if (Debug.DEBUG) {
                datatypeFormatException.printStackTrace();
            }
            return false;
        }
        catch (ClassCastException classCastException) {
            if (Debug.DEBUG) {
                classCastException.printStackTrace();
            }
            return false;
        }
        catch (NullPointerException nullPointerException) {
            if (Debug.DEBUG) {
                nullPointerException.printStackTrace();
            }
            return false;
        }
    }

    boolean isEqual(Facet facet, Facet facet2) {
        try {
            if (facet == null || facet2 == null) {
                return false;
            }
            return this.getValue(facet).equals(this.getValue(facet2));
        }
        catch (InvalidStateException invalidStateException) {
            if (Debug.DEBUG) {
                invalidStateException.printStackTrace();
            }
            return false;
        }
        catch (DatatypeFormatException datatypeFormatException) {
            if (Debug.DEBUG) {
                datatypeFormatException.printStackTrace();
            }
            return false;
        }
        catch (ClassCastException classCastException) {
            if (Debug.DEBUG) {
                classCastException.printStackTrace();
            }
            return false;
        }
        catch (NullPointerException nullPointerException) {
            if (Debug.DEBUG) {
                nullPointerException.printStackTrace();
            }
            return false;
        }
    }

    abstract boolean validate(Facet var1, String var2);
}

