/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.ecm.schema.impl;

import com.ibm.xml.ecm.schema.BuiltInDatatypeDef;
import com.ibm.xml.ecm.schema.DatatypeFormatException;
import com.ibm.xml.ecm.schema.Facet;
import com.ibm.xml.ecm.schema.FacetConstraintException;
import com.ibm.xml.ecm.schema.FixedBasetypeExclusiveInclusiveFacetException;
import com.ibm.xml.ecm.schema.InvalidStateException;
import com.ibm.xml.ecm.schema.MutuallyExclusiveFacetsException;
import com.ibm.xml.ecm.schema.SchemaException;
import com.ibm.xml.ecm.schema.Type;
import com.ibm.xml.ecm.schema.impl.Debug;
import com.ibm.xml.ecm.schema.impl.Order;
import com.ibm.xml.ecm.schema.impl.OrderFacetStrategy;

class MaxInclusiveFacetStrategy
extends OrderFacetStrategy {
    protected BuiltInDatatypeDef builtInDatatype;

    MaxInclusiveFacetStrategy(BuiltInDatatypeDef builtInDatatypeDef) {
        super(builtInDatatypeDef);
    }

    SchemaException[] compatibleWithOtherFacet(Type type, Facet facet, Facet facet2, boolean bl) {
        block22: {
            if (facet.getFacetType() != 1) {
                return null;
            }
            try {
                switch (facet2.getFacetType()) {
                    case 2: 
                    case 3: 
                    case 4: {
                        Order order = (Order)facet.getValueAsObject();
                        Order order2 = (Order)facet2.getValueAsObject();
                        if (!(order != null & order2 != null) || order.isComparable(order2, new boolean[1])) break;
                        return new SchemaException[]{new FacetConstraintException(type, facet, facet2, !bl, "not comparable with")};
                    }
                }
                switch (facet2.getFacetType()) {
                    case 3: {
                        if (facet.getParent() != null && facet2.getParent() != null && facet.getParent() != facet2.getParent()) {
                            Order order = (Order)facet.getValueAsObject();
                            Order order3 = (Order)facet2.getValueAsObject();
                            if (order == null || order3 == null) break;
                            if (facet2.isFixed()) {
                                Order order4 = OrderFacetStrategy.previous(type, order3);
                                if (order4 == null) {
                                    return new SchemaException[]{new FixedBasetypeExclusiveInclusiveFacetException(type, facet, facet2, !bl, null)};
                                }
                                if (!order.isEqual(order4)) {
                                    return new SchemaException[]{new FixedBasetypeExclusiveInclusiveFacetException(type, facet, facet2, !bl, order4.toString())};
                                }
                                return null;
                            }
                            if (order.isComparable(order3, null) && !order.isEqual(order3) && order.inOrder(order3)) break;
                            return new SchemaException[]{new FacetConstraintException(type, facet, facet2, !bl, "less than")};
                        }
                        return new SchemaException[]{new MutuallyExclusiveFacetsException(type, facet, facet2, !bl)};
                    }
                    case 2: {
                        Order order = (Order)facet.getValueAsObject();
                        Order order5 = (Order)facet2.getValueAsObject();
                        if (order == null || order5 == null || order.isComparable(order5, null) && (order.isEqual(order5) || !order.inOrder(order5))) break;
                        return new SchemaException[]{new FacetConstraintException(type, facet, facet2, !bl, "less than")};
                    }
                    case 4: {
                        Order order = (Order)facet.getValueAsObject();
                        Order order6 = (Order)facet2.getValueAsObject();
                        if (order == null || order6 == null || order.isComparable(order6, null) && !order.inOrder(order6)) break;
                        return new SchemaException[]{new FacetConstraintException(type, facet, facet2, !bl, "less than or equal")};
                    }
                    case 6: {
                        return this.compatibleWithEnumFacet(type, facet, facet2, bl);
                    }
                }
            }
            catch (DatatypeFormatException datatypeFormatException) {
                if (Debug.DEBUG) {
                    datatypeFormatException.printStackTrace(System.err);
                }
            }
            catch (InvalidStateException invalidStateException) {
                if (Debug.DEBUG) {
                    invalidStateException.printStackTrace(System.err);
                }
            }
            catch (SchemaException schemaException) {
                if (Debug.DEBUG) {
                    schemaException.printStackTrace(System.err);
                }
            }
            catch (ClassCastException classCastException) {
                if (!Debug.DEBUG) break block22;
                classCastException.printStackTrace(System.err);
            }
        }
        return null;
    }

    protected int getFacetType() {
        return 1;
    }

    boolean inOrder(Facet facet, Facet facet2) {
        if (facet == null || facet2 == null) {
            return false;
        }
        try {
            Order order = this.getValue(facet);
            Order order2 = this.getValue(facet2);
            boolean[] blArray = new boolean[1];
            if (order.isComparable(order2, blArray)) {
                return blArray[0];
            }
            return false;
        }
        catch (InvalidStateException invalidStateException) {
            if (Debug.DEBUG) {
                invalidStateException.printStackTrace();
            }
            return false;
        }
        catch (DatatypeFormatException datatypeFormatException) {
            if (Debug.DEBUG) {
                datatypeFormatException.printStackTrace();
            }
            return false;
        }
        catch (ClassCastException classCastException) {
            if (Debug.DEBUG) {
                classCastException.printStackTrace();
            }
            return false;
        }
    }

    boolean isEqual(Facet facet, Facet facet2) {
        if (facet == null || facet2 == null) {
            return false;
        }
        try {
            Order order = this.getValue(facet);
            Order order2 = this.getValue(facet2);
            return order.isEqual(order2);
        }
        catch (InvalidStateException invalidStateException) {
            if (Debug.DEBUG) {
                invalidStateException.printStackTrace();
            }
            return false;
        }
        catch (DatatypeFormatException datatypeFormatException) {
            if (Debug.DEBUG) {
                datatypeFormatException.printStackTrace();
            }
            return false;
        }
        catch (ClassCastException classCastException) {
            if (Debug.DEBUG) {
                classCastException.printStackTrace();
            }
            return false;
        }
    }

    boolean validate(Facet facet, Order order) {
        try {
            Order order2 = this.getValue(facet);
            if (order.isComparable(order2, null)) {
                return order.inOrder(order2);
            }
            return false;
        }
        catch (InvalidStateException invalidStateException) {
            if (Debug.DEBUG) {
                invalidStateException.printStackTrace();
            }
            return false;
        }
        catch (DatatypeFormatException datatypeFormatException) {
            if (Debug.DEBUG) {
                datatypeFormatException.printStackTrace();
            }
            return false;
        }
        catch (NullPointerException nullPointerException) {
            if (Debug.DEBUG) {
                nullPointerException.printStackTrace();
            }
            return false;
        }
        catch (ClassCastException classCastException) {
            if (Debug.DEBUG) {
                classCastException.printStackTrace();
            }
            return false;
        }
    }
}

