/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.ecm.schema.impl;

import com.ibm.xml.ecm.schema.DatatypeFormatException;
import com.ibm.xml.ecm.schema.Facet;
import com.ibm.xml.ecm.schema.InvalidStateException;
import com.ibm.xml.ecm.schema.PrimitiveDatatype;
import com.ibm.xml.ecm.schema.impl.BinaryLiteral;
import com.ibm.xml.ecm.schema.impl.Debug;
import com.ibm.xml.ecm.schema.impl.MaxLengthFacetStrategy;
import java.math.BigInteger;

public class MaxLengthBinaryFacetStrategy
extends MaxLengthFacetStrategy {
    public static final String copyright = "Licensed Materials - Property of IBM (C) Copyright IBM Corp. 2000, 2001, 2002    All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private PrimitiveDatatype primType;

    public MaxLengthBinaryFacetStrategy(PrimitiveDatatype primitiveDatatype) {
        this.primType = primitiveDatatype;
        if (!primitiveDatatype.getNCName().equals("base64Binary") && !primitiveDatatype.getNCName().equals("hexBinary")) {
            throw new IllegalArgumentException(primitiveDatatype + " must be either " + "base64Binary" + " or " + "hexBinary");
        }
    }

    boolean validate(Facet facet, String string) {
        try {
            if (facet == null || string == null) {
                return false;
            }
            BinaryLiteral binaryLiteral = (BinaryLiteral)this.primType.convert(string);
            if (binaryLiteral.isEncodingKnown()) {
                return BigInteger.valueOf(binaryLiteral.getBytes().length).compareTo(this.getValue(facet)) <= 0;
            }
            return true;
        }
        catch (InvalidStateException invalidStateException) {
            if (Debug.DEBUG) {
                invalidStateException.printStackTrace();
            }
            return false;
        }
        catch (DatatypeFormatException datatypeFormatException) {
            if (Debug.DEBUG) {
                datatypeFormatException.printStackTrace();
            }
            return false;
        }
    }
}

