/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.ecm.schema.impl;

import com.ibm.xml.ecm.schema.DatatypeFormatException;
import com.ibm.xml.ecm.schema.Facet;
import com.ibm.xml.ecm.schema.FacetConstraintException;
import com.ibm.xml.ecm.schema.InvalidStateException;
import com.ibm.xml.ecm.schema.MutuallyExclusiveFacetsException;
import com.ibm.xml.ecm.schema.SchemaException;
import com.ibm.xml.ecm.schema.SimpleType;
import com.ibm.xml.ecm.schema.Type;
import com.ibm.xml.ecm.schema.impl.BuiltInDatatypeFactory;
import com.ibm.xml.ecm.schema.impl.Debug;
import com.ibm.xml.ecm.schema.impl.FacetImpl;
import com.ibm.xml.ecm.schema.impl.FacetStrategy;
import java.math.BigInteger;

abstract class MaxLengthFacetStrategy
extends FacetStrategy {
    MaxLengthFacetStrategy() {
    }

    SchemaException[] compatibleWithOtherFacet(Type type, Facet facet, Facet facet2, boolean bl) {
        block13: {
            if (facet.getFacetType() != 10) {
                return null;
            }
            SchemaException[] schemaExceptionArray = super.compatibleWithOtherFacet(type, facet, facet2, bl);
            if (schemaExceptionArray != null) {
                return schemaExceptionArray;
            }
            try {
                switch (facet2.getFacetType()) {
                    case 7: {
                        if (bl) {
                            return new SchemaException[]{new MutuallyExclusiveFacetsException(type, facet, facet2, !bl)};
                        }
                        if (this.getValue(facet).compareTo(facet2.getValueAsObject()) >= 0) break;
                        return new SchemaException[]{new FacetConstraintException(type, facet, facet2, !bl, "less than")};
                    }
                    case 11: {
                        Comparable comparable = (Comparable)facet.getValueAsObject();
                        Comparable comparable2 = (Comparable)facet2.getValueAsObject();
                        if (comparable == null || comparable2 == null || comparable.compareTo(comparable2) > -1) break;
                        return new SchemaException[]{new FacetConstraintException(type, facet, facet2, !bl, "less than")};
                    }
                }
            }
            catch (DatatypeFormatException datatypeFormatException) {
                if (Debug.DEBUG) {
                    datatypeFormatException.printStackTrace(System.err);
                }
            }
            catch (InvalidStateException invalidStateException) {
                if (Debug.DEBUG) {
                    invalidStateException.printStackTrace(System.err);
                }
            }
            catch (ClassCastException classCastException) {
                if (!Debug.DEBUG) break block13;
                classCastException.printStackTrace(System.err);
            }
        }
        return null;
    }

    Object convertToAppropriatedObject(String[] stringArray) throws DatatypeFormatException {
        try {
            BigInteger bigInteger = new BigInteger(stringArray[0].trim());
            if (bigInteger.signum() < 0) {
                throw new DatatypeFormatException((SimpleType)BuiltInDatatypeFactory.getInstance().getBuiltInDatatype("nonNegativeInteger"), stringArray[0], 10);
            }
            return bigInteger;
        }
        catch (NumberFormatException numberFormatException) {
            if (Debug.DEBUG) {
                numberFormatException.printStackTrace();
            }
            throw new DatatypeFormatException((SimpleType)BuiltInDatatypeFactory.getInstance().getBuiltInDatatype("nonNegativeInteger"), stringArray[0], 10);
        }
    }

    protected BigInteger getValue(Facet facet) throws ClassCastException, DatatypeFormatException, InvalidStateException {
        BigInteger bigInteger = null;
        if (facet instanceof FacetImpl) {
            bigInteger = (BigInteger)((FacetImpl)facet).getValueAsObject();
        }
        if (bigInteger == null) {
            bigInteger = (BigInteger)this.convertToAppropriatedObject(facet.getValuesAsString());
        }
        return bigInteger;
    }

    boolean inOrder(Facet facet, Facet facet2) {
        try {
            if (facet == null || facet2 == null) {
                return false;
            }
            return this.getValue(facet).compareTo(this.getValue(facet2)) <= 0;
        }
        catch (InvalidStateException invalidStateException) {
            if (Debug.DEBUG) {
                invalidStateException.printStackTrace();
            }
            return false;
        }
        catch (DatatypeFormatException datatypeFormatException) {
            if (Debug.DEBUG) {
                datatypeFormatException.printStackTrace();
            }
            return false;
        }
        catch (ClassCastException classCastException) {
            if (Debug.DEBUG) {
                classCastException.printStackTrace();
            }
            return false;
        }
        catch (NullPointerException nullPointerException) {
            if (Debug.DEBUG) {
                nullPointerException.printStackTrace();
            }
            return false;
        }
    }

    boolean isEqual(Facet facet, Facet facet2) {
        try {
            if (facet == null || facet2 == null) {
                return false;
            }
            return this.getValue(facet).equals(this.getValue(facet2));
        }
        catch (InvalidStateException invalidStateException) {
            if (Debug.DEBUG) {
                invalidStateException.printStackTrace();
            }
            return false;
        }
        catch (DatatypeFormatException datatypeFormatException) {
            if (Debug.DEBUG) {
                datatypeFormatException.printStackTrace();
            }
            return false;
        }
        catch (ClassCastException classCastException) {
            if (Debug.DEBUG) {
                classCastException.printStackTrace();
            }
            return false;
        }
        catch (NullPointerException nullPointerException) {
            if (Debug.DEBUG) {
                nullPointerException.printStackTrace();
            }
            return false;
        }
    }

    abstract boolean validate(Facet var1, String var2);
}

