/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.ecm.schema.impl;

import com.ibm.xml.ecm.schema.BuiltInDatatypeDef;
import com.ibm.xml.ecm.schema.DatatypeFormatException;
import com.ibm.xml.ecm.schema.Facet;
import com.ibm.xml.ecm.schema.FacetConstraintException;
import com.ibm.xml.ecm.schema.FixedBasetypeExclusiveInclusiveFacetException;
import com.ibm.xml.ecm.schema.InvalidStateException;
import com.ibm.xml.ecm.schema.MutuallyExclusiveFacetsException;
import com.ibm.xml.ecm.schema.SchemaException;
import com.ibm.xml.ecm.schema.Type;
import com.ibm.xml.ecm.schema.impl.Debug;
import com.ibm.xml.ecm.schema.impl.Order;
import com.ibm.xml.ecm.schema.impl.OrderFacetStrategy;

class MinInclusiveFacetStrategy
extends OrderFacetStrategy {
    protected BuiltInDatatypeDef builtInDatatype;

    MinInclusiveFacetStrategy(BuiltInDatatypeDef builtInDatatypeDef) {
        super(builtInDatatypeDef);
    }

    SchemaException[] compatibleWithOtherFacet(Type type, Facet facet, Facet facet2, boolean bl) {
        block22: {
            if (facet.getFacetType() != 2) {
                return null;
            }
            try {
                switch (facet2.getFacetType()) {
                    case 1: 
                    case 3: 
                    case 4: {
                        Order order = (Order)facet.getValueAsObject();
                        Order order2 = (Order)facet2.getValueAsObject();
                        if (!(order != null & order2 != null) || order.isComparable(order2, new boolean[1])) break;
                        return new SchemaException[]{new FacetConstraintException(type, facet, facet2, !bl, "not comparable with")};
                    }
                }
                switch (facet2.getFacetType()) {
                    case 4: {
                        if (facet.getParent() != null && facet2.getParent() != null && facet.getParent() != facet2.getParent()) {
                            Order order = (Order)facet.getValueAsObject();
                            Order order3 = (Order)facet2.getValueAsObject();
                            if (order == null || order3 == null) break;
                            if (facet2.isFixed()) {
                                Order order4 = OrderFacetStrategy.next(type, order3);
                                if (order4 == null) {
                                    return new SchemaException[]{new FixedBasetypeExclusiveInclusiveFacetException(type, facet, facet2, !bl, null)};
                                }
                                if (!order.isEqual(order4)) {
                                    return new SchemaException[]{new FixedBasetypeExclusiveInclusiveFacetException(type, facet, facet2, !bl, order4.toString())};
                                }
                                return null;
                            }
                            if (order3.isComparable(order, null) && !order.isEqual(order3) && order3.inOrder(order)) break;
                            return new SchemaException[]{new FacetConstraintException(type, facet, facet2, !bl, "great than or equal")};
                        }
                        return new SchemaException[]{new MutuallyExclusiveFacetsException(type, facet, facet2, !bl)};
                    }
                    case 1: {
                        Order order = (Order)facet.getValueAsObject();
                        Order order5 = (Order)facet2.getValueAsObject();
                        if (order == null || order5 == null || order.isComparable(order5, null) && (order5.isEqual(order) || !order5.inOrder(order))) break;
                        return new SchemaException[]{new FacetConstraintException(type, facet, facet2, !bl, "great than or equal")};
                    }
                    case 3: {
                        Order order = (Order)facet.getValueAsObject();
                        Order order6 = (Order)facet2.getValueAsObject();
                        if (order == null || order6 == null || order.isComparable(order6, null) && !order6.inOrder(order)) break;
                        return new SchemaException[]{new FacetConstraintException(type, facet, facet2, !bl, "less than or equal")};
                    }
                    case 6: {
                        return this.compatibleWithEnumFacet(type, facet, facet2, bl);
                    }
                }
            }
            catch (DatatypeFormatException datatypeFormatException) {
                if (Debug.DEBUG) {
                    datatypeFormatException.printStackTrace(System.err);
                }
            }
            catch (InvalidStateException invalidStateException) {
                if (Debug.DEBUG) {
                    invalidStateException.printStackTrace(System.err);
                }
            }
            catch (SchemaException schemaException) {
                if (Debug.DEBUG) {
                    schemaException.printStackTrace(System.err);
                }
            }
            catch (ClassCastException classCastException) {
                if (!Debug.DEBUG) break block22;
                classCastException.printStackTrace(System.err);
            }
        }
        return null;
    }

    protected int getFacetType() {
        return 2;
    }

    boolean inOrder(Facet facet, Facet facet2) {
        if (facet == null || facet2 == null) {
            return false;
        }
        try {
            Order order = this.getValue(facet);
            Order order2 = this.getValue(facet2);
            boolean[] blArray = new boolean[1];
            if (order2.isComparable(order, blArray)) {
                return blArray[0];
            }
            return false;
        }
        catch (InvalidStateException invalidStateException) {
            if (Debug.DEBUG) {
                invalidStateException.printStackTrace();
            }
            return false;
        }
        catch (DatatypeFormatException datatypeFormatException) {
            if (Debug.DEBUG) {
                datatypeFormatException.printStackTrace();
            }
            return false;
        }
        catch (ClassCastException classCastException) {
            if (Debug.DEBUG) {
                classCastException.printStackTrace();
            }
            return false;
        }
    }

    boolean isEqual(Facet facet, Facet facet2) {
        if (facet == null || facet2 == null) {
            return false;
        }
        try {
            Order order = this.getValue(facet);
            Order order2 = this.getValue(facet2);
            return order.isEqual(order2);
        }
        catch (InvalidStateException invalidStateException) {
            if (Debug.DEBUG) {
                invalidStateException.printStackTrace();
            }
            return false;
        }
        catch (DatatypeFormatException datatypeFormatException) {
            if (Debug.DEBUG) {
                datatypeFormatException.printStackTrace();
            }
            return false;
        }
        catch (ClassCastException classCastException) {
            if (Debug.DEBUG) {
                classCastException.printStackTrace();
            }
            return false;
        }
    }

    boolean validate(Facet facet, Order order) {
        try {
            Order order2 = this.getValue(facet);
            if (order2.isComparable(order, null)) {
                return order2.inOrder(order);
            }
            return false;
        }
        catch (DatatypeFormatException datatypeFormatException) {
            if (Debug.DEBUG) {
                datatypeFormatException.printStackTrace();
            }
            return false;
        }
        catch (NullPointerException nullPointerException) {
            if (Debug.DEBUG) {
                nullPointerException.printStackTrace();
            }
            return false;
        }
        catch (InvalidStateException invalidStateException) {
            if (Debug.DEBUG) {
                invalidStateException.printStackTrace();
            }
            return false;
        }
        catch (ClassCastException classCastException) {
            if (Debug.DEBUG) {
                classCastException.printStackTrace();
            }
            return false;
        }
    }
}

