/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.ecm.schema.impl;

import com.ibm.xml.ecm.schema.CompositionStatement;
import com.ibm.xml.ecm.schema.ImportStatement;
import com.ibm.xml.ecm.schema.NoLocationAssociatedWithNamespaceException;
import com.ibm.xml.ecm.schema.OpenCloseManager;
import com.ibm.xml.ecm.schema.SchemaException;
import com.ibm.xml.ecm.schema.impl.AbstractChecker;
import com.ibm.xml.ecm.schema.impl.CheckType;
import com.ibm.xml.ecm.schema.impl.FactoryImpl;
import com.ibm.xml.ecm.schema.impl.SchemaImpl;

public class MissingSchemaLocation_Checker
extends AbstractChecker {
    public static final String copyright = "Licensed Materials - Property of IBM (C) Copyright IBM Corp. 2000, 2001, 2002    All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private SchemaException[] exceptions;
    public static CheckType ID = new CheckType("Missing Schema Location Checker");
    static /* synthetic */ Class class$com$ibm$xml$ecm$schema$CompositionStatement;

    public MissingSchemaLocation_Checker() {
    }

    public MissingSchemaLocation_Checker(CompositionStatement compositionStatement) {
        super(compositionStatement);
    }

    public boolean check(boolean bl) {
        this.exceptions = null;
        CompositionStatement compositionStatement = (CompositionStatement)this.subject;
        if (!(compositionStatement instanceof ImportStatement)) {
            return true;
        }
        OpenCloseManager openCloseManager = FactoryImpl.instance().getOpenCloseManager();
        if (compositionStatement.getLocation() == null && !SchemaImpl.schemaNS.equals(compositionStatement.getExplicitTargetNamespace()) && openCloseManager.getLocations(compositionStatement.getExplicitTargetNamespace()) == null) {
            NoLocationAssociatedWithNamespaceException noLocationAssociatedWithNamespaceException = new NoLocationAssociatedWithNamespaceException(compositionStatement.getExplicitTargetNamespace());
            noLocationAssociatedWithNamespaceException.setSchemaExceptionType(1);
            this.exceptions = new SchemaException[]{noLocationAssociatedWithNamespaceException};
            return false;
        }
        return true;
    }

    public CheckType getCheckType() {
        return ID;
    }

    public int getCost() {
        return 1;
    }

    public SchemaException[] getExceptions() {
        return this.exceptions;
    }

    public Class getSubjectClass() {
        return class$com$ibm$xml$ecm$schema$CompositionStatement == null ? (class$com$ibm$xml$ecm$schema$CompositionStatement = MissingSchemaLocation_Checker.class$("com.ibm.xml.ecm.schema.CompositionStatement")) : class$com$ibm$xml$ecm$schema$CompositionStatement;
    }

    public boolean isNeverActivateInInterativeMode() {
        return true;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        CheckType.register(ID);
    }
}

