/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.ecm.schema.impl;

import com.ibm.xml.ecm.schema.Group;
import com.ibm.xml.ecm.schema.ModelGroupDef;
import com.ibm.xml.ecm.schema.ModelGroupRedefinitionException;
import com.ibm.xml.ecm.schema.ModelGroupRef;
import com.ibm.xml.ecm.schema.Particle;
import com.ibm.xml.ecm.schema.Reference;
import com.ibm.xml.ecm.schema.SchemaException;
import com.ibm.xml.ecm.schema.TopComponentNotFoundInRedefinedSchemaException;
import com.ibm.xml.ecm.schema.impl.CheckType;
import com.ibm.xml.ecm.schema.impl.Debug;
import com.ibm.xml.ecm.schema.impl.ModelGroupDefImpl;
import com.ibm.xml.ecm.schema.impl.RedefineStatementImpl;
import com.ibm.xml.ecm.schema.impl.Redefinition_Checker;
import java.util.Stack;
import java.util.Vector;

public class ModelGroupRedefinition_Checker
extends Redefinition_Checker {
    public static final String copyright = "Licensed Materials - Property of IBM (C) Copyright IBM Corp. 2000, 2001, 2002    All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static CheckType ID = new CheckType("ModelGroup Redefinition Checker");
    private ModelGroupDefImpl groupDef;
    static /* synthetic */ Class class$com$ibm$xml$ecm$schema$impl$ModelGroupDefImpl;

    public ModelGroupRedefinition_Checker() {
    }

    public ModelGroupRedefinition_Checker(ModelGroupDefImpl modelGroupDefImpl) {
        super(modelGroupDefImpl);
        this.groupDef = modelGroupDefImpl;
    }

    public boolean check(boolean bl) {
        block9: {
            this.exceptions = null;
            try {
                if (!this.groupDef.isARedefinedVersion()) {
                    return true;
                }
                Reference[] referenceArray = this.groupDef.getReferencesToRedefinedComponent();
                int n = 0;
                if (referenceArray != null) {
                    n = referenceArray.length;
                }
                if (!(n != 1 || ((ModelGroupRef)referenceArray[0]).getMinOccurs().equals("1") && ((ModelGroupRef)referenceArray[0]).getMaxOccurs().equals("1"))) {
                    this.exceptions = new SchemaException[]{new ModelGroupRedefinitionException(this.groupDef, n)};
                    return false;
                }
                if (n != 1) {
                    RedefineStatementImpl redefineStatementImpl;
                    if (n == 0 && (redefineStatementImpl = (RedefineStatementImpl)this.getRedefineToUseForReferenceResolution(this.groupDef.getRedefine())) != null) {
                        ModelGroupDef modelGroupDef = (ModelGroupDef)redefineStatementImpl.getTopComponent(new Stack(), 5, this.groupDef.getNCName(), true, true);
                        if (modelGroupDef != null) {
                            if (!this.groupDef.getGroup().isRestrictionOf(modelGroupDef.getGroup(), new Vector())) {
                                this.exceptions = new SchemaException[]{new ModelGroupRedefinitionException(this.groupDef, n)};
                                return false;
                            }
                            return true;
                        }
                        this.exceptions = new SchemaException[]{new TopComponentNotFoundInRedefinedSchemaException(this.groupDef)};
                        return false;
                    }
                    this.exceptions = new SchemaException[]{new ModelGroupRedefinitionException(this.groupDef, n)};
                    return false;
                }
            }
            catch (SchemaException schemaException) {
                if (!Debug.DEBUG) break block9;
                schemaException.printStackTrace(System.err);
            }
        }
        return true;
    }

    public CheckType getCheckType() {
        return ID;
    }

    public int getCost() {
        return 5;
    }

    public Class getSubjectClass() {
        return class$com$ibm$xml$ecm$schema$impl$ModelGroupDefImpl == null ? (class$com$ibm$xml$ecm$schema$impl$ModelGroupDefImpl = ModelGroupRedefinition_Checker.class$("com.ibm.xml.ecm.schema.impl.ModelGroupDefImpl")) : class$com$ibm$xml$ecm$schema$impl$ModelGroupDefImpl;
    }

    public boolean isNeverActivateInInterativeMode() {
        return true;
    }

    private int numberOfRefsToRedefinedComponentIn(Group group) {
        if (group == null || group.getMaxOccurs().trim().equals("0")) {
            return 0;
        }
        Particle[] particleArray = group.listParticle();
        int n = 0;
        if (particleArray != null) {
            int n2 = 0;
            while (n2 < particleArray.length) {
                if (particleArray[n2].isModelGroupRef()) {
                    if (this.isAReferenceTo(this.groupDef, particleArray[n2].asModelGroupRef())) {
                        ++n;
                    }
                } else if (particleArray[n2].isGroup() && !particleArray[n2].getMaxOccurs().trim().equals("0")) {
                    n += this.numberOfRefsToRedefinedComponentIn(particleArray[n2].asGroup());
                }
                ++n2;
            }
        }
        return n;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        CheckType.register(ID);
    }
}

