/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.ecm.schema.impl;

import com.ibm.xml.ecm.schema.DatatypeFormatException;
import com.ibm.xml.ecm.schema.impl.BuiltInDatatypeFactory;
import com.ibm.xml.ecm.schema.impl.DateTimeLiteral;
import com.ibm.xml.ecm.schema.impl.LiteralValueImpl;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import org.apache.xerces.impl.xpath.regex.Match;
import org.apache.xerces.impl.xpath.regex.RegularExpression;

public class MonthDayLiteral
extends DateTimeLiteral {
    public static final String copyright = "Licensed Materials - Property of IBM (C) Copyright IBM Corp. 2000, 2001, 2002    All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public MonthDayLiteral(String string) throws DatatypeFormatException {
        super(string);
    }

    public Object clone() {
        try {
            return new MonthDayLiteral(new String(this.valueAsString));
        }
        catch (DatatypeFormatException datatypeFormatException) {
            datatypeFormatException.printStackTrace(System.err);
            return null;
        }
    }

    protected void conversion(String string) throws DatatypeFormatException {
        this.valueAsString = string;
        try {
            String string2 = "--MM-dd";
            RegularExpression regularExpression = new RegularExpression("--(?:(?:0[1-9])|(?:1[0-2]))-(?:(?:0[1-9])|(?:[1-2][0-9])|(?:3[0-1]))(?:Z|(?:(?:-|\\+)(?:14:00|(?:0[0-9]|1[0-3]):(?:[0-5][0-9]))))?");
            Match match = new Match();
            if (regularExpression.matches(string, match) && match.getCapturedText(0).equals(string.trim())) {
                if (!this.isYearAndMonthConsistentWithDay(string)) {
                    throw new DatatypeFormatException(BuiltInDatatypeFactory.getInstance().getBuiltInDatatype("gMonthDay"), this.valueAsString);
                }
            } else {
                throw new DatatypeFormatException(BuiltInDatatypeFactory.getInstance().getBuiltInDatatype("gMonthDay"), this.valueAsString);
            }
            this.XMLSchemaZoneTimeFormat(string, new SimpleDateFormat(string2));
        }
        catch (ParseException parseException) {
            throw new DatatypeFormatException(BuiltInDatatypeFactory.getInstance().getBuiltInDatatype("gMonthDay"), string);
        }
    }

    protected int getTimeZoneIndex(String string) {
        int n = string.indexOf("Z");
        if (n == -1 && (n = string.indexOf("+")) == -1 && this.hasMoreThanXMinus(3, string)) {
            n = string.lastIndexOf("-");
        }
        return n;
    }

    public static void main(String[] stringArray) throws Exception {
        int n = 0;
        while (n < stringArray.length) {
            MonthDayLiteral monthDayLiteral = new MonthDayLiteral(stringArray[n]);
            System.out.println("current monthDay = " + monthDayLiteral);
            System.out.println("previous monthDay = " + monthDayLiteral.previous());
            System.out.println("next monthDay = " + monthDayLiteral.next());
            ++n;
        }
    }

    public LiteralValueImpl next() {
        try {
            GregorianCalendar gregorianCalendar = this.isTimeZoneSpecified() ? new GregorianCalendar(this.getTimeZone(), Locale.getDefault()) : new GregorianCalendar();
            gregorianCalendar.setTime(this.value);
            int n = gregorianCalendar.get(5);
            int n2 = gregorianCalendar.get(2) + 1;
            if (n2 == 12 && n == 31) {
                return null;
            }
            Date date = new Date(this.value.getTime() + 86400000L);
            gregorianCalendar.setTime(date);
            n = gregorianCalendar.get(5);
            n2 = gregorianCalendar.get(2) + 1;
            if (this.isTimeZoneSpecified()) {
                return new MonthDayLiteral("--" + this.to2charsString(n2) + "-" + this.to2charsString(n) + this.zoneOffSet(this.getTimeZone().getRawOffset()));
            }
            return new MonthDayLiteral("--" + this.to2charsString(n2) + "-" + this.to2charsString(n));
        }
        catch (DatatypeFormatException datatypeFormatException) {
            throw new RuntimeException("Application fatal error " + datatypeFormatException);
        }
    }

    public LiteralValueImpl previous() {
        try {
            GregorianCalendar gregorianCalendar = this.isTimeZoneSpecified() ? new GregorianCalendar(this.getTimeZone(), Locale.getDefault()) : new GregorianCalendar();
            gregorianCalendar.setTime(this.value);
            int n = gregorianCalendar.get(5);
            int n2 = gregorianCalendar.get(2) + 1;
            if (n2 == 1 && n == 1) {
                return null;
            }
            Date date = new Date(this.value.getTime() - 86400000L);
            gregorianCalendar.setTime(date);
            n = gregorianCalendar.get(5);
            n2 = gregorianCalendar.get(2) + 1;
            if (this.isTimeZoneSpecified()) {
                return new MonthDayLiteral("--" + this.to2charsString(n2) + "-" + this.to2charsString(n) + this.zoneOffSet(this.getTimeZone().getRawOffset()));
            }
            return new MonthDayLiteral("--" + this.to2charsString(n2) + "-" + this.to2charsString(n));
        }
        catch (DatatypeFormatException datatypeFormatException) {
            throw new RuntimeException("Application fatal error " + datatypeFormatException);
        }
    }
}

