/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.ecm.schema.impl;

import com.ibm.xml.ecm.schema.DatatypeFormatException;
import com.ibm.xml.ecm.schema.impl.BuiltInDatatypeFactory;
import com.ibm.xml.ecm.schema.impl.DateTimeLiteral;
import com.ibm.xml.ecm.schema.impl.LiteralValueImpl;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.GregorianCalendar;
import java.util.Locale;
import org.apache.xerces.impl.xpath.regex.Match;
import org.apache.xerces.impl.xpath.regex.RegularExpression;

public class MonthLiteral
extends DateTimeLiteral {
    public static final String copyright = "Licensed Materials - Property of IBM (C) Copyright IBM Corp. 2000, 2001, 2002    All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public MonthLiteral(String string) throws DatatypeFormatException {
        super(string);
    }

    public Object clone() {
        try {
            return new MonthLiteral(new String(this.valueAsString));
        }
        catch (DatatypeFormatException datatypeFormatException) {
            datatypeFormatException.printStackTrace(System.err);
            return null;
        }
    }

    protected void conversion(String string) throws DatatypeFormatException {
        this.valueAsString = string;
        try {
            this.pattern = "--MM";
            RegularExpression regularExpression = new RegularExpression("--(?:(?:0[1-9])|(?:1[0-2]))(?:Z|(?:(?:-|\\+)(?:14:00|(?:0[0-9]|1[0-3]):(?:[0-5][0-9]))))?");
            Match match = new Match();
            if (!regularExpression.matches(string, match) || !match.getCapturedText(0).equals(string)) {
                throw new DatatypeFormatException(BuiltInDatatypeFactory.getInstance().getBuiltInDatatype("gYear"), this.valueAsString);
            }
            this.XMLSchemaZoneTimeFormat(string, new SimpleDateFormat(this.pattern));
        }
        catch (ParseException parseException) {
            throw new DatatypeFormatException(BuiltInDatatypeFactory.getInstance().getBuiltInDatatype("gYear"), this.valueAsString);
        }
    }

    protected int getTimeZoneIndex(String string) {
        int n = string.indexOf("Z");
        if (n == -1 && (n = string.indexOf("+")) == -1 && this.hasMoreThanXMinus(4, string)) {
            n = string.lastIndexOf("-");
        }
        return n;
    }

    public static void main(String[] stringArray) throws Exception {
        int n = 0;
        while (n < stringArray.length) {
            MonthLiteral monthLiteral = new MonthLiteral(stringArray[n]);
            System.out.println("current month = " + monthLiteral);
            System.out.println("previous month = " + monthLiteral.previous());
            System.out.println("next month = " + monthLiteral.next());
            ++n;
        }
    }

    public LiteralValueImpl next() {
        try {
            GregorianCalendar gregorianCalendar = this.isTimeZoneSpecified() ? new GregorianCalendar(this.getTimeZone(), Locale.getDefault()) : new GregorianCalendar();
            gregorianCalendar.setTime(this.value);
            int n = gregorianCalendar.get(2) + 1;
            int n2 = n + 1;
            if (n2 > 12) {
                return null;
            }
            if (this.isTimeZoneSpecified()) {
                return new MonthLiteral("--" + this.to2charsString(n2) + this.zoneOffSet(this.getTimeZone().getRawOffset()));
            }
            return new MonthLiteral("--" + this.to2charsString(n2));
        }
        catch (DatatypeFormatException datatypeFormatException) {
            throw new RuntimeException("Application fatal error " + datatypeFormatException);
        }
    }

    public LiteralValueImpl previous() {
        try {
            GregorianCalendar gregorianCalendar = this.isTimeZoneSpecified() ? new GregorianCalendar(this.getTimeZone(), Locale.getDefault()) : new GregorianCalendar();
            gregorianCalendar.setTime(this.value);
            int n = gregorianCalendar.get(2) + 1;
            int n2 = n - 1;
            if (n2 < 1) {
                return null;
            }
            if (this.isTimeZoneSpecified()) {
                return new MonthLiteral("--" + this.to2charsString(n2) + this.zoneOffSet(this.getTimeZone().getRawOffset()));
            }
            return new MonthLiteral("--" + this.to2charsString(n2));
        }
        catch (DatatypeFormatException datatypeFormatException) {
            throw new RuntimeException("Application fatal error " + datatypeFormatException);
        }
    }
}

