/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.ecm.schema.impl;

import com.ibm.sketch.util.AttributeDeclComparator;
import com.ibm.sketch.util.DuplicationFinder;
import com.ibm.xml.ecm.schema.AttributeDecl;
import com.ibm.xml.ecm.schema.MultipleAttrsDerivedFromIDException;
import com.ibm.xml.ecm.schema.ReferenceResolutionException;
import com.ibm.xml.ecm.schema.SchemaException;
import com.ibm.xml.ecm.schema.SimpleType;
import com.ibm.xml.ecm.schema.TopComponent;
import com.ibm.xml.ecm.schema.impl.AbstractChecker;
import com.ibm.xml.ecm.schema.impl.CheckType;
import com.ibm.xml.ecm.schema.impl.Debug;
import com.ibm.xml.ecm.schema.impl.FactoryImpl;
import java.util.Arrays;

public class MultipleAttributesDerivedFromID_Checker
extends AbstractChecker {
    public static final String copyright = "Licensed Materials - Property of IBM (C) Copyright IBM Corp. 2000, 2001, 2002    All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected SchemaException[] exceptions;
    private AttributeDecl[] attDecls;
    private AttributeDecl[] effectiveAttributeDecls;
    public static CheckType ID = new CheckType("Multiple Attributes Derived From ID Checker");

    public MultipleAttributesDerivedFromID_Checker() {
    }

    public MultipleAttributesDerivedFromID_Checker(TopComponent topComponent, AttributeDecl[] attributeDeclArray, AttributeDecl[] attributeDeclArray2) {
        super(topComponent);
        this.attDecls = attributeDeclArray;
        this.effectiveAttributeDecls = attributeDeclArray2;
    }

    public MultipleAttributesDerivedFromID_Checker(TopComponent topComponent, AttributeDecl attributeDecl, AttributeDecl[] attributeDeclArray) {
        super(topComponent);
        this.attDecls = new AttributeDecl[1];
        this.attDecls[0] = attributeDecl;
        this.effectiveAttributeDecls = attributeDeclArray;
    }

    public boolean check(boolean bl) {
        int n = 0;
        if (this.attDecls != null) {
            int n2 = 0;
            while (n2 < this.attDecls.length) {
                block13: {
                    SimpleType simpleType = null;
                    try {
                        simpleType = this.attDecls[n2].getType();
                        if (simpleType != null && FactoryImpl.instance() != null && (simpleType == FactoryImpl.instance().getBuiltInDatatype("ID") || simpleType.isDerivedFrom(FactoryImpl.instance().getBuiltInDatatype("ID"))) && ++n >= 2) {
                            this.exceptions = new SchemaException[]{new MultipleAttrsDerivedFromIDException((TopComponent)this.subject)};
                            return false;
                        }
                    }
                    catch (ReferenceResolutionException referenceResolutionException) {
                        if (!Debug.DEBUG) break block13;
                        referenceResolutionException.printStackTrace(System.err);
                    }
                }
                ++n2;
            }
        }
        if (this.attDecls == null || n > 0) {
            AttributeDeclComparator attributeDeclComparator = new AttributeDeclComparator();
            if (this.attDecls != null) {
                Arrays.sort(this.attDecls, attributeDeclComparator);
            }
            int n3 = 0;
            while (this.effectiveAttributeDecls != null && n3 < this.effectiveAttributeDecls.length) {
                block14: {
                    try {
                        if (this.effectiveAttributeDecls[n3] != null && this.effectiveAttributeDecls[n3].getType() != null && (this.effectiveAttributeDecls[n3].getType() == FactoryImpl.instance().getBuiltInDatatype("ID") || this.effectiveAttributeDecls[n3].getType().isDerivedFrom(FactoryImpl.instance().getBuiltInDatatype("ID"))) && ++n >= 2) {
                            boolean bl2 = false;
                            if (this.attDecls != null && DuplicationFinder.getObjectsEqualToInAnOrderedArray(this.attDecls, this.effectiveAttributeDecls[n3], attributeDeclComparator) != null) {
                                bl2 = true;
                            }
                            if (!bl2) {
                                this.exceptions = new SchemaException[]{new MultipleAttrsDerivedFromIDException((TopComponent)this.subject)};
                                return false;
                            }
                        }
                    }
                    catch (ReferenceResolutionException referenceResolutionException) {
                        if (!Debug.DEBUG) break block14;
                        referenceResolutionException.printStackTrace(System.err);
                    }
                }
                ++n3;
            }
        }
        return true;
    }

    public CheckType getCheckType() {
        return ID;
    }

    public int getCost() {
        return 5;
    }

    public SchemaException[] getExceptions() {
        return this.exceptions;
    }

    public Class getSubjectClass() {
        return this.getSubject() == null ? null : this.getSubject().getClass();
    }

    public void setExceptions(SchemaException[] schemaExceptionArray) {
        this.exceptions = schemaExceptionArray;
    }
}

