/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.ecm.schema.impl;

import com.ibm.xml.ecm.schema.BuiltInDatatypeDef;
import com.ibm.xml.ecm.schema.Facet;
import com.ibm.xml.ecm.schema.NotationRef;
import com.ibm.xml.ecm.schema.ReferenceResolutionException;
import com.ibm.xml.ecm.schema.SchemaException;
import com.ibm.xml.ecm.schema.Type;
import com.ibm.xml.ecm.schema.impl.AbstractChecker;
import com.ibm.xml.ecm.schema.impl.BuiltInDatatypeFactory;
import com.ibm.xml.ecm.schema.impl.CheckType;
import com.ibm.xml.ecm.schema.impl.CheckerManagerImpl;
import com.ibm.xml.ecm.schema.impl.Debug;
import com.ibm.xml.ecm.schema.impl.FactoryImpl;
import java.util.Vector;

public class NotationValueMatchesANotationDecl_Checker
extends AbstractChecker {
    public static final String copyright = "Licensed Materials - Property of IBM (C) Copyright IBM Corp. 2000, 2001, 2002    All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private SchemaException[] exceptions;
    public static CheckType ID = new CheckType("Notation value matches a notation declaration Checker");
    public static BuiltInDatatypeDef notationType = BuiltInDatatypeFactory.getInstance().getBuiltInDatatype("NOTATION");
    static /* synthetic */ Class class$com$ibm$xml$ecm$schema$Type;

    public NotationValueMatchesANotationDecl_Checker() {
        if (notationType == null) {
            notationType = BuiltInDatatypeFactory.getInstance().getBuiltInDatatype("NOTATION");
        }
    }

    public NotationValueMatchesANotationDecl_Checker(Type type) {
        super(type);
        if (notationType == null) {
            notationType = BuiltInDatatypeFactory.getInstance().getBuiltInDatatype("NOTATION");
        }
    }

    public boolean check(boolean bl) {
        block13: {
            try {
                Vector<ReferenceResolutionException> vector;
                Facet facet;
                Type type = (Type)this.subject;
                if (notationType == null) {
                    notationType = BuiltInDatatypeFactory.getInstance().getBuiltInDatatype("NOTATION");
                }
                if (notationType == null) {
                    return true;
                }
                if (!type.isDerivedFrom(notationType)) {
                    return true;
                }
                int n = CheckerManagerImpl.getInstance().getMaxCost();
                CheckerManagerImpl.getInstance().setMaxCost(-1);
                try {
                    facet = type.getFacet(6);
                    vector = null;
                    CheckerManagerImpl.getInstance().setMaxCost(n);
                }
                catch (Throwable throwable) {
                    Object var6_7 = null;
                    CheckerManagerImpl.getInstance().setMaxCost(n);
                    throw throwable;
                }
                if (facet == null) {
                    return true;
                }
                String[] stringArray = facet.getValuesAsString();
                if (stringArray == null) {
                    return true;
                }
                vector = new Vector<ReferenceResolutionException>();
                int n2 = 0;
                while (n2 < stringArray.length) {
                    NotationRef notationRef = FactoryImpl.instance().createNotationRef(stringArray[n2]);
                    notationRef.setParent(facet);
                    try {
                        notationRef.resolve(false);
                    }
                    catch (ReferenceResolutionException referenceResolutionException) {
                        vector.add(referenceResolutionException);
                    }
                    ++n2;
                }
                if (vector.size() > 0) {
                    this.exceptions = new SchemaException[vector.size()];
                    vector.copyInto(this.exceptions);
                    return false;
                }
            }
            catch (SchemaException schemaException) {
                if (!Debug.DEBUG) break block13;
                schemaException.printStackTrace(System.err);
            }
        }
        return true;
    }

    public CheckType getCheckType() {
        return ID;
    }

    public int getCost() {
        return 3;
    }

    public SchemaException[] getExceptions() {
        return this.exceptions;
    }

    public Class getSubjectClass() {
        return class$com$ibm$xml$ecm$schema$Type == null ? (class$com$ibm$xml$ecm$schema$Type = NotationValueMatchesANotationDecl_Checker.class$("com.ibm.xml.ecm.schema.Type")) : class$com$ibm$xml$ecm$schema$Type;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        CheckType.register(ID);
    }
}

