/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.ecm.schema.impl;

import com.ibm.xml.ecm.schema.DatatypeFormatException;
import com.ibm.xml.ecm.schema.impl.LiteralValueImpl;
import com.ibm.xml.ecm.schema.impl.Order;

public abstract class NumericLiteral
extends LiteralValueImpl
implements Order,
Comparable {
    public static final String copyright = "Licensed Materials - Property of IBM (C) Copyright IBM Corp. 2000, 2001, 2002    All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected Number value;

    public static void main(String[] stringArray) {
        System.out.println(new Float(Float.NaN).floatValue());
        System.out.println(false);
        System.out.println(true);
        System.out.println(true);
    }

    public NumericLiteral() {
    }

    public NumericLiteral(String string) throws DatatypeFormatException {
        super(string);
    }

    public double absValue() {
        double d = this.value.doubleValue();
        return d >= 0.0 ? d : -d;
    }

    public int compareTo(Object object) throws IllegalArgumentException {
        if (object instanceof NumericLiteral) {
            double d;
            double d2 = ((Number)this.getValue()).doubleValue();
            if (d2 == (d = ((Number)((NumericLiteral)object).getValue()).doubleValue())) {
                return 0;
            }
            if (Double.isNaN(d2) && Double.isNaN(d)) {
                return 0;
            }
            if (Double.isNaN(d2)) {
                throw new IllegalArgumentException(object + " and " + this + " are not comparable");
            }
            if (Double.isNaN(d)) {
                throw new IllegalArgumentException(object + " and " + this + " are not comparable");
            }
            if (d < d2) {
                return 1;
            }
            return -1;
        }
        throw new IllegalArgumentException();
    }

    public double doubleValue() {
        return this.value.doubleValue();
    }

    public boolean equals(Object object) {
        if (object instanceof NumericLiteral) {
            return this.compareTo(object) == 0;
        }
        return false;
    }

    public boolean inOrder(Object object) throws IllegalArgumentException {
        return this.compareTo(object) <= 0;
    }

    public boolean isEqual(Object object) {
        return this.equals(object);
    }

    public boolean isTotallyOrdered() {
        return true;
    }
}

