/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.ecm.schema.impl;

import com.ibm.mof.mof13.extn.impl.MOFAttributeSetting;
import com.ibm.xml.ecm.schema.BuiltInDatatypeDef;
import com.ibm.xml.ecm.schema.DatatypeFormatException;
import com.ibm.xml.ecm.schema.Document;
import com.ibm.xml.ecm.schema.Occurs;
import com.ibm.xml.ecm.schema.gen.impl.FactoryImplGen;
import com.ibm.xml.ecm.schema.gen.impl.OccursImplGen;
import com.ibm.xml.ecm.schema.impl.BuiltInDatatypeFactory;
import com.ibm.xml.ecm.schema.impl.Debug;
import com.ibm.xml.ecm.schema.impl.OccursListener;
import java.util.Vector;

public class OccursImpl
extends OccursImplGen
implements Occurs {
    public static final String copyright = "Licensed Materials - Property of IBM (C) Copyright IBM Corp. 2000, 2001, 2002    All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String UNBOUNDED = new String("unbounded");
    private long max;
    private long min;
    private boolean isMaxUnbounded = false;
    private Document tempDoc = null;
    private static BuiltInDatatypeDef positive_Int = BuiltInDatatypeFactory.getInstance().getBuiltInDatatype("positiveInteger");
    private static BuiltInDatatypeDef non_negative_Int = BuiltInDatatypeFactory.getInstance().getBuiltInDatatype("nonNegativeInteger");
    private Vector occursListeners = new Vector();
    private boolean defaultValueForMin = false;
    private boolean defaultValueForMax = false;
    public boolean initializedBuiltins = false;

    public OccursImpl() {
        if (!this.initializedBuiltins) {
            positive_Int = BuiltInDatatypeFactory.getInstance().getBuiltInDatatype("positiveInteger");
            non_negative_Int = BuiltInDatatypeFactory.getInstance().getBuiltInDatatype("nonNegativeInteger");
            this.initializedBuiltins = true;
        }
    }

    public void addListener(OccursListener occursListener) {
        this.occursListeners.add(occursListener);
    }

    public void applied(MOFAttributeSetting mOFAttributeSetting) {
        super.applied(mOFAttributeSetting);
        if (mOFAttributeSetting.getMetaObject() == FactoryImplGen.Occurs_minOccurs_CA) {
            this.notifyMinSet((String)mOFAttributeSetting.getObject());
            return;
        }
        if (mOFAttributeSetting.getMetaObject() == FactoryImplGen.Occurs_maxOccurs_CA) {
            this.notifyMaxSet((String)mOFAttributeSetting.getObject());
            return;
        }
    }

    public void applied(MOFAttributeSetting mOFAttributeSetting, int n, MOFAttributeSetting mOFAttributeSetting2) {
        super.applied(mOFAttributeSetting, n, mOFAttributeSetting2);
        if (mOFAttributeSetting.getMetaObject() == FactoryImplGen.Occurs_minOccurs_CA) {
            this.notifyMinSet((String)mOFAttributeSetting.getObject());
            return;
        }
        if (mOFAttributeSetting.getMetaObject() == FactoryImplGen.Occurs_maxOccurs_CA) {
            this.notifyMaxSet((String)mOFAttributeSetting.getObject());
            return;
        }
    }

    public boolean equals(Object object) {
        if (!(object instanceof Occurs)) {
            return false;
        }
        Occurs occurs = (Occurs)object;
        return this.getMinOccurs().equals(occurs.getMinOccurs()) && this.getMaxOccurs().equals(occurs.getMaxOccurs());
    }

    public void generateUUID() {
    }

    public String getMaxOccurs() {
        if (this.fmaxOccurs_CA == null) {
            this.max = 1L;
            this.fmaxOccurs_CA = "1";
            this.defaultValueForMax = true;
        }
        return this.fmaxOccurs_CA;
    }

    public String getMinOccurs() {
        if (this.fminOccurs_CA == null) {
            this.fminOccurs_CA = "1";
            this.min = 1L;
            this.defaultValueForMin = true;
        }
        return this.fminOccurs_CA;
    }

    public boolean isGreaterThan(Occurs occurs) {
        return occurs.isLessThan(this);
    }

    public boolean isInitializedBuiltins() {
        return this.initializedBuiltins;
    }

    public boolean isLessThan(Occurs occurs) {
        int n = Integer.parseInt(occurs.getMinOccurs());
        if (this.isMaxUnbounded) {
            if (!OccursImpl.isMaxUnbounded(occurs)) {
                return false;
            }
            return this.min >= (long)n;
        }
        if (OccursImpl.isMaxUnbounded(occurs)) {
            return this.min >= (long)n;
        }
        int n2 = Integer.parseInt(occurs.getMaxOccurs());
        return this.min >= (long)n && this.max <= (long)n2;
    }

    private static boolean isMaxUnbounded(Occurs occurs) {
        return occurs.getMaxOccurs().equals(UNBOUNDED);
    }

    protected void notifyMaxSet(String string) {
        int n = 0;
        while (n < this.occursListeners.size()) {
            ((OccursListener)this.occursListeners.get(n)).maxHasBeenSet(string, this);
            ++n;
        }
    }

    protected void notifyMinSet(String string) {
        int n = 0;
        while (n < this.occursListeners.size()) {
            ((OccursListener)this.occursListeners.get(n)).minHasBeenSet(string, this);
            ++n;
        }
    }

    public void removeListener(OccursListener occursListener) {
        this.occursListeners.remove(occursListener);
    }

    public void setInitializedBuiltins(boolean bl) {
        this.initializedBuiltins = bl;
    }

    public void setMaxOccurs(String string) throws DatatypeFormatException {
        try {
            if (string != null && !string.equals(UNBOUNDED)) {
                this.max = Integer.parseInt(string);
                if (this.max < 0L) {
                    throw new DatatypeFormatException(non_negative_Int, string);
                }
                string = String.valueOf(this.max);
            } else {
                this.isMaxUnbounded = true;
            }
            this.setMaxOccurs_CA(string);
            this.defaultValueForMax = false;
        }
        catch (NumberFormatException numberFormatException) {
            if (Debug.DEBUG) {
                numberFormatException.printStackTrace(System.err);
            }
            throw new DatatypeFormatException(non_negative_Int, string);
        }
    }

    public void setMinOccurs(String string) throws DatatypeFormatException {
        try {
            if (string == null) {
                throw new DatatypeFormatException(non_negative_Int, string);
            }
            this.min = Integer.parseInt(string);
            if (this.min < 0L) {
                throw new DatatypeFormatException(non_negative_Int, string);
            }
            string = String.valueOf(this.min);
            this.setMinOccurs_CA(string);
            this.defaultValueForMin = false;
        }
        catch (NumberFormatException numberFormatException) {
            if (Debug.DEBUG) {
                numberFormatException.printStackTrace(System.err);
            }
            throw new DatatypeFormatException(non_negative_Int, string);
        }
    }
}

