/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.ecm.schema.impl;

import com.ibm.mof.mof13.ref.extn.RefObjectExtn;
import com.ibm.sketch.graph.DefaultGraphVisitor;
import com.ibm.sketch.graph.DepthFirstTraversal;
import com.ibm.sketch.graph.EdgeEnd;
import com.ibm.sketch.graph.GraphTraversal;
import com.ibm.sketch.graph.GraphVisitor;
import com.ibm.sketch.graph.TraverseEdgeCondition;
import com.ibm.sketch.graph.Vertex;
import com.ibm.sketch.parser.LocationParseState;
import com.ibm.sketch.parser.ParseException;
import com.ibm.sketch.parser.Parser;
import com.ibm.sketch.parser.XMIParserImpl;
import com.ibm.sketch.schemaparser.SchemaForParserImpl;
import com.ibm.sketch.schemaparser.XSDParserImpl;
import com.ibm.sketch.util.CollectionWithDuplications;
import com.ibm.sketch.util.IdentityConstraintIdentifier;
import com.ibm.sketch.util.urlRedirection.LocationCorrespondance;
import com.ibm.sketch.util.urlRedirection.RedirectionURLHandlerFactory;
import com.ibm.xml.ecm.schema.BuiltInDatatypeDef;
import com.ibm.xml.ecm.schema.CompositionStatement;
import com.ibm.xml.ecm.schema.EncodingInvalidValueException;
import com.ibm.xml.ecm.schema.Factory;
import com.ibm.xml.ecm.schema.IdentityConstraint;
import com.ibm.xml.ecm.schema.IdentityConstraintNotFoundException;
import com.ibm.xml.ecm.schema.ImportStatement;
import com.ibm.xml.ecm.schema.InvalidOrNotExistingSchemaException;
import com.ibm.xml.ecm.schema.LocationNotFoundException;
import com.ibm.xml.ecm.schema.NamespaceDeclaration;
import com.ibm.xml.ecm.schema.NoLocationAssociatedWithNamespaceException;
import com.ibm.xml.ecm.schema.NotImplementedYetException;
import com.ibm.xml.ecm.schema.OpenCloseManager;
import com.ibm.xml.ecm.schema.OpenCloseManagerException;
import com.ibm.xml.ecm.schema.ProgressMonitor;
import com.ibm.xml.ecm.schema.RedefineStatement;
import com.ibm.xml.ecm.schema.Reference;
import com.ibm.xml.ecm.schema.ReferenceResolutionException;
import com.ibm.xml.ecm.schema.ReferenceResolutionToARedefinedTopComponentException;
import com.ibm.xml.ecm.schema.Schema;
import com.ibm.xml.ecm.schema.TopComponent;
import com.ibm.xml.ecm.schema.TopComponentNotFoundButIsInSchemaException;
import com.ibm.xml.ecm.schema.TopComponentNotFoundException;
import com.ibm.xml.ecm.schema.URI;
import com.ibm.xml.ecm.schema.UnknownPrefixException;
import com.ibm.xml.ecm.schema.impl.BuiltInDatatypeFactory;
import com.ibm.xml.ecm.schema.impl.Debug;
import com.ibm.xml.ecm.schema.impl.FactoryImpl;
import com.ibm.xml.ecm.schema.impl.KeyRefImpl;
import com.ibm.xml.ecm.schema.impl.RedefineStatementImpl;
import com.ibm.xml.ecm.schema.impl.ReferenceImpl;
import com.ibm.xml.ecm.schema.impl.Resources;
import com.ibm.xml.ecm.schema.impl.SchemaImpl;
import com.ibm.xml.ecm.schema.impl.SchemaObjectImpl;
import com.ibm.xml.ecm.schema.impl.SchemaVertex;
import com.ibm.xml.ecm.schema.impl.TopComponentImpl;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Stack;
import java.util.Vector;
import org.apache.xerces.dom.DocumentImpl;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import sun.io.MalformedInputException;

public class OpenCloseManagerImpl
implements OpenCloseManager {
    public static final String copyright = "Licensed Materials - Property of IBM (C) Copyright IBM Corp. 2000, 2001, 2002    All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static LocationCorrespondance locationCorrespondance = new LocationCorrespondance();
    private static boolean indicateProgress;
    private Hashtable flocations = new Hashtable();
    private Hashtable location_locationParseState = new Hashtable();
    private Hashtable parsers = new Hashtable();
    private Parser defaultParser;
    private static final String nullURI = "nullURI";
    public static final int VALIDATION_TIME_PER_LINE = 100;
    private static OpenCloseManagerImpl theOpenCloseManager;
    private String XMLSchema_datatypes_SchemaLocation = Resources.XMLSCHEMA_DATATYPES_LOCATION.toString();
    public static final String XMLSchema_datatypes_namespace = "http://www.w3.org/2001/XMLSchema-datatypes";
    public static final String XML_namespace = "http://www.w3.org/XML/1998/namespace";
    private static final String XML_namespace_SchemaLocation;
    private Hashtable fTemporarylocations = new Hashtable();
    protected long componentCount = 0L;
    public static long maxComponents;
    private static double percentFreeMemoryThatTriggersCachePurge;
    private boolean disableDuplicationChecker = false;
    private static boolean DEBUG;
    private boolean enableReferenceResolution = true;
    private ProgressMonitor progressMonitor;

    protected OpenCloseManagerImpl() {
        this.initParsers();
        this.componentCount = 0L;
        this.addStandardSchemaLocations();
    }

    public void addLocationForNamespace(URI uRI, URI[] uRIArray) {
        Vector<URI> vector;
        Object object = uRI;
        if (object == null) {
            object = nullURI;
        }
        if ((vector = (Vector<URI>)this.flocations.get(object)) == null) {
            vector = new Vector<URI>();
            this.flocations.put(object, vector);
        }
        int n = 0;
        while (n < uRIArray.length) {
            if (!vector.contains(uRIArray[n])) {
                vector.add(uRIArray[n]);
            }
            ++n;
        }
        Vector vector2 = (Vector)this.fTemporarylocations.get(object);
        if (vector2 != null) {
            int n2 = 0;
            while (n2 < uRIArray.length) {
                vector2.remove(uRIArray[n2]);
                ++n2;
            }
            if (vector2.isEmpty()) {
                this.fTemporarylocations.remove(object);
            }
        }
    }

    public void addTemporaryLocationForNamespace(URI uRI, URI uRI2) {
        Vector vector;
        Object object = uRI;
        if (object == null) {
            object = nullURI;
        }
        if ((vector = (Vector)this.flocations.get(object)) != null && vector.contains(uRI2)) {
            return;
        }
        vector = (Vector)this.fTemporarylocations.get(object);
        if (vector == null) {
            vector = new Vector();
            this.fTemporarylocations.put(object, vector);
        }
        if (!vector.contains(uRI2)) {
            vector.add(uRI2);
        }
        if ((vector = (Vector)this.flocations.get(object)) == null) {
            vector = new Vector();
            this.flocations.put(object, vector);
        }
        if (!vector.contains(uRI2)) {
            vector.add(uRI2);
        }
    }

    public void addLocationForNamespace(URI uRI, URI uRI2) {
        this.addLocationForNamespace(uRI, new URI[]{uRI2});
    }

    public void addSchemaIntoListOfSchema(Schema schema) {
        throw new NotImplementedYetException();
    }

    private void addStandardSchemaLocations() {
        Factory factory = FactoryImpl.instance();
        URI uRI = factory.createURI();
        uRI.setValue(this.XMLSchema_datatypes_SchemaLocation);
        URI uRI2 = factory.createURI();
        uRI2.setValue(XMLSchema_datatypes_namespace);
        this.addLocationForNamespace(uRI2, uRI);
        uRI = factory.createURI();
        uRI.setValue(XML_namespace_SchemaLocation);
        uRI2 = factory.createURI();
        uRI2.setValue(XML_namespace);
        this.addLocationForNamespace(uRI2, uRI);
    }

    public void close(Schema schema) {
        this.removeFromCache(schema);
        this.unlinkReferences(schema);
        this.disableDuplicationChecker = true;
        Runtime.getRuntime().runFinalization();
        Runtime.getRuntime().gc();
        this.disableDuplicationChecker = false;
    }

    public void closeAllOpenedSchemas() {
        Enumeration enumeration = this.getAllSchemas();
        while (enumeration.hasMoreElements()) {
            this.close((Schema)enumeration.nextElement());
        }
        BuiltInDatatypeFactory builtInDatatypeFactory = BuiltInDatatypeFactory.getInstance();
        Hashtable hashtable = builtInDatatypeFactory.getRegistry();
        TopComponent[] topComponentArray = new TopComponent[hashtable.size() + 1];
        topComponentArray[topComponentArray.length - 1] = builtInDatatypeFactory.getAnyType();
        int n = 0;
        Enumeration enumeration2 = hashtable.elements();
        while (enumeration2.hasMoreElements()) {
            topComponentArray[n] = (BuiltInDatatypeDef)enumeration2.nextElement();
            ++n;
        }
        int n2 = 0;
        while (n2 < topComponentArray.length) {
            TopComponent topComponent = topComponentArray[n2];
            Reference[] referenceArray = topComponent.listReference();
            if (referenceArray != null) {
                Reference[] referenceArray2 = new Reference[referenceArray.length];
                System.arraycopy(referenceArray, 0, referenceArray2, 0, referenceArray.length);
                int n3 = 0;
                while (n3 < referenceArray2.length) {
                    TopComponent topComponent2 = referenceArray2[n3].getTopComponentAncestor();
                    if (topComponent2 == null) {
                        topComponent.removeReference(referenceArray2[n3]);
                    } else if (topComponent2.getSchema() != topComponent.getSchema()) {
                        topComponent.removeReference(referenceArray2[n3]);
                    }
                    ++n3;
                }
            }
            ++n2;
        }
    }

    public void enableReferenceResolution(boolean bl) {
        this.enableReferenceResolution = bl;
    }

    public Enumeration getAllSchemas() {
        Enumeration enumeration = this.location_locationParseState.elements();
        Vector<Schema> vector = new Vector<Schema>();
        while (enumeration.hasMoreElements()) {
            Schema[] schemaArray = ((LocationParseState)enumeration.nextElement()).getSchemasRead();
            if (schemaArray == null) continue;
            vector.addAll(Arrays.asList(schemaArray));
        }
        return vector.elements();
    }

    public TopComponent getBuiltInComponent(URI uRI, String string, int n) {
        if (uRI != null && uRI.equals(SchemaImpl.schemaNS)) {
            if (n == 1) {
                BuiltInDatatypeDef builtInDatatypeDef = BuiltInDatatypeFactory.getInstance().getBuiltInDatatype(string);
                if (builtInDatatypeDef != null) {
                    return builtInDatatypeDef;
                }
            } else if (n == 2 && "anyType".equals(string)) {
                return BuiltInDatatypeFactory.getInstance().getAnyType();
            }
        }
        return null;
    }

    public long getComponentCount() {
        return this.componentCount;
    }

    public Parser getDefaultParser() {
        return this.defaultParser;
    }

    private String getExtension(URI uRI) {
        return this.getExtension(uRI.toString());
    }

    private String getExtension(String string) {
        int n = string.lastIndexOf(".");
        if (n == -1 || n == string.length() - 1) {
            return "";
        }
        return string.substring(n + 1).toLowerCase();
    }

    public static boolean getIndicateProgress() {
        return indicateProgress;
    }

    public static OpenCloseManager getInstance() {
        return theOpenCloseManager == null ? (theOpenCloseManager = new OpenCloseManagerImpl()) : theOpenCloseManager;
    }

    synchronized IdentityConstraint getReferencedIdentityConstraint(KeyRefImpl keyRefImpl, boolean bl) throws UnknownPrefixException, IdentityConstraintNotFoundException {
        DepthFirstTraversal depthFirstTraversal;
        KeyRefResolver keyRefResolver;
        Object object;
        Object object2;
        if (Debug.DEBUG) {
            System.out.println("in OCM.getReferencedIdentityConstraint " + keyRefImpl.getTargetNamespace() + " : " + keyRefImpl.getReferNCName());
        }
        if (!this.enableReferenceResolution || keyRefImpl.getReferNCName() == null) {
            throw new IdentityConstraintNotFoundException(keyRefImpl);
        }
        IdentityConstraint identityConstraint = null;
        NamespaceDeclaration namespaceDeclaration = null;
        if (keyRefImpl.getPrefix() != null && (namespaceDeclaration = keyRefImpl.getNamespaceDeclaration(keyRefImpl.getPrefix())) == null) {
            if (keyRefImpl.getPrefix().trim().toLowerCase().equals("xml")) {
                try {
                    URI uRI = FactoryImpl.instance().createURI();
                    uRI.setValue(XML_namespace);
                    Schema[] schemaArray = this.getSchemasForNamespace(uRI, bl);
                    if (schemaArray != null && schemaArray.length > 0) {
                        KeyRefResolver keyRefResolver2 = new KeyRefResolver(new IdentityConstraintIdentifier(uRI, keyRefImpl.getReferNCName()));
                        DepthFirstTraversal depthFirstTraversal2 = new DepthFirstTraversal();
                        depthFirstTraversal2.setCondition(keyRefResolver2.getCondition());
                        depthFirstTraversal2.traverse(new SchemaVertex(schemaArray[0]), (GraphVisitor)keyRefResolver2);
                        identityConstraint = keyRefResolver2.getReferencedIdentityConstraint();
                        if (identityConstraint != null) {
                            return identityConstraint;
                        }
                    }
                }
                catch (NoLocationAssociatedWithNamespaceException noLocationAssociatedWithNamespaceException) {
                    // empty catch block
                }
                throw new IdentityConstraintNotFoundException(keyRefImpl);
            }
            if (!keyRefImpl.getPrefix().trim().equals("")) {
                throw new UnknownPrefixException(keyRefImpl.getPrefix(), keyRefImpl.getReferNCName());
            }
        }
        if (namespaceDeclaration == null) {
            ImportStatement[] importStatementArray;
            if (keyRefImpl.getSchema() != null && (importStatementArray = keyRefImpl.getSchema().listImportStatement()) != null) {
                int n = 0;
                while (n < importStatementArray.length) {
                    Schema schema;
                    if (importStatementArray[n].getEffectiveTargetNamespace() == null && (schema = importStatementArray[n].getReferencedSchema()) != null) {
                        KeyRefResolver keyRefResolver3 = new KeyRefResolver(new IdentityConstraintIdentifier(null, keyRefImpl.getReferNCName()));
                        DepthFirstTraversal depthFirstTraversal3 = new DepthFirstTraversal();
                        depthFirstTraversal3.setCondition(keyRefResolver3.getCondition());
                        depthFirstTraversal3.traverse(new SchemaVertex(schema), (GraphVisitor)keyRefResolver3);
                        identityConstraint = keyRefResolver3.getReferencedIdentityConstraint();
                        if (identityConstraint != null) {
                            return identityConstraint;
                        }
                    }
                    ++n;
                }
            }
            throw new IdentityConstraintNotFoundException(keyRefImpl);
        }
        URI[] uRIArray = null;
        if (namespaceDeclaration != null && keyRefImpl.getSchema() != null) {
            if (namespaceDeclaration.getTargetNamespace().equals(((SchemaImpl)keyRefImpl.getSchema()).getTargetNamespaceOrDefaultTargetNamespace())) {
                Object object3;
                object2 = keyRefImpl.getSchema();
                if (object2 instanceof SchemaForParserImpl && (object2 = ((SchemaForParserImpl)(object3 = (SchemaForParserImpl)object2)).getSchemaUsedForReferenceResolution()) == null) {
                    object2 = object3;
                }
                object3 = new KeyRefResolver(new IdentityConstraintIdentifier(object2.getTargetNamespace(), keyRefImpl.getReferNCName()));
                object = new DepthFirstTraversal();
                ((GraphTraversal)object).setCondition(((KeyRefResolver)object3).getCondition());
                ((DepthFirstTraversal)object).traverse(new SchemaVertex((Schema)object2), (GraphVisitor)object3);
                identityConstraint = ((KeyRefResolver)object3).getReferencedIdentityConstraint();
            } else {
                object2 = keyRefImpl.getSchema().listImportStatement();
                if (object2 != null) {
                    int n = 0;
                    while (n < ((ImportStatement[])object2).length) {
                        if (object2[n].getEffectiveTargetNamespace() != null && object2[n].getEffectiveTargetNamespace().equals(namespaceDeclaration.getTargetNamespace())) {
                            object = object2[n].getReferencedSchema();
                            if (object != null) {
                                keyRefResolver = new KeyRefResolver(new IdentityConstraintIdentifier(namespaceDeclaration.getTargetNamespace(), keyRefImpl.getReferNCName()));
                                depthFirstTraversal = new DepthFirstTraversal();
                                depthFirstTraversal.setCondition(keyRefResolver.getCondition());
                                depthFirstTraversal.traverse(new SchemaVertex((Schema)object), (GraphVisitor)keyRefResolver);
                                identityConstraint = keyRefResolver.getReferencedIdentityConstraint();
                            }
                            if (identityConstraint != null) {
                                return identityConstraint;
                            }
                        }
                        ++n;
                    }
                }
            }
        }
        if ((object2 = namespaceDeclaration.getTargetNamespace()) != null && object2.equals(SchemaImpl.defaultTargetNamespace)) {
            object2 = null;
        }
        if (identityConstraint == null) {
            uRIArray = this.getLocations((URI)object2);
        }
        if (identityConstraint == null && uRIArray != null) {
            int n = 0;
            while (n < uRIArray.length) {
                object = this.getSchemas((URI)object2, new URI[]{uRIArray[n]}, bl);
                if (object != null && ((Schema[])object).length > 0) {
                    keyRefResolver = new KeyRefResolver(new IdentityConstraintIdentifier((URI)object2, keyRefImpl.getReferNCName()));
                    depthFirstTraversal = new DepthFirstTraversal();
                    depthFirstTraversal.setCondition(keyRefResolver.getCondition());
                    depthFirstTraversal.traverse(new SchemaVertex((Schema)object[0]), (GraphVisitor)keyRefResolver);
                    identityConstraint = keyRefResolver.getReferencedIdentityConstraint();
                    if (identityConstraint != null) {
                        return identityConstraint;
                    }
                }
                ++n;
            }
        }
        if (identityConstraint != null) {
            return identityConstraint;
        }
        throw new IdentityConstraintNotFoundException(keyRefImpl);
    }

    public LocationCorrespondance getLocationCorrespondance() {
        return locationCorrespondance;
    }

    public URI[] getLocations(URI uRI) {
        Object object = uRI;
        if (object == null) {
            object = nullURI;
        }
        Vector vector = (Vector)this.flocations.get(object);
        Object[] objectArray = null;
        if (vector != null) {
            objectArray = new URI[vector.size()];
            vector.copyInto(objectArray);
        }
        return objectArray;
    }

    public static final long getMaxComponents() {
        return maxComponents;
    }

    public Parser getParser(String string) {
        Parser parser = (Parser)this.parsers.get(string);
        if (parser == null) {
            parser = this.defaultParser;
        }
        return parser;
    }

    public static double getPercentFreeMemoryThatTriggersCachePurge() {
        return percentFreeMemoryThatTriggersCachePurge;
    }

    public ProgressMonitor getProgressMonitor() {
        return this.progressMonitor;
    }

    public Schema[] getSchemas(URI uRI, URI[] uRIArray, boolean bl) {
        if (uRIArray == null || uRIArray.length <= 0) {
            return null;
        }
        Vector<Schema> vector = new Vector<Schema>();
        Object[] objectArray = null;
        int n = 0;
        while (n < uRIArray.length) {
            block14: {
                try {
                    Schema schema = this.searchSchemaByLocation(uRIArray[n], uRI);
                    if (schema == null) {
                        Parser parser = this.getParser(this.getExtension(uRIArray[n]));
                        LocationParseStateImpl locationParseStateImpl = (LocationParseStateImpl)this.location_locationParseState.get(uRIArray[n]);
                        if (locationParseStateImpl == null) {
                            locationParseStateImpl = new LocationParseStateImpl(uRIArray[n]);
                            this.location_locationParseState.put(uRIArray[n].clone(), locationParseStateImpl);
                        }
                        if ((schema = parser.parse(new InputSource(uRIArray[n].getAbsoluteURL().toString()), uRI, locationParseStateImpl)) != null) {
                            if (DEBUG) {
                                System.out.println("In getSchemas()");
                                System.out.println("New schema cached : TNS= " + schema.getTargetNamespace());
                                System.out.println("Opened locations : \n" + this.location_locationParseState);
                                System.out.println();
                                System.out.println();
                            }
                            parser.completeParsing(schema);
                        }
                    }
                    if (schema != null) {
                        vector.add(schema);
                    }
                }
                catch (ParseException parseException) {
                    if (Debug.DEBUG) {
                        if (parseException.getException() != null) {
                            parseException.getException().printStackTrace(System.err);
                        } else {
                            parseException.printStackTrace(System.err);
                        }
                    }
                }
                catch (IOException iOException) {
                    if (!Debug.DEBUG) break block14;
                    iOException.printStackTrace(System.err);
                }
            }
            ++n;
        }
        if (vector.size() > 0) {
            objectArray = new Schema[vector.size()];
            vector.copyInto(objectArray);
        }
        return objectArray;
    }

    public Schema[] getSchemas(URI uRI, boolean bl) throws NoLocationAssociatedWithNamespaceException {
        URI[] uRIArray = this.getLocations(uRI);
        if (uRIArray == null || uRIArray.length <= 0) {
            throw new NoLocationAssociatedWithNamespaceException(uRI);
        }
        return this.getSchemas(uRI, uRIArray, bl);
    }

    public Schema[] getSchemasForNamespace(URI uRI, boolean bl) throws NoLocationAssociatedWithNamespaceException {
        return this.getSchemas(uRI, bl);
    }

    public Schema[] getSchemasLocatedAt(URI uRI, boolean bl) throws ReferenceResolutionException {
        LocationParseStateImpl locationParseStateImpl = (LocationParseStateImpl)this.location_locationParseState.get(uRI);
        if (locationParseStateImpl == null || bl) {
            locationParseStateImpl = new LocationParseStateImpl(uRI);
            this.location_locationParseState.put(uRI.clone(), locationParseStateImpl);
        }
        try {
            Parser parser;
            Schema[] schemaArray;
            if (!locationParseStateImpl.areAllSchemasRead() && (schemaArray = (parser = this.getParser(this.getExtension(uRI))).parse(new InputSource(uRI.getAbsoluteURL().toString()), locationParseStateImpl)) != null) {
                locationParseStateImpl.setAllSchemasRead(true);
                if (DEBUG) {
                    System.out.println("In getSchemasLocatedAt()");
                    if (schemaArray != null) {
                        System.out.println("New schema cached : TNS= " + schemaArray[0].getTargetNamespace());
                    }
                    System.out.println("Opened locations : \n" + this.location_locationParseState);
                    System.out.println();
                    System.out.println();
                }
                int n = 0;
                while (n < schemaArray.length) {
                    if (parser instanceof XSDParserImpl) {
                        ((XSDParserImpl)parser).setErrorHandler(null);
                    }
                    parser.completeParsing(schemaArray[n]);
                    ++n;
                }
            }
            Schema[] schemaArray2 = locationParseStateImpl.getSchemasRead();
            if (Debug.DEBUG) {
                System.out.println("opened schemas\n" + this.location_locationParseState);
            }
            return schemaArray2;
        }
        catch (ParseException parseException) {
            if (Debug.DEBUG) {
                if (parseException.getException() != null) {
                    parseException.getException().printStackTrace(System.err);
                } else {
                    parseException.printStackTrace(System.err);
                }
            }
            if (parseException.getException() != null) {
                throw new InvalidOrNotExistingSchemaException(uRI, parseException.getException());
            }
            throw new InvalidOrNotExistingSchemaException(uRI, (Exception)parseException);
        }
        catch (MalformedInputException malformedInputException) {
            if (Debug.DEBUG) {
                malformedInputException.printStackTrace(System.err);
            }
            throw new InvalidOrNotExistingSchemaException(uRI, (Exception)new EncodingInvalidValueException());
        }
        catch (IOException iOException) {
            if (Debug.DEBUG) {
                iOException.printStackTrace(System.err);
            }
            throw new LocationNotFoundException((URI)null, (Exception)iOException, new URI[]{uRI});
        }
        catch (ClassCastException classCastException) {
            if (Debug.DEBUG) {
                classCastException.printStackTrace();
            }
            throw classCastException;
        }
    }

    public Schema[] getSchemasLocatedAt(URI uRI, boolean bl, ProgressMonitor progressMonitor) throws ReferenceResolutionException {
        this.progressMonitor = progressMonitor;
        LocationParseStateImpl locationParseStateImpl = (LocationParseStateImpl)this.location_locationParseState.get(uRI);
        if (locationParseStateImpl == null || bl) {
            locationParseStateImpl = new LocationParseStateImpl(uRI);
            this.location_locationParseState.put(uRI.clone(), locationParseStateImpl);
        }
        try {
            Parser parser;
            Schema[] schemaArray;
            if (!locationParseStateImpl.areAllSchemasRead() && (schemaArray = (parser = this.getParser(this.getExtension(uRI))).parse(new InputSource(uRI.getAbsoluteURL().toString()), locationParseStateImpl)) != null) {
                locationParseStateImpl.setAllSchemasRead(true);
                if (DEBUG) {
                    System.out.println("In getSchemasLocatedAt()");
                    if (schemaArray != null) {
                        System.out.println("New schema cached : TNS= " + schemaArray[0].getTargetNamespace());
                    }
                    System.out.println("Opened locations : \n" + this.location_locationParseState);
                    System.out.println();
                    System.out.println();
                }
                int n = 0;
                while (n < schemaArray.length) {
                    if (parser instanceof XSDParserImpl) {
                        ((XSDParserImpl)parser).setErrorHandler(null);
                    }
                    parser.completeParsing(schemaArray[n]);
                    ++n;
                }
            }
            Schema[] schemaArray2 = locationParseStateImpl.getSchemasRead();
            if (Debug.DEBUG) {
                System.out.println("opened schemas\n" + this.location_locationParseState);
            }
            return schemaArray2;
        }
        catch (ParseException parseException) {
            if (Debug.DEBUG) {
                if (parseException.getException() != null) {
                    parseException.getException().printStackTrace(System.err);
                } else {
                    parseException.printStackTrace(System.err);
                }
            }
            if (parseException.getException() != null) {
                throw new InvalidOrNotExistingSchemaException(uRI, parseException.getException());
            }
            throw new InvalidOrNotExistingSchemaException(uRI, (Exception)parseException);
        }
        catch (MalformedInputException malformedInputException) {
            if (Debug.DEBUG) {
                malformedInputException.printStackTrace(System.err);
            }
            throw new InvalidOrNotExistingSchemaException(uRI, (Exception)new EncodingInvalidValueException());
        }
        catch (IOException iOException) {
            if (Debug.DEBUG) {
                iOException.printStackTrace(System.err);
            }
            throw new LocationNotFoundException((URI)null, (Exception)iOException, new URI[]{uRI});
        }
        catch (ClassCastException classCastException) {
            if (Debug.DEBUG) {
                classCastException.printStackTrace();
            }
            throw classCastException;
        }
    }

    public String[] getSupportedFileExtension() {
        String[] stringArray = new String[this.parsers.size()];
        Enumeration enumeration = this.parsers.elements();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            stringArray[n] = (String)enumeration.nextElement();
            ++n;
        }
        return stringArray;
    }

    synchronized TopComponent getTopComponent(ReferenceImpl referenceImpl, boolean bl) throws ReferenceResolutionException {
        RefObjectExtn refObjectExtn;
        Object object;
        URI[] uRIArray;
        URI uRI;
        TopComponent topComponent;
        block36: {
            Object object2;
            block37: {
                Object object3;
                SchemaForParserImpl schemaForParserImpl;
                Object object4;
                block39: {
                    block38: {
                        if (Debug.DEBUG) {
                            System.out.println("in OCM.getTopComponent " + referenceImpl.getTargetNamespace() + " : " + referenceImpl.getNCName());
                        }
                        if (!this.enableReferenceResolution) {
                            throw new TopComponentNotFoundException(referenceImpl, null);
                        }
                        topComponent = null;
                        NamespaceDeclaration namespaceDeclaration = referenceImpl.getNamespaceDecl();
                        if (namespaceDeclaration == null && referenceImpl.getTargetNamespace() == null) {
                            ImportStatement[] importStatementArray;
                            if (referenceImpl.getPrefix() != null && referenceImpl.getPrefix().toLowerCase().equals("xml")) {
                                URI uRI2 = FactoryImpl.instance().createURI();
                                uRI2.setValue(XML_namespace);
                                topComponent = this.getTopComponent(uRI2, referenceImpl.getTopComponentType(), referenceImpl.getNCName(), bl);
                                if (topComponent != null) {
                                    return topComponent;
                                }
                                throw new TopComponentNotFoundException(referenceImpl, null);
                            }
                            if (referenceImpl.getPrefix() == null || !referenceImpl.getPrefix().trim().equals("")) {
                                throw new TopComponentNotFoundException(referenceImpl, null);
                            }
                            if (referenceImpl.getSchema() != null && (importStatementArray = referenceImpl.getSchema().listImportStatement()) != null) {
                                int n = 0;
                                while (n < importStatementArray.length) {
                                    topComponent = importStatementArray[n].getTopComponent(null, referenceImpl.getTopComponentType(), referenceImpl.getNCName(), true);
                                    if (topComponent != null) {
                                        return topComponent;
                                    }
                                    ++n;
                                }
                            }
                            throw new TopComponentNotFoundException(referenceImpl, null);
                        }
                        URI uRI3 = uRI = namespaceDeclaration == null ? referenceImpl.getTargetNamespace() : namespaceDeclaration.getTargetNamespace();
                        if (SchemaImpl.schemaNS.equals(uRI)) {
                            topComponent = this.getBuiltInComponent(uRI, referenceImpl.getNCName(), referenceImpl.getTopComponentType());
                            if (topComponent != null) {
                                return topComponent;
                            }
                            if (referenceImpl.getSchema() == null || !SchemaImpl.schemaNS.equals(referenceImpl.getSchema().getTargetNamespace())) {
                                if (referenceImpl.getSchema() != null && referenceImpl.getNCName() != null && referenceImpl.getPrefix() != null && referenceImpl.getPrefix().equals("") && referenceImpl.getSchema().getTargetNamespace() == null && (referenceImpl.getSchema().getTopComponent(1, referenceImpl.getNCName(), false) != null || referenceImpl.getSchema().getTopComponent(2, referenceImpl.getNCName(), false) != null || referenceImpl.getSchema().getTopComponent(4, referenceImpl.getNCName(), false) != null || referenceImpl.getSchema().getTopComponent(3, referenceImpl.getNCName(), false) != null || referenceImpl.getSchema().getTopComponent(6, referenceImpl.getNCName(), false) != null || referenceImpl.getSchema().getTopComponent(5, referenceImpl.getNCName(), false) != null)) {
                                    throw new TopComponentNotFoundButIsInSchemaException(referenceImpl, null, referenceImpl.getNCName());
                                }
                                if (referenceImpl.getSchema() == null) {
                                    throw new TopComponentNotFoundException(referenceImpl, null);
                                }
                            }
                        }
                        uRIArray = null;
                        if (namespaceDeclaration == null || referenceImpl.getSchema() == null) break block36;
                        if (!namespaceDeclaration.getTargetNamespace().equals(((SchemaImpl)referenceImpl.getSchema()).getTargetNamespaceOrDefaultTargetNamespace())) break block37;
                        if (referenceImpl.isAReferenceToARedefinedTopComponent()) break block38;
                        topComponent = referenceImpl.getSchema().getTopComponent(referenceImpl.getTopComponentType(), referenceImpl.getNCName());
                        break block36;
                    }
                    object2 = (TopComponentImpl)referenceImpl.getTopComponentAncestor();
                    if (object2 == null || (object = object2.getRedefine()) == null || object.getLocation() == null) break block36;
                    object4 = object;
                    refObjectExtn = (SchemaImpl)referenceImpl.getSchema();
                    Schema schema = referenceImpl.getSchema();
                    schemaForParserImpl = null;
                    if (schema instanceof SchemaForParserImpl) {
                        schemaForParserImpl = (SchemaForParserImpl)schema;
                    }
                    if (schemaForParserImpl != null && schemaForParserImpl.getSchemaUsedForReferenceResolution() != null) {
                        referenceImpl.referencedRedefinedTopComponentAlreadyMarked(true);
                        refObjectExtn = schemaForParserImpl.getSchemaUsedForReferenceResolution();
                        object3 = SchemaImpl.getCompositionStatement((Schema)refObjectExtn, object.getLocation(), object.getExplicitTargetNamespace(), 3.0f);
                        if (object3 == null || ((CompositionStatement[])object3).length == 0) {
                            new RuntimeException("Application fatal error in OCM");
                        }
                        object4 = (RedefineStatement)object3[0];
                    }
                    if (referenceImpl.isReferencedRedefinedTopComponentAlreadyMarked()) break block39;
                    topComponent = object.getTopComponent(referenceImpl.getTopComponentType(), referenceImpl.getNCName(), true);
                    if (topComponent == null || topComponent.getSchema() == refObjectExtn) {
                        throw new ReferenceResolutionToARedefinedTopComponentException(referenceImpl);
                    }
                    object3 = (TopComponentImpl)topComponent;
                    ((TopComponentImpl)object3).setIsRedefined(true);
                    referenceImpl.referencedRedefinedTopComponentAlreadyMarked(true);
                    break block36;
                }
                topComponent = ((RedefineStatementImpl)object4).getTopComponent(new Stack(), referenceImpl.getTopComponentType(), referenceImpl.getNCName(), true, true);
                if (topComponent != null && topComponent.getSchema() != refObjectExtn) break block36;
                if (schemaForParserImpl != null && schemaForParserImpl.getSchemaUsedForReferenceResolution() != null) {
                    throw new ReferenceResolutionToARedefinedTopComponentException(referenceImpl);
                }
                topComponent = object.getTopComponent(referenceImpl.getTopComponentType(), referenceImpl.getNCName(), true);
                if (topComponent == null || topComponent.getSchema() == refObjectExtn) {
                    throw new ReferenceResolutionToARedefinedTopComponentException(referenceImpl);
                }
                object3 = (TopComponentImpl)topComponent;
                ((TopComponentImpl)object3).setIsRedefined(true);
                referenceImpl.referencedRedefinedTopComponentAlreadyMarked(true);
                break block36;
            }
            object2 = referenceImpl.getSchema().listImportStatement();
            if (object2 != null) {
                int n = 0;
                while (n < ((Object)object2).length) {
                    topComponent = object2[n].getTopComponent(uRI, referenceImpl.getTopComponentType(), referenceImpl.getNCName(), true);
                    if (topComponent != null) break;
                    ++n;
                }
            }
        }
        if (topComponent == null && referenceImpl.getSchema() != null) {
            boolean bl2 = false;
            if (referenceImpl.getTargetNamespace() == null && referenceImpl.getSchema().getTargetNamespace() == null || referenceImpl.getTargetNamespace() != null && referenceImpl.getTargetNamespace().equals(referenceImpl.getSchema().getTargetNamespace())) {
                bl2 = true;
            } else {
                object = referenceImpl.getSchema().listImportStatement();
                if (object != null) {
                    int n = 0;
                    while (n < ((ImportStatement[])object).length) {
                        refObjectExtn = object[n].getExplicitTargetNamespace();
                        if (refObjectExtn == null && referenceImpl.getTargetNamespace() == null || refObjectExtn != null && refObjectExtn.equals(referenceImpl.getTargetNamespace())) {
                            bl2 = true;
                        }
                        ++n;
                    }
                }
            }
            if (bl2) {
                if (topComponent == null) {
                    if (uRI == SchemaImpl.defaultTargetNamespace) {
                        uRI = null;
                    }
                    uRIArray = this.getLocations(uRI);
                }
                if (topComponent == null && uRIArray != null) {
                    object = new Vector<URI>(Arrays.asList(uRIArray));
                    if (((SchemaImpl)referenceImpl.getSchema()).getSaveAsLocation() != null) {
                        ((Vector)object).remove(((SchemaImpl)referenceImpl.getSchema()).getSaveAsLocation());
                    }
                    topComponent = this.getTopComponent(uRI, ((Vector)object).toArray(new URI[((Vector)object).size()]), referenceImpl.getTopComponentType(), referenceImpl.getNCName(), bl);
                }
            }
        }
        boolean bl3 = false;
        if (topComponent == null) {
            throw new TopComponentNotFoundException(referenceImpl, null);
        }
        return topComponent;
    }

    public TopComponent getTopComponent(URI uRI, URI[] uRIArray, int n, String string, boolean bl) throws NoLocationAssociatedWithNamespaceException {
        if (string == null) {
            return null;
        }
        TopComponent topComponent = null;
        if (SchemaImpl.schemaNS.equals(uRI) && (topComponent = this.getBuiltInComponent(uRI, string, n)) != null) {
            return topComponent;
        }
        if (uRIArray == null) {
            throw new NoLocationAssociatedWithNamespaceException(uRI);
        }
        int n2 = 0;
        while (n2 < uRIArray.length) {
            block13: {
                try {
                    topComponent = this.getTopComponent(uRI, uRIArray[n2], n, string, bl);
                }
                catch (ReferenceResolutionException referenceResolutionException) {
                    if (Debug.DEBUG) {
                        referenceResolutionException.printStackTrace(System.err);
                    }
                }
                catch (ParseException parseException) {
                    if (Debug.DEBUG) {
                        if (parseException.getException() != null) {
                            parseException.getException().printStackTrace(System.err);
                        } else {
                            parseException.printStackTrace(System.err);
                        }
                    }
                }
                catch (IOException iOException) {
                    if (!Debug.DEBUG) break block13;
                    iOException.printStackTrace(System.err);
                }
            }
            if (topComponent != null) {
                return topComponent;
            }
            ++n2;
        }
        return topComponent;
    }

    public TopComponent getTopComponent(URI uRI, int n, String string, boolean bl) throws NoLocationAssociatedWithNamespaceException {
        return this.getTopComponent(uRI, this.getLocations(uRI), n, string, bl);
    }

    public TopComponent getTopComponent(URI uRI, URI uRI2, int n, String string, boolean bl) throws ReferenceResolutionException, IOException, ParseException {
        return this.getTopComponent(new Stack(), uRI, uRI2, n, string, true, false, bl);
    }

    TopComponent getTopComponent(Stack stack, URI uRI, URI uRI2, int n, String string, boolean bl, boolean bl2, boolean bl3) throws ReferenceResolutionException, IOException, ParseException {
        if (string == null) {
            return null;
        }
        TopComponent topComponent = null;
        if (SchemaImpl.schemaNS.equals(uRI) && (topComponent = this.getBuiltInComponent(uRI, string, n)) != null) {
            return topComponent;
        }
        Schema schema = this.searchSchemaByLocation(uRI2, uRI);
        if (Debug.DEBUG) {
            System.out.println("location = " + uRI2 + " : schema = " + schema + " \n opened schemas : " + this.location_locationParseState);
        }
        if (schema == null) {
            Parser parser = this.getParser(this.getExtension(uRI2));
            LocationParseStateImpl locationParseStateImpl = (LocationParseStateImpl)this.location_locationParseState.get(uRI2);
            if (locationParseStateImpl == null) {
                locationParseStateImpl = new LocationParseStateImpl(uRI2);
                this.location_locationParseState.put(uRI2.clone(), locationParseStateImpl);
            }
            if ((schema = parser.parse(new InputSource(uRI2.getAbsoluteURL().toString()), uRI, n, string, locationParseStateImpl)) != null) {
                schema = locationParseStateImpl.addOrMergeSchemaRead(schema);
                if (DEBUG) {
                    System.out.println("In getTopComponent()");
                    System.out.println("New schema cached : TNS= " + schema.getTargetNamespace());
                    System.out.println("Opened locations : \n" + this.location_locationParseState);
                    System.out.println();
                    System.out.println();
                }
            }
        }
        if (schema != null) {
            topComponent = ((SchemaImpl)schema).getTopComponent(stack, n, string, bl, bl2);
        }
        return topComponent;
    }

    public long incrementComponentCount() {
        if (this.componentCount == maxComponents) {
            Runtime.getRuntime().runFinalization();
            Runtime.getRuntime().gc();
            long l = Runtime.getRuntime().freeMemory();
            long l2 = Runtime.getRuntime().totalMemory();
            if ((double)l < (double)l2 * percentFreeMemoryThatTriggersCachePurge) {
                System.out.println("\nThe number of cached components from all schemas has caused the percentange of memory that is free to fall below " + percentFreeMemoryThatTriggersCachePurge * 100.0 + ".  Processing will continue, but may result in a memory exception.\n");
                if (DEBUG) {
                    System.out.println("Number of instances per class \n" + SchemaObjectImpl.printNumberOfComponentPerClass());
                }
            } else {
                maxComponents += 5000L;
            }
        }
        return ++this.componentCount;
    }

    protected void initParsers() {
        this.defaultParser = new XSDParserImpl();
        this.registerParser("xsd", new XSDParserImpl());
        this.registerParser("xmi", new XMIParserImpl());
    }

    public boolean isDisableDuplicationChecker() {
        return this.disableDuplicationChecker;
    }

    public boolean isReferenceResolutionEnabled() {
        return this.enableReferenceResolution;
    }

    public static void main(String[] stringArray) throws Exception {
    }

    public Parser registerParser(String string, Parser parser) {
        Parser parser2 = this.parsers.put(string, parser);
        if (parser2 == null) {
            parser2 = this.defaultParser;
        }
        return parser2;
    }

    public void removeAllSchemaLocations() {
        this.flocations.clear();
        this.addStandardSchemaLocations();
    }

    public void removeAllTemporarySchemaLocations() {
        Iterator iterator = this.fTemporarylocations.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Object k = entry.getKey();
            Vector vector = (Vector)entry.getValue();
            int n = 0;
            while (n < vector.size()) {
                if (k == nullURI) {
                    this.removeLocationForNamespace(null, (URI)vector.get(n));
                } else {
                    this.removeLocationForNamespace((URI)k, (URI)vector.get(n));
                }
                ++n;
            }
        }
        this.fTemporarylocations.clear();
        this.addStandardSchemaLocations();
    }

    public void removeFromCache(Schema schema) {
        URI uRI = ((SchemaImpl)schema).getSaveAsLocation();
        if (uRI != null) {
            Schema[] schemaArray;
            LocationParseStateImpl locationParseStateImpl;
            if (Debug.DEBUG) {
                System.out.println("removing from OCM cache : " + schema);
            }
            if ((locationParseStateImpl = (LocationParseStateImpl)this.location_locationParseState.get(uRI)) != null && (schemaArray = locationParseStateImpl.getSchemasRead()) != null) {
                if (schemaArray.length == 1 && schemaArray[0] == schema) {
                    this.location_locationParseState.remove(uRI);
                } else {
                    locationParseStateImpl.remove(schema);
                    locationParseStateImpl.setAllSchemasRead(false);
                }
            }
        }
    }

    public void removeLocationForNamespace(URI uRI, URI uRI2) {
        Vector vector;
        Object object = uRI;
        if (object == null) {
            object = nullURI;
        }
        if ((vector = (Vector)this.flocations.get(object)) != null) {
            vector.removeElement(uRI2);
            if (vector.size() == 0) {
                this.flocations.remove(object);
            }
        }
    }

    public void save(Schema schema) throws Exception {
        String string;
        SchemaImpl schemaImpl = (SchemaImpl)schema;
        if (schemaImpl == null) {
            throw new OpenCloseManagerException("saving null schema: " + this);
        }
        URI uRI = schemaImpl.getSaveAsLocation();
        if (uRI == null) {
            throw new OpenCloseManagerException("saving to null schema location: " + this);
        }
        String string2 = null;
        File file = null;
        String string3 = uRI.toString();
        if (string3.indexOf(string = "file://") >= 0) {
            string3 = string3.substring(string3.indexOf(string) + string.length());
        }
        if (string3 == null) {
            throw new OpenCloseManagerException("saving to invalid schema location: " + this);
        }
        File file2 = new File(string3);
        if (file2 != null && file2.exists()) {
            string2 = string3 + ".AAA.bak";
            file = new File(string2);
            if (file != null && file.exists() && !file.delete()) {
                throw new OpenCloseManagerException("backup file " + string2 + " cannot be deleted.");
            }
            if (file2.renameTo(file)) {
                file2 = new File(string3);
            } else {
                throw new OpenCloseManagerException("file " + string3 + " cannot be renamed to " + string2);
            }
        }
        FileWriter fileWriter = new FileWriter(file2);
        DocumentImpl documentImpl = new DocumentImpl();
        Element element = (Element)schema.toXMLRepresentation(documentImpl);
        OutputFormat outputFormat = new OutputFormat(documentImpl);
        outputFormat.setIndenting(true);
        XMLSerializer xMLSerializer = new XMLSerializer(fileWriter, outputFormat);
        xMLSerializer.serialize(element);
        fileWriter.flush();
        fileWriter.close();
        if (file != null && file.exists() && !file.delete()) {
            throw new OpenCloseManagerException("backup file " + string2 + " cannot be deleted.");
        }
    }

    public void saveAs(Schema schema, URL uRL) throws Exception {
        LocationParseStateImpl locationParseStateImpl;
        SchemaImpl schemaImpl = (SchemaImpl)schema;
        if (schema == null) {
            throw new OpenCloseManagerException("saving null schema: " + this);
        }
        if (uRL == null) {
            throw new OpenCloseManagerException("saving schema to null location: " + this);
        }
        URI uRI = FactoryImpl.instance().createURI();
        uRI.setValue(uRL.toString());
        URI uRI2 = schemaImpl.getSaveAsLocation();
        schemaImpl.setSaveAsLocation(uRI);
        try {
            this.save(schema);
        }
        catch (Exception exception) {
            schemaImpl.setSaveAsLocation(uRI2);
            throw exception;
        }
        if (uRI2 != null) {
            this.removeLocationForNamespace(schema.getTargetNamespace(), uRI2);
            locationParseStateImpl = (LocationParseStateImpl)this.location_locationParseState.remove(uRI2);
        }
        locationParseStateImpl = new LocationParseStateImpl(uRI);
        schema = locationParseStateImpl.addOrMergeSchemaRead(schema);
        locationParseStateImpl.setAllSchemasRead(true);
        this.location_locationParseState.put(uRI.clone(), locationParseStateImpl);
    }

    public Schema[] searchSchemaByLocation(URI uRI) {
        LocationParseStateImpl locationParseStateImpl = (LocationParseStateImpl)this.location_locationParseState.get(uRI);
        if (locationParseStateImpl != null) {
            return locationParseStateImpl.getSchemasRead();
        }
        return null;
    }

    public Schema searchSchemaByLocation(URI uRI, URI uRI2) {
        LocationParseStateImpl locationParseStateImpl = (LocationParseStateImpl)this.location_locationParseState.get(uRI);
        if (locationParseStateImpl != null) {
            return locationParseStateImpl.getSchema(uRI2);
        }
        return null;
    }

    private Vector searchSchemaByNamespace(URI uRI) {
        Vector<Schema> vector = new Vector<Schema>();
        Enumeration enumeration = this.location_locationParseState.elements();
        while (enumeration.hasMoreElements()) {
            LocationParseStateImpl locationParseStateImpl = (LocationParseStateImpl)enumeration.nextElement();
            Schema schema = locationParseStateImpl.getSchema(uRI);
            if (schema == null) continue;
            vector.addElement(schema);
        }
        return vector;
    }

    void setComponentCount(long l) {
        this.componentCount = l;
    }

    public void setDefaultParser(Parser parser) {
        this.defaultParser = parser;
    }

    public void setDisableDuplicationChecker(boolean bl) {
        this.disableDuplicationChecker = bl;
    }

    public static void setIndicateProgress(boolean bl) {
        indicateProgress = bl;
    }

    public static void setPercentFreeMemoryThatTriggersCachePurge(double d) {
        percentFreeMemoryThatTriggersCachePurge = d;
    }

    public static void setPercentFreeMemoryThatTriggersCachePurge(float f) {
        percentFreeMemoryThatTriggersCachePurge = f;
    }

    public void setProgressMonitor(ProgressMonitor progressMonitor) {
        this.progressMonitor = progressMonitor;
    }

    private void unlinkReferences(Schema schema) {
        this.disableDuplicationChecker = true;
        if (schema instanceof SchemaImpl) {
            ((SchemaImpl)schema).unlinkReferences();
        }
        this.disableDuplicationChecker = false;
    }

    public void unregisterAllParsers() {
        this.parsers.clear();
    }

    public void unregisterParser(String string) {
        this.parsers.remove(string);
    }

    public LocationParseState getLocationParseState(URI uRI) {
        LocationParseStateImpl locationParseStateImpl = (LocationParseStateImpl)this.location_locationParseState.get(uRI);
        if (locationParseStateImpl == null) {
            locationParseStateImpl = new LocationParseStateImpl(uRI);
            this.location_locationParseState.put(uRI.clone(), locationParseStateImpl);
        }
        return locationParseStateImpl;
    }

    static {
        try {
            URL.setURLStreamHandlerFactory(new RedirectionURLHandlerFactory(locationCorrespondance));
        }
        catch (SecurityException securityException) {
            System.out.println("Location Correspondance association cannot be performed.");
            System.out.println("The following error indicates that you don't have  RuntimePermission(\"setFactory\")or java.net.NetPermission(\"specifyStreamHandler\")");
            System.out.println(securityException.getMessage());
        }
        catch (Error error) {
            System.out.println("warning: Location correspondence disabled");
        }
        indicateProgress = false;
        theOpenCloseManager = null;
        XML_namespace_SchemaLocation = Resources.NAMESPACE_SCHEMA_LOCATION.toString();
        maxComponents = 10000L;
        percentFreeMemoryThatTriggersCachePurge = 0.25;
        DEBUG = false;
    }

    private class KeyRefResolver
    extends DefaultGraphVisitor {
        public static final String copyright = "Licensed Materials - Property of IBM (C) Copyright IBM Corp. 2000, 2001, 2002    All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
        private IdentityConstraint referencedIdConst = null;
        private IdentityConstraintIdentifier idConstToLookFor;
        private Condition condition = new Condition();

        private IdentityConstraint getReferencedIdentityConstraint() {
            return this.referencedIdConst;
        }

        private KeyRefResolver(IdentityConstraintIdentifier identityConstraintIdentifier) {
            this.idConstToLookFor = identityConstraintIdentifier;
        }

        public TraverseEdgeCondition getCondition() {
            return this.condition;
        }

        public void visitVertex(Vertex vertex) {
            Object[] objectArray;
            CollectionWithDuplications.EquivalenceClass equivalenceClass;
            if (this.referencedIdConst != null) {
                return;
            }
            SchemaImpl schemaImpl = (SchemaImpl)vertex.getObject();
            CollectionWithDuplications collectionWithDuplications = schemaImpl.getIdentityConstraints();
            if (collectionWithDuplications != null && (equivalenceClass = collectionWithDuplications.get(this.idConstToLookFor)) != null && (objectArray = equivalenceClass.elements()) != null) {
                int n = 0;
                while (n < objectArray.length) {
                    IdentityConstraint identityConstraint = (IdentityConstraint)objectArray[n];
                    if (identityConstraint.getType() == 1 || identityConstraint.getType() == 0) {
                        this.referencedIdConst = identityConstraint;
                        return;
                    }
                    ++n;
                }
            }
        }

        public void initSearch() {
            this.referencedIdConst = null;
        }

        private class Condition
        extends TraverseEdgeCondition {
            public static final String copyright = "Licensed Materials - Property of IBM (C) Copyright IBM Corp. 2000, 2001, 2002    All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

            private Condition() {
            }

            public boolean traverse(Vertex vertex, EdgeEnd edgeEnd, GraphVisitor graphVisitor) {
                if (edgeEnd.getWeight() == 5.0f) {
                    return false;
                }
                return KeyRefResolver.this.referencedIdConst == null || KeyRefResolver.this.idConstToLookFor != null;
            }
        }
    }

    private class LocationParseStateImpl
    implements LocationParseState {
        public static final String copyright = "Licensed Materials - Property of IBM (C) Copyright IBM Corp. 2000, 2001, 2002    All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
        private HashMap namespace_schema = new HashMap();
        private boolean allSchemasRead = false;
        private URI location;

        private LocationParseStateImpl(URI uRI) {
            this.location = uRI;
        }

        public void addOrMergeSchemaRead(Schema[] schemaArray) {
            int n = 0;
            while (n < schemaArray.length) {
                this.addOrMergeSchemaRead(schemaArray[n]);
                ++n;
            }
        }

        public void remove(Schema schema) {
            URI uRI = schema.getTargetNamespace();
            this.namespace_schema.remove(uRI);
        }

        public Schema addOrMergeSchemaRead(Schema schema) {
            URI uRI = schema.getTargetNamespace();
            Schema schema2 = (Schema)this.namespace_schema.get(uRI);
            if (schema2 != null) {
                SchemaImpl.merge(schema2, schema);
                ((SchemaImpl)schema).setSaveAsLocation(this.location);
                return schema2;
            }
            if (uRI != null) {
                this.namespace_schema.put(uRI.clone(), schema);
            } else {
                this.namespace_schema.put(null, schema);
            }
            ((SchemaImpl)schema).setSaveAsLocation(this.location);
            return schema;
        }

        public boolean areAllSchemasRead() {
            return this.allSchemasRead;
        }

        public boolean equals(Object object) {
            if (object instanceof LocationParseState) {
                return this.location.equals(((LocationParseState)object).getLocation());
            }
            return false;
        }

        public URI getLocation() {
            return this.location;
        }

        public Schema getSchema(URI uRI) {
            return (Schema)this.namespace_schema.get(uRI);
        }

        public Schema[] getSchemasRead() {
            Schema[] schemaArray = null;
            Collection collection = this.namespace_schema.values();
            if (collection.size() > 0) {
                schemaArray = new Schema[collection.size()];
                schemaArray = collection.toArray(schemaArray);
            }
            return schemaArray;
        }

        public int hashCode() {
            return this.location.hashCode();
        }

        public void setAllSchemasRead(boolean bl) {
            this.allSchemasRead = bl;
        }
    }
}

