/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.ecm.schema.impl;

import com.ibm.xml.ecm.schema.BuiltInDatatypeDef;
import com.ibm.xml.ecm.schema.DatatypeFormatException;
import com.ibm.xml.ecm.schema.EnumerationFacetValueOutOfBoundsException;
import com.ibm.xml.ecm.schema.Facet;
import com.ibm.xml.ecm.schema.InvalidStateException;
import com.ibm.xml.ecm.schema.SchemaException;
import com.ibm.xml.ecm.schema.SimpleType;
import com.ibm.xml.ecm.schema.Type;
import com.ibm.xml.ecm.schema.TypeInfo;
import com.ibm.xml.ecm.schema.impl.Debug;
import com.ibm.xml.ecm.schema.impl.FacetImpl;
import com.ibm.xml.ecm.schema.impl.FacetStrategy;
import com.ibm.xml.ecm.schema.impl.Order;
import com.ibm.xml.ecm.schema.impl.PrimitiveDatatypeImpl;
import com.ibm.xml.ecm.schema.impl.WhiteSpaceFacetStrategy;

public abstract class OrderFacetStrategy
extends FacetStrategy {
    public static final String copyright = "Licensed Materials - Property of IBM (C) Copyright IBM Corp. 2000, 2001, 2002    All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected BuiltInDatatypeDef builtInDatatype;

    public OrderFacetStrategy(BuiltInDatatypeDef builtInDatatypeDef) {
        this.builtInDatatype = builtInDatatypeDef;
    }

    SchemaException[] compatibleWithEnumFacet(Type type, Facet facet, Facet facet2, boolean bl) {
        block12: {
            try {
                switch (facet2.getFacetType()) {
                    case 6: {
                        String[] stringArray = facet2.getValuesAsString();
                        if (stringArray != null && bl) {
                            int n = 0;
                            while (n < stringArray.length) {
                                if (!facet.validate(stringArray[n])) {
                                    return new SchemaException[]{new EnumerationFacetValueOutOfBoundsException(type, facet, facet2, !bl)};
                                }
                                ++n;
                            }
                        }
                        break;
                    }
                }
            }
            catch (InvalidStateException invalidStateException) {
                if (Debug.DEBUG) {
                    invalidStateException.printStackTrace(System.err);
                }
            }
            catch (SchemaException schemaException) {
                if (Debug.DEBUG) {
                    schemaException.printStackTrace(System.err);
                }
            }
            catch (ClassCastException classCastException) {
                if (!Debug.DEBUG) break block12;
                classCastException.printStackTrace(System.err);
            }
        }
        return null;
    }

    Object convertToAppropriatedObject(String[] stringArray) throws DatatypeFormatException {
        if (stringArray == null || stringArray.length <= 0) {
            return null;
        }
        try {
            Order order = (Order)this.builtInDatatype.convert(WhiteSpaceFacetStrategy.normalize(stringArray[0], this.builtInDatatype));
            return order;
        }
        catch (ClassCastException classCastException) {
            if (Debug.DEBUG) {
                classCastException.printStackTrace();
            }
            throw new DatatypeFormatException(null, stringArray[0], this.getFacetType());
        }
        catch (DatatypeFormatException datatypeFormatException) {
            datatypeFormatException.setContext(this.getFacetType());
            throw datatypeFormatException;
        }
    }

    protected abstract int getFacetType();

    protected Order getValue(Facet facet) throws DatatypeFormatException, ClassCastException, InvalidStateException {
        Order order = null;
        if (facet instanceof FacetImpl) {
            order = (Order)((FacetImpl)facet).getValueAsObject();
        }
        if (order == null) {
            order = (Order)this.convertToAppropriatedObject(facet.getValuesAsString());
        }
        return order;
    }

    public static Order next(Type type, Order order) throws SchemaException {
        if (type.isSimpleType()) {
            return (Order)((SimpleType)type).next(order);
        }
        if (type.isComplexType()) {
            TypeInfo typeInfo = type.getBasetype();
            Type type2 = null;
            while (typeInfo != null && !(type2 = typeInfo.resolveToType()).isSimpleType()) {
                typeInfo = type2.getBasetype();
            }
            if (typeInfo == null) {
                return null;
            }
            if (type2 != null && type2.isSimpleType()) {
                PrimitiveDatatypeImpl primitiveDatatypeImpl = (PrimitiveDatatypeImpl)((SimpleType)type2).getPrimitiveDatatype();
                if (primitiveDatatypeImpl != null) {
                    return (Order)primitiveDatatypeImpl.next(order, type);
                }
                return null;
            }
            return null;
        }
        return null;
    }

    public static Order previous(Type type, Order order) throws SchemaException {
        if (type.isSimpleType()) {
            return (Order)((SimpleType)type).previous(order);
        }
        if (type.isComplexType()) {
            TypeInfo typeInfo = type.getBasetype();
            Type type2 = null;
            while (typeInfo != null && !(type2 = typeInfo.resolveToType()).isSimpleType()) {
                typeInfo = type2.getBasetype();
            }
            if (typeInfo == null) {
                return null;
            }
            if (type2 != null && type2.isSimpleType()) {
                PrimitiveDatatypeImpl primitiveDatatypeImpl = (PrimitiveDatatypeImpl)((SimpleType)type2).getPrimitiveDatatype();
                if (primitiveDatatypeImpl != null) {
                    return (Order)primitiveDatatypeImpl.previous(order, type);
                }
                return null;
            }
            return null;
        }
        return null;
    }

    public static boolean validate(Facet[] facetArray, String string) throws InvalidStateException {
        if (facetArray == null) {
            return true;
        }
        int n = 0;
        while (n < facetArray.length) {
            if (!facetArray[n].validate(string)) {
                return false;
            }
            ++n;
        }
        return true;
    }

    abstract boolean validate(Facet var1, Order var2);

    boolean validate(Facet facet, String string) {
        try {
            return this.validate(facet, (Order)this.builtInDatatype.convert(string));
        }
        catch (DatatypeFormatException datatypeFormatException) {
            if (Debug.DEBUG) {
                datatypeFormatException.printStackTrace();
            }
            return false;
        }
        catch (ClassCastException classCastException) {
            if (Debug.DEBUG) {
                classCastException.printStackTrace();
            }
            return false;
        }
    }
}

