/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.ecm.schema.impl;

import com.ibm.xml.ecm.schema.BigOccursValueWarning;
import com.ibm.xml.ecm.schema.ContentModel;
import com.ibm.xml.ecm.schema.Group;
import com.ibm.xml.ecm.schema.IllegalOccursValueForAllGroupException;
import com.ibm.xml.ecm.schema.IllegalOccursValueParticleException;
import com.ibm.xml.ecm.schema.Particle;
import com.ibm.xml.ecm.schema.SchemaException;
import com.ibm.xml.ecm.schema.SchemaObject;
import com.ibm.xml.ecm.schema.impl.AbstractChecker;
import com.ibm.xml.ecm.schema.impl.CheckType;
import com.ibm.xml.ecm.schema.impl.OccursImpl;

public class ParticleValidOccurs_Checker
extends AbstractChecker {
    public static final String copyright = "Licensed Materials - Property of IBM (C) Copyright IBM Corp. 2000, 2001, 2002    All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private SchemaException[] exceptions;
    public static CheckType ID = new CheckType("Particle Valid Occurs checker");
    static /* synthetic */ Class class$com$ibm$xml$ecm$schema$Particle;

    public ParticleValidOccurs_Checker() {
    }

    public ParticleValidOccurs_Checker(Particle particle) {
        super(particle);
    }

    public boolean check(boolean bl) {
        SchemaObject schemaObject;
        Group group;
        Particle particle = (Particle)this.subject;
        this.exceptions = null;
        if (particle.isGroup() && particle.asGroup().getCompositor() == 2 && (group = particle.asGroup()).getMaxOccurs().equals("0") && (schemaObject = group.getParent()) != null && !(schemaObject instanceof ContentModel)) {
            this.exceptions = new SchemaException[]{new IllegalOccursValueForAllGroupException(group)};
            return false;
        }
        int n = Integer.parseInt(particle.getMinOccurs());
        int n2 = 0;
        if (!OccursImpl.UNBOUNDED.equals(particle.getMaxOccurs()) && n > (n2 = Integer.parseInt(particle.getMaxOccurs()))) {
            this.exceptions = new SchemaException[]{new IllegalOccursValueParticleException(particle)};
            return false;
        }
        if (n > 4096) {
            this.exceptions = new SchemaException[]{new BigOccursValueWarning(particle, true)};
            return false;
        }
        if (n2 > 4096) {
            this.exceptions = new SchemaException[]{new BigOccursValueWarning(particle, false)};
            return false;
        }
        return true;
    }

    public CheckType getCheckType() {
        return ID;
    }

    public int getCost() {
        return 1;
    }

    public SchemaException[] getExceptions() {
        return this.exceptions;
    }

    public Class getSubjectClass() {
        return class$com$ibm$xml$ecm$schema$Particle == null ? (class$com$ibm$xml$ecm$schema$Particle = ParticleValidOccurs_Checker.class$("com.ibm.xml.ecm.schema.Particle")) : class$com$ibm$xml$ecm$schema$Particle;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        CheckType.register(ID);
    }
}

