/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.ecm.schema.impl;

import com.ibm.xml.ecm.schema.DatatypeFormatException;
import com.ibm.xml.ecm.schema.Facet;
import com.ibm.xml.ecm.schema.InvalidRegularExpressionException;
import com.ibm.xml.ecm.schema.InvalidStateException;
import com.ibm.xml.ecm.schema.ReferenceResolutionException;
import com.ibm.xml.ecm.schema.RegularExpressionNotMatchedException;
import com.ibm.xml.ecm.schema.SchemaException;
import com.ibm.xml.ecm.schema.SimpleType;
import com.ibm.xml.ecm.schema.Type;
import com.ibm.xml.ecm.schema.impl.Debug;
import com.ibm.xml.ecm.schema.impl.FacetImpl;
import com.ibm.xml.ecm.schema.impl.FacetStrategy;
import java.util.Arrays;
import java.util.TreeSet;
import org.apache.xerces.impl.xpath.regex.Match;
import org.apache.xerces.impl.xpath.regex.ParseException;
import org.apache.xerces.impl.xpath.regex.RegularExpression;

public class PatternStringFacetStrategy
extends FacetStrategy {
    public static final String copyright = "Licensed Materials - Property of IBM (C) Copyright IBM Corp. 2000, 2001, 2002    All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    PatternStringFacetStrategy() {
    }

    SchemaException[] compatibleWithOtherFacet(Type type, Facet facet, Facet facet2, boolean bl) {
        block15: {
            if (facet.getFacetType() != 5) {
                return null;
            }
            SchemaException[] schemaExceptionArray = super.compatibleWithOtherFacet(type, facet, facet2, bl);
            if (schemaExceptionArray != null) {
                return schemaExceptionArray;
            }
            if (!type.isSimpleType()) {
                return null;
            }
            SimpleType simpleType = (SimpleType)type;
            try {
                if (simpleType.getVariety() != 0) {
                    return null;
                }
                RegularExpression regularExpression = (RegularExpression)facet.getValueAsObject();
                if (regularExpression == null) {
                    return null;
                }
            }
            catch (DatatypeFormatException datatypeFormatException) {
                if (Debug.DEBUG) {
                    datatypeFormatException.printStackTrace(System.err);
                }
            }
            catch (InvalidStateException invalidStateException) {
                if (Debug.DEBUG) {
                    invalidStateException.printStackTrace(System.err);
                }
            }
            catch (ReferenceResolutionException referenceResolutionException) {
                if (Debug.DEBUG) {
                    referenceResolutionException.printStackTrace(System.err);
                }
            }
            catch (ClassCastException classCastException) {
                if (Debug.DEBUG) {
                    classCastException.printStackTrace(System.err);
                }
            }
            catch (NullPointerException nullPointerException) {
                if (!Debug.DEBUG) break block15;
                nullPointerException.printStackTrace(System.err);
            }
        }
        return null;
    }

    Object convertToAppropriatedObject(String[] stringArray) throws DatatypeFormatException {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < stringArray.length) {
            try {
                new RegularExpression(stringArray[n], "X");
                if (n > 0) {
                    stringBuffer.append("|" + stringArray[n]);
                } else {
                    stringBuffer.append(stringArray[n]);
                }
            }
            catch (ParseException parseException) {
                throw new InvalidRegularExpressionException(stringArray[n], parseException);
            }
            ++n;
        }
        try {
            return new RegularExpression(stringBuffer.toString(), "X");
        }
        catch (ParseException parseException) {
            throw new RuntimeException("Implementation Error : " + parseException.getMessage());
        }
    }

    protected RegularExpression getValue(Facet facet) throws ClassCastException, DatatypeFormatException, InvalidStateException {
        RegularExpression regularExpression = null;
        if (facet instanceof FacetImpl) {
            regularExpression = (RegularExpression)((FacetImpl)facet).getValueAsObject();
        }
        if (regularExpression == null) {
            regularExpression = (RegularExpression)this.convertToAppropriatedObject(facet.getValuesAsString());
        }
        return regularExpression;
    }

    boolean inOrder(Facet facet, Facet facet2) {
        return true;
    }

    boolean isEqual(Facet facet, Facet facet2) {
        String[] stringArray = facet.getValuesAsString();
        String[] stringArray2 = facet2.getValuesAsString();
        if (stringArray == null) {
            return stringArray2 == null;
        }
        if (stringArray2 == null) {
            return stringArray == null;
        }
        TreeSet<String> treeSet = new TreeSet<String>();
        TreeSet<String> treeSet2 = new TreeSet<String>();
        treeSet.addAll(Arrays.asList(stringArray));
        treeSet2.addAll(Arrays.asList(stringArray2));
        return treeSet.equals(treeSet2);
    }

    public static void main(String[] stringArray) throws Exception {
        stringArray = new String[]{"(\\d{3}-)?\\d{3}-\\d{4}", "222-333444-96636", "999-999-555589", "122-55d-5ddh", "2333-555-4444", "333-444-5555"};
        RegularExpression regularExpression = new RegularExpression(stringArray[0]);
        regularExpression = new RegularExpression("[\\i-[:]][\\c-[:]]*");
        Match match = new Match();
        System.out.println(regularExpression.matches(":::::21lkj:coucou", match) && match.getCapturedText(0).equals(":::::21lkj:coucou"));
    }

    private String patternAsString(Facet facet) {
        String[] stringArray = facet.getValuesAsString();
        StringBuffer stringBuffer = new StringBuffer();
        if (stringArray == null) {
            return null;
        }
        int n = 0;
        while (n < stringArray.length) {
            if (n > 0) {
                stringBuffer.append("|");
            }
            stringBuffer.append(stringArray[n]);
            ++n;
        }
        return stringBuffer.toString();
    }

    boolean validate(Facet facet, String string) {
        return this.validate(facet, string, null);
    }

    boolean validate(Facet facet, String string, DatatypeFormatException[] datatypeFormatExceptionArray) {
        try {
            Match match = new Match();
            RegularExpression regularExpression = this.getValue(facet);
            if (regularExpression.matches(string.trim(), match) && match.getCapturedText(0).equals(string.trim())) {
                return true;
            }
            if (datatypeFormatExceptionArray != null && datatypeFormatExceptionArray.length > 0) {
                datatypeFormatExceptionArray[0] = new RegularExpressionNotMatchedException(regularExpression, facet.getValuesAsString()[0], match, string.trim());
            }
            return false;
        }
        catch (DatatypeFormatException datatypeFormatException) {
            if (Debug.DEBUG) {
                datatypeFormatException.printStackTrace();
            }
            return false;
        }
        catch (ClassCastException classCastException) {
            if (Debug.DEBUG) {
                classCastException.printStackTrace();
            }
            return false;
        }
        catch (InvalidStateException invalidStateException) {
            if (Debug.DEBUG) {
                invalidStateException.printStackTrace();
            }
            return false;
        }
    }
}

