/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.ecm.schema.impl;

import com.ibm.xml.ecm.schema.ProgressMonitor;

public class PercentageOfWorkDoneIndicator
implements ProgressMonitor {
    protected int MAX_STARS = 20;
    protected int totalWork = -1;
    protected int alreadyDone = -1;
    protected int alreadyDisplayedStars = 0;
    protected boolean displayStars = true;

    public PercentageOfWorkDoneIndicator() {
    }

    public PercentageOfWorkDoneIndicator(boolean bl) {
        this.displayStars(bl);
    }

    public void validationSubTask(String string) {
        this.subTask("Validating schema " + string);
    }

    public void readingSubTask(String string) {
        this.subTask("Reading schema " + string);
    }

    public void beginTask(String string, int n) {
        if (this.totalWork < 0) {
            this.totalWork = n;
            int n2 = 1;
            while (n2 <= this.MAX_STARS) {
                System.out.print("*");
                ++n2;
            }
            System.out.println("");
        }
    }

    public void done() {
        this.totalWork = -1;
        this.alreadyDone = -1;
        if (this.displayStars) {
            int n = 1;
            while (n <= this.MAX_STARS - this.alreadyDisplayedStars) {
                System.out.print("*");
                ++n;
            }
            System.out.println("");
        }
        this.alreadyDisplayedStars = 0;
    }

    public void internalWorked(double d) {
    }

    public boolean isCanceled() {
        return false;
    }

    public void setCanceled(boolean bl) {
    }

    public void setTaskName(String string) {
    }

    public void subTask(String string) {
    }

    public void worked(int n) {
        this.alreadyDone += n;
        double d = (double)this.alreadyDone / (double)this.totalWork;
        int n2 = (int)Math.round(d * (double)this.MAX_STARS);
        if (this.alreadyDisplayedStars >= this.MAX_STARS) {
            return;
        }
        if (this.displayStars) {
            int n3 = 1;
            while (n3 <= n2 - this.alreadyDisplayedStars) {
                System.out.print("*");
                ++n3;
            }
        } else if (n2 - this.alreadyDisplayedStars > 0) {
            System.out.println("% done : " + (int)Math.round(d * 100.0));
        }
        this.alreadyDisplayedStars = n2;
    }

    public void displayStars(boolean bl) {
        this.displayStars = bl;
    }
}

