/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.ecm.schema.impl;

import com.ibm.xml.ecm.schema.DatatypeFormatException;
import com.ibm.xml.ecm.schema.Facet;
import com.ibm.xml.ecm.schema.FacetConstraintException;
import com.ibm.xml.ecm.schema.InvalidStateException;
import com.ibm.xml.ecm.schema.SchemaException;
import com.ibm.xml.ecm.schema.SimpleType;
import com.ibm.xml.ecm.schema.Type;
import com.ibm.xml.ecm.schema.impl.BuiltInDatatypeFactory;
import com.ibm.xml.ecm.schema.impl.Debug;
import com.ibm.xml.ecm.schema.impl.DecimalLiteral;
import com.ibm.xml.ecm.schema.impl.FacetImpl;
import com.ibm.xml.ecm.schema.impl.FacetStrategy;

public class PrecisionFacetStrategy
extends FacetStrategy {
    public static final String copyright = "Licensed Materials - Property of IBM (C) Copyright IBM Corp. 2000, 2001, 2002    All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    SchemaException[] compatibleWithOtherFacet(Type type, Facet facet, Facet facet2, boolean bl) {
        block11: {
            if (facet.getFacetType() != 8) {
                return null;
            }
            SchemaException[] schemaExceptionArray = super.compatibleWithOtherFacet(type, facet, facet2, bl);
            if (schemaExceptionArray != null) {
                return schemaExceptionArray;
            }
            try {
                Integer n = (Integer)facet.getValueAsObject();
                switch (facet2.getFacetType()) {
                    case 9: {
                        Comparable comparable = (Comparable)facet2.getValueAsObject();
                        if (n == null || comparable == null || n.compareTo(comparable) >= 0) break;
                        return new SchemaException[]{new FacetConstraintException(type, facet, facet2, !bl, "less than")};
                    }
                }
            }
            catch (DatatypeFormatException datatypeFormatException) {
                if (Debug.DEBUG) {
                    datatypeFormatException.printStackTrace(System.err);
                }
            }
            catch (InvalidStateException invalidStateException) {
                if (Debug.DEBUG) {
                    invalidStateException.printStackTrace(System.err);
                }
            }
            catch (ClassCastException classCastException) {
                if (!Debug.DEBUG) break block11;
                classCastException.printStackTrace(System.err);
            }
        }
        return null;
    }

    Object convertToAppropriatedObject(String[] stringArray) throws DatatypeFormatException {
        try {
            Integer n = new Integer(stringArray[0].trim());
            if (n <= 0) {
                throw new DatatypeFormatException((SimpleType)BuiltInDatatypeFactory.getInstance().getBuiltInDatatype("positiveInteger"), stringArray[0], 8);
            }
            return n;
        }
        catch (NumberFormatException numberFormatException) {
            if (Debug.DEBUG) {
                numberFormatException.printStackTrace(System.err);
            }
            throw new DatatypeFormatException((SimpleType)BuiltInDatatypeFactory.getInstance().getBuiltInDatatype("positiveInteger"), stringArray[0], 8);
        }
    }

    protected Integer getValue(Facet facet) throws ClassCastException, DatatypeFormatException, InvalidStateException {
        Integer n = null;
        if (facet instanceof FacetImpl) {
            n = (Integer)((FacetImpl)facet).getValueAsObject();
        }
        if (n == null) {
            n = (Integer)this.convertToAppropriatedObject(facet.getValuesAsString());
        }
        return n;
    }

    boolean inOrder(Facet facet, Facet facet2) {
        try {
            if (facet == null || facet2 == null) {
                return false;
            }
            return this.getValue(facet).compareTo(this.getValue(facet2)) <= 0;
        }
        catch (InvalidStateException invalidStateException) {
            if (Debug.DEBUG) {
                invalidStateException.printStackTrace();
            }
            return false;
        }
        catch (DatatypeFormatException datatypeFormatException) {
            if (Debug.DEBUG) {
                datatypeFormatException.printStackTrace();
            }
            return false;
        }
        catch (ClassCastException classCastException) {
            if (Debug.DEBUG) {
                classCastException.printStackTrace();
            }
            return false;
        }
        catch (NullPointerException nullPointerException) {
            if (Debug.DEBUG) {
                nullPointerException.printStackTrace();
            }
            return false;
        }
    }

    boolean isEqual(Facet facet, Facet facet2) {
        try {
            if (facet == null || facet2 == null) {
                return false;
            }
            return this.getValue(facet).compareTo(this.getValue(facet2)) == 0;
        }
        catch (InvalidStateException invalidStateException) {
            if (Debug.DEBUG) {
                invalidStateException.printStackTrace();
            }
            return false;
        }
        catch (DatatypeFormatException datatypeFormatException) {
            if (Debug.DEBUG) {
                datatypeFormatException.printStackTrace();
            }
            return false;
        }
        catch (ClassCastException classCastException) {
            if (Debug.DEBUG) {
                classCastException.printStackTrace();
            }
            return false;
        }
        catch (NullPointerException nullPointerException) {
            if (Debug.DEBUG) {
                nullPointerException.printStackTrace();
            }
            return false;
        }
    }

    boolean validate(Facet facet, String string) {
        try {
            if (facet == null || string == null) {
                return false;
            }
            DecimalLiteral decimalLiteral = new DecimalLiteral(string);
            return decimalLiteral.getTotalDigit() <= this.getValue(facet);
        }
        catch (InvalidStateException invalidStateException) {
            if (Debug.DEBUG) {
                invalidStateException.printStackTrace();
            }
            return false;
        }
        catch (DatatypeFormatException datatypeFormatException) {
            if (Debug.DEBUG) {
                datatypeFormatException.printStackTrace();
            }
            return false;
        }
        catch (ClassCastException classCastException) {
            if (Debug.DEBUG) {
                classCastException.printStackTrace();
            }
            return false;
        }
        catch (NullPointerException nullPointerException) {
            if (Debug.DEBUG) {
                nullPointerException.printStackTrace();
            }
            return false;
        }
    }
}

