/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.ecm.schema.impl;

import com.ibm.sketch.util.IdConstraintComparator;
import com.ibm.xml.ecm.schema.ContentModel;
import com.ibm.xml.ecm.schema.DatatypeFormatException;
import com.ibm.xml.ecm.schema.ElementDecl;
import com.ibm.xml.ecm.schema.ElementRef;
import com.ibm.xml.ecm.schema.GlobalElementDecl;
import com.ibm.xml.ecm.schema.Group;
import com.ibm.xml.ecm.schema.IdentityConstraint;
import com.ibm.xml.ecm.schema.LocalElementDecl;
import com.ibm.xml.ecm.schema.ModelGroupDef;
import com.ibm.xml.ecm.schema.ModelGroupRef;
import com.ibm.xml.ecm.schema.Occurs;
import com.ibm.xml.ecm.schema.Particle;
import com.ibm.xml.ecm.schema.ParticleWildcard;
import com.ibm.xml.ecm.schema.ReferenceResolutionException;
import com.ibm.xml.ecm.schema.Restrictable;
import com.ibm.xml.ecm.schema.SchemaComponent;
import com.ibm.xml.ecm.schema.SchemaException;
import com.ibm.xml.ecm.schema.URI;
import com.ibm.xml.ecm.schema.gen.impl.FactoryImplGen;
import com.ibm.xml.ecm.schema.impl.BuiltInDatatypeFactory;
import com.ibm.xml.ecm.schema.impl.GroupImpl;
import com.ibm.xml.ecm.schema.impl.OccursImpl;
import com.ibm.xml.ecm.schema.impl.SchemaObjectImpl;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.TreeSet;
import java.util.Vector;

public class RestrictableHelper {
    public static final String copyright = "Licensed Materials - Property of IBM (C) Copyright IBM Corp. 2000, 2001, 2002    All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public Restrictable choiceWithEquivalenceClassMembers(ElementRef elementRef) throws ReferenceResolutionException {
        Restrictable restrictable;
        GlobalElementDecl globalElementDecl = (GlobalElementDecl)elementRef.resolve(false);
        ElementDecl[] elementDeclArray = globalElementDecl.getSubstitutionGroupMembers();
        try {
            if (elementDeclArray != null && elementDeclArray.length > 1) {
                RestrictableGroup restrictableGroup = new RestrictableGroup(elementRef.getOccurs(), 1);
                restrictable = restrictableGroup;
                int n = 0;
                while (n < elementDeclArray.length) {
                    Occurs occurs = (Occurs)((Object)SchemaObjectImpl.getDefaultXMIDocument().newInstance(FactoryImplGen.Occurs_MOFClass));
                    occurs.setMaxOccurs("1");
                    occurs.setMinOccurs("1");
                    restrictableGroup.add(new ElementDeclWrapperParticle(elementDeclArray[n], occurs));
                    ++n;
                }
            } else {
                restrictable = elementDeclArray != null && elementDeclArray.length == 1 ? new ElementDeclWrapperParticle(elementDeclArray[0], elementRef.getOccurs()) : new ElementDeclWrapperParticle(globalElementDecl, elementRef.getOccurs());
            }
        }
        catch (DatatypeFormatException datatypeFormatException) {
            throw new RuntimeException("Implementation Exception : " + datatypeFormatException.getMessage());
        }
        return restrictable;
    }

    private TreeSet createSetOfInt(int[] nArray) {
        TreeSet<Integer> treeSet = new TreeSet<Integer>();
        if (nArray != null) {
            int n = 0;
            while (n < nArray.length) {
                treeSet.add(new Integer(nArray[n]));
                ++n;
            }
        }
        return treeSet;
    }

    public static boolean hasOnlyOneMember(Particle[] particleArray) throws ReferenceResolutionException {
        if (particleArray == null) {
            return false;
        }
        int n = 0;
        int n2 = 0;
        while (n2 < particleArray.length) {
            block9: {
                block10: {
                    block8: {
                        Group group;
                        if (!particleArray[n2].isGroup() && !particleArray[n2].isModelGroupRef()) break block8;
                        Group group2 = group = particleArray[n2].isGroup() ? particleArray[n2].asGroup() : ((ModelGroupDef)particleArray[n2].asModelGroupRef().resolve(false)).getGroup();
                        if (particleArray[n2].getMaxOccurs().trim().equals("0")) break block9;
                        if (!group.isEmpty()) {
                            n = (short)(n + 1);
                        }
                        break block10;
                    }
                    if (particleArray[n2].getMaxOccurs().trim().equals("0")) break block9;
                    n = (short)(n + 1);
                }
                if (n > 1) {
                    return false;
                }
            }
            ++n2;
        }
        return n == 1;
    }

    public boolean isRestrictionOf(ElementRef elementRef, Restrictable restrictable, Vector vector) throws SchemaException {
        Restrictable restrictable2 = this.meanfullRestrictable(restrictable);
        if (restrictable2 == null) {
            return true;
        }
        return this.choiceWithEquivalenceClassMembers(elementRef.asElementRef()).isRestrictionOf(restrictable2, vector);
    }

    public boolean isRestrictionOf(Group group, Restrictable restrictable, Vector vector) throws SchemaException {
        Restrictable restrictable2 = this.meanfullRestrictable(restrictable);
        if (restrictable2 == null) {
            return true;
        }
        Restrictable restrictable3 = this.meanfullRestrictable(group);
        if (restrictable3 == null) {
            return false;
        }
        return restrictable3.isRestrictionOf(restrictable2, vector);
    }

    public boolean isRestrictionOf(LocalElementDecl localElementDecl, Restrictable restrictable, Vector vector) throws SchemaException {
        if ((restrictable = this.meanfullRestrictable(restrictable)) == null) {
            return true;
        }
        if (restrictable instanceof Particle) {
            Particle particle = (Particle)restrictable;
            if (particle.isElementRef()) {
                Restrictable restrictable2 = this.choiceWithEquivalenceClassMembers(particle.asElementRef());
                if (restrictable2 instanceof RestrictableGroup) {
                    return this.isRestrictionOf_Elt_RestrictableGroup(localElementDecl.asElementDecl(), (RestrictableGroup)restrictable2, vector);
                }
                return this.isRestrictionOf_Elt_Elt(localElementDecl.asElementDecl(), (ElementDeclWrapperParticle)restrictable2, vector);
            }
            if (particle.isElementDecl()) {
                return this.isRestrictionOf_Elt_Elt(localElementDecl.asElementDecl(), particle.asElementDecl(), vector);
            }
            if (particle.isWildcard()) {
                return this.isRestrictionOf_Elt_Any(localElementDecl.asElementDecl(), particle.asWildcard(), vector);
            }
            if (particle.isGroup()) {
                return this.isRestrictionOf_Elt_Group(localElementDecl.asElementDecl(), particle.asGroup(), vector);
            }
            if (particle.isModelGroupRef()) {
                return this.isRestrictionOf_Elt_ModelGroupRef(localElementDecl.asElementDecl(), particle.asModelGroupRef(), vector);
            }
            return false;
        }
        if (restrictable instanceof ElementDeclWrapperParticle) {
            return this.isRestrictionOf_Elt_Elt(localElementDecl.asElementDecl(), (ElementDeclWrapperParticle)restrictable, vector);
        }
        if (restrictable instanceof RestrictableGroup) {
            return this.isRestrictionOf_Elt_RestrictableGroup(localElementDecl.asElementDecl(), (RestrictableGroup)restrictable, vector);
        }
        return false;
    }

    public boolean isRestrictionOf(ModelGroupRef modelGroupRef, Restrictable restrictable, Vector vector) throws SchemaException {
        if ((restrictable = this.meanfullRestrictable(restrictable)) == null) {
            return true;
        }
        Restrictable restrictable2 = this.meanfullRestrictable(modelGroupRef);
        if (restrictable2 == null) {
            return false;
        }
        return restrictable2.isRestrictionOf(restrictable, vector);
    }

    public boolean isRestrictionOf(ParticleWildcard particleWildcard, Restrictable restrictable, Vector vector) throws SchemaException {
        Particle particle;
        if ((restrictable = this.meanfullRestrictable(restrictable)) == null) {
            return true;
        }
        if (restrictable instanceof Particle && (particle = (Particle)restrictable).isWildcard()) {
            if (!particleWildcard.getOccurs().isLessThan(particle.getOccurs())) {
                return false;
            }
            ContentModel contentModel = BuiltInDatatypeFactory.getInstance().getAnyType().getComplexTypeSpec().getContentModel();
            ParticleWildcard particleWildcard2 = (ParticleWildcard)((Group)contentModel.getParticle()).listParticle()[0];
            if (!particle.equals(particleWildcard2)) {
                switch (particle.asWildcard().getProcessContents()) {
                    case 0: {
                        if (particleWildcard.getProcessContents() == 0) break;
                        return false;
                    }
                    case 2: {
                        if (particleWildcard.getProcessContents() != 1) break;
                        return false;
                    }
                }
            }
            return particleWildcard.isSubsetOf(particle.asWildcard());
        }
        return false;
    }

    private boolean isRestrictionOf_Elt_Any(LocalElementDecl localElementDecl, ParticleWildcard particleWildcard, Vector vector) throws SchemaException {
        if (!localElementDecl.getOccurs().isLessThan(particleWildcard.getOccurs())) {
            return false;
        }
        return particleWildcard.validate(localElementDecl.getTargetNamespace());
    }

    private boolean isRestrictionOf_Elt_Elt(LocalElementDecl localElementDecl, ElementDeclWrapperParticle elementDeclWrapperParticle, Vector vector) throws SchemaException {
        if (!localElementDecl.getOccurs().isLessThan(elementDeclWrapperParticle.getOccurs())) {
            return false;
        }
        return this.isRestrictionOf_EltDecl_EltDecl(localElementDecl, elementDeclWrapperParticle.getElementDecl(), vector);
    }

    private boolean isRestrictionOf_Elt_Elt(LocalElementDecl localElementDecl, LocalElementDecl localElementDecl2, Vector vector) throws SchemaException {
        if (!localElementDecl.getOccurs().isLessThan(localElementDecl2.getOccurs())) {
            return false;
        }
        return this.isRestrictionOf_EltDecl_EltDecl(localElementDecl, localElementDecl2, vector);
    }

    private boolean isRestrictionOf_Elt_Group(LocalElementDecl localElementDecl, Group group, Vector vector) throws SchemaException {
        return new RestrictableGroup(group.getCompositor(), new Restrictable[]{localElementDecl}).isRestrictionOf(group, vector);
    }

    private boolean isRestrictionOf_Elt_ModelGroupRef(LocalElementDecl localElementDecl, ModelGroupRef modelGroupRef, Vector vector) throws SchemaException {
        ModelGroupDef modelGroupDef = (ModelGroupDef)modelGroupRef.resolve(false);
        Group group = modelGroupDef.getGroup();
        return new RestrictableGroup(group.getCompositor(), new Restrictable[]{localElementDecl}).isRestrictionOf(new RestrictableGroup(modelGroupRef.getOccurs(), group.getCompositor(), group.listParticle()), vector);
    }

    private boolean isRestrictionOf_Elt_RestrictableGroup(LocalElementDecl localElementDecl, RestrictableGroup restrictableGroup, Vector vector) throws SchemaException {
        return new RestrictableGroup(restrictableGroup.getCompositor(), new Restrictable[]{localElementDecl}).isRestrictionOf(restrictableGroup, vector);
    }

    private boolean isRestrictionOf_EltDecl_EltDecl(ElementDecl elementDecl, ElementDecl elementDecl2, Vector vector) throws SchemaException {
        TreeSet treeSet;
        if (elementDecl2.getNCName() == null || !elementDecl2.getNCName().equals(elementDecl.getNCName())) {
            return false;
        }
        URI uRI = elementDecl.getTargetNamespace();
        if (uRI == null ? elementDecl2.getTargetNamespace() != null : !uRI.equals(elementDecl2.getTargetNamespace())) {
            return false;
        }
        if (elementDecl.isNillable() ^ elementDecl2.isNillable()) {
            return false;
        }
        if (!(elementDecl2.getValue() == null || elementDecl2.getValueConstraint() != 2 || elementDecl.getValueConstraint() == 2 && elementDecl2.getValue().equals(elementDecl.getValue()))) {
            return false;
        }
        TreeSet<IdentityConstraint> treeSet2 = new TreeSet<IdentityConstraint>(new IdConstraintComparator());
        TreeSet<IdentityConstraint> treeSet3 = new TreeSet<IdentityConstraint>(new IdConstraintComparator());
        IdentityConstraint[] identityConstraintArray = elementDecl.listIdentityConstraint();
        if (identityConstraintArray != null) {
            treeSet2.addAll(Arrays.asList(identityConstraintArray));
        }
        if ((identityConstraintArray = elementDecl2.listIdentityConstraint()) != null) {
            treeSet3.addAll(Arrays.asList(identityConstraintArray));
        }
        if (!treeSet3.containsAll(treeSet2)) {
            return false;
        }
        TreeSet treeSet4 = this.createSetOfInt(elementDecl.getBlockList());
        if (!treeSet4.containsAll(treeSet = this.createSetOfInt(elementDecl2.getBlockList()))) {
            return false;
        }
        return !(elementDecl.getEffectiveType() == null ? elementDecl2.getEffectiveType() != null && !elementDecl2.getEffectiveType().isUR_Type() : !elementDecl.getEffectiveType().equals(elementDecl2.getEffectiveType()) && !elementDecl.getEffectiveType().isDerivedFromGivenSomeDerivationMethods(elementDecl2.getEffectiveType(), new int[]{1, 2}));
    }

    private boolean isThereAMapping(Restrictable[] restrictableArray, Restrictable[] restrictableArray2, Vector vector) throws SchemaException {
        boolean bl = false;
        int n = 0;
        while (n < restrictableArray.length) {
            if (!restrictableArray[n].getOccurs().getMaxOccurs().trim().equals("0")) {
                int n2 = 0;
                while (n2 < restrictableArray2.length) {
                    if (!restrictableArray2[n2].getOccurs().getMaxOccurs().trim().equals("0")) {
                        if (restrictableArray[n].isRestrictionOf(restrictableArray2[n2], vector)) break;
                        if (n2 == restrictableArray2.length - 1) {
                            return false;
                        }
                    }
                    ++n2;
                }
            }
            ++n;
        }
        return true;
    }

    private boolean isThereAMapping(Restrictable[] restrictableArray, Restrictable[] restrictableArray2, Vector vector, Vector vector2) throws SchemaException {
        boolean bl = false;
        int n = 0;
        while (n < restrictableArray.length) {
            if (!restrictableArray[n].getOccurs().getMaxOccurs().trim().equals("0")) {
                int n2 = 0;
                while (n2 < restrictableArray2.length) {
                    if (!restrictableArray2[n2].getOccurs().getMaxOccurs().trim().equals("0")) {
                        if (restrictableArray[n].isRestrictionOf(restrictableArray2[n2], vector2)) break;
                        if (n2 == restrictableArray2.length - 1) {
                            return false;
                        }
                    }
                    ++n2;
                }
            }
            ++n;
        }
        return true;
    }

    private boolean isThereAn_Seq_All_Mapping(Restrictable[] restrictableArray, Restrictable[] restrictableArray2, Vector vector, Vector vector2) throws SchemaException {
        Vector<Restrictable> vector3 = new Vector<Restrictable>(Arrays.asList(restrictableArray2));
        int n = 0;
        while (n < restrictableArray.length) {
            if (!restrictableArray[n].getOccurs().getMaxOccurs().trim().equals("0")) {
                Enumeration<Restrictable> enumeration = vector3.elements();
                boolean bl = false;
                while (enumeration.hasMoreElements()) {
                    Restrictable restrictable = enumeration.nextElement();
                    if (restrictable.getOccurs().getMaxOccurs().trim().equals("0") || !restrictableArray[n].isRestrictionOf(restrictable, vector2)) continue;
                    vector3.remove(restrictable);
                    bl = true;
                    break;
                }
                if (!bl) {
                    return false;
                }
            }
            ++n;
        }
        vector.addAll(vector3);
        return true;
    }

    private boolean isThereAnOrderPreservingMapping(Restrictable[] restrictableArray, Restrictable[] restrictableArray2, Vector vector, Vector vector2) throws SchemaException {
        int n = 0;
        int n2 = 0;
        while (n2 < restrictableArray.length) {
            if (!restrictableArray[n2].getOccurs().getMaxOccurs().trim().equals("0")) {
                if (n == restrictableArray2.length) {
                    return false;
                }
                int n3 = n;
                while (n3 < restrictableArray2.length) {
                    if (!restrictableArray2[n3].getOccurs().getMaxOccurs().trim().equals("0")) {
                        if (restrictableArray[n2].isRestrictionOf(restrictableArray2[n3], vector2)) {
                            n = n3 + 1;
                            break;
                        }
                        if (vector != null) {
                            vector.add(restrictableArray2[n3]);
                        }
                        if (n3 == restrictableArray2.length - 1) {
                            return false;
                        }
                    }
                    ++n3;
                }
            }
            ++n2;
        }
        return true;
    }

    private Restrictable meanfullRestrictable(Restrictable restrictable) throws ReferenceResolutionException {
        Restrictable[] restrictableArray = this.meanfullRestrictables(null, restrictable);
        if (restrictableArray == null || restrictableArray.length == 0) {
            return null;
        }
        if (restrictableArray.length == 1) {
            return restrictableArray[0];
        }
        if (restrictable instanceof Group) {
            Group group = (Group)restrictable;
            return new RestrictableGroup(group.getOccurs(), group.getCompositor(), restrictableArray);
        }
        System.err.println(restrictable);
        System.err.println(Arrays.asList(restrictableArray));
        throw new RuntimeException("Application Error in RestrictableHelper ");
    }

    private Restrictable[] meanfullRestrictables(Group group, Restrictable restrictable) throws ReferenceResolutionException {
        if (restrictable instanceof Particle) {
            Particle particle = (Particle)restrictable;
            if (particle.getMaxOccurs().trim().equals("0")) {
                return null;
            }
            if (particle.isGroup() || particle.isModelGroupRef()) {
                Group group2 = particle.isGroup() ? particle.asGroup() : ((ModelGroupDef)particle.asModelGroupRef().resolve(false)).getGroup();
                Occurs occurs = particle.getOccurs();
                if (occurs.getMaxOccurs().trim().equals("0")) {
                    return null;
                }
                if (group2.isEmpty()) {
                    if (group2.getCompositor() == 1) {
                        if (group2.getMinOccursAsInt() == 0) {
                            return null;
                        }
                    } else {
                        return null;
                    }
                }
                Particle[] particleArray = group2.listParticle();
                Vector<Restrictable> vector = new Vector<Restrictable>();
                boolean bl = false;
                if (occurs.getMaxOccurs().trim().equals("1") && occurs.getMinOccurs().trim().equals("1") && (RestrictableHelper.hasOnlyOneMember(group2.listParticle()) || group != null && group.getCompositor() == group2.getCompositor())) {
                    bl = true;
                }
                Group group3 = group2;
                if (bl && group != null) {
                    group3 = group;
                }
                int n = 0;
                while (n < particleArray.length) {
                    if (!particleArray[n].getMaxOccurs().trim().equals("0")) {
                        Object object;
                        if (!particleArray[n].isGroup() && !particleArray[n].isModelGroupRef()) {
                            object = this.meanfullRestrictables(group3, particleArray[n]);
                            if (object != null) {
                                vector.addAll(Arrays.asList(object));
                            }
                        } else if (particleArray[n].getMaxOccurs().trim().equals("1") && particleArray[n].getMinOccurs().trim().equals("1")) {
                            Particle[] particleArray2;
                            Object object2 = object = particleArray[n].isGroup() ? particleArray[n].asGroup() : ((ModelGroupDef)particleArray[n].asModelGroupRef().resolve(false)).getGroup();
                            if ((group3.getCompositor() == object.getCompositor() || RestrictableHelper.hasOnlyOneMember(object.listParticle())) && (particleArray2 = object.listParticle()) != null) {
                                int n2 = 0;
                                while (n2 < particleArray2.length) {
                                    Restrictable[] restrictableArray = this.meanfullRestrictables(group3, particleArray2[n2]);
                                    if (restrictableArray != null) {
                                        vector.addAll(Arrays.asList(restrictableArray));
                                    }
                                    ++n2;
                                }
                            }
                        } else {
                            object = this.meanfullRestrictables(group3, particleArray[n]);
                            if (object != null) {
                                vector.addAll(Arrays.asList(object));
                            }
                        }
                    }
                    ++n;
                }
                if (vector.isEmpty()) {
                    return null;
                }
                if (bl) {
                    return vector.toArray(new Restrictable[vector.size()]);
                }
                return new Restrictable[]{new RestrictableGroup(occurs, group2.getCompositor(), vector.toArray(new Restrictable[vector.size()]))};
            }
        }
        return new Restrictable[]{restrictable};
    }

    private class RestrictableGroup
    implements Restrictable {
        public static final String copyright = "Licensed Materials - Property of IBM (C) Copyright IBM Corp. 2000, 2001, 2002    All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
        private Vector restrictables = new Vector();
        private Occurs occurs;
        private int compositor;

        public int getMinEffectiveTotalRange() throws ReferenceResolutionException {
            return GroupImpl.getMinEffectiveTotalRange(this.compositor, this.occurs, this.getRestrictables());
        }

        public String getMaxEffectiveTotalRange() throws ReferenceResolutionException {
            return GroupImpl.getMaxEffectiveTotalRange(this.compositor, this.occurs, this.getRestrictables());
        }

        private Occurs getEffectiveTotalRange() throws ReferenceResolutionException {
            try {
                Occurs occurs = (Occurs)((Object)SchemaObjectImpl.getDefaultXMIDocument().newInstance(FactoryImplGen.Occurs_MOFClass));
                occurs.setMaxOccurs(this.getMaxEffectiveTotalRange());
                occurs.setMinOccurs(Integer.toString(this.getMinEffectiveTotalRange()));
                return occurs;
            }
            catch (DatatypeFormatException datatypeFormatException) {
                throw new RuntimeException("Implementation error : " + datatypeFormatException.getMessage());
            }
        }

        private RestrictableGroup(int n, Restrictable[] restrictableArray) {
            try {
                Occurs occurs = (Occurs)((Object)SchemaObjectImpl.getDefaultXMIDocument().newInstance(FactoryImplGen.Occurs_MOFClass));
                occurs.setMaxOccurs("1");
                occurs.setMinOccurs("1");
                this.occurs = occurs;
                this.compositor = n;
                if (restrictableArray != null) {
                    this.restrictables.addAll(Arrays.asList(restrictableArray));
                }
            }
            catch (DatatypeFormatException datatypeFormatException) {
                datatypeFormatException.printStackTrace(System.err);
            }
        }

        private RestrictableGroup(Occurs occurs, int n) {
            this(occurs, n, (Restrictable[])null);
        }

        private RestrictableGroup(Occurs occurs, int n, Restrictable[] restrictableArray) {
            this.occurs = occurs;
            this.compositor = n;
            if (restrictableArray != null) {
                this.restrictables.addAll(Arrays.asList(restrictableArray));
            }
        }

        private int getCompositor() {
            return this.compositor;
        }

        private void add(Restrictable restrictable) {
            this.restrictables.add(restrictable);
        }

        private void remove(Restrictable restrictable) {
            this.restrictables.remove(restrictable);
        }

        private Restrictable[] getRestrictables() {
            Object[] objectArray = new Restrictable[this.restrictables.size()];
            this.restrictables.copyInto(objectArray);
            return objectArray;
        }

        public Occurs getOccurs() {
            return this.occurs;
        }

        public boolean isRestrictionOf(Restrictable restrictable, Vector vector) throws SchemaException {
            if (restrictable instanceof Particle) {
                Particle particle = (Particle)restrictable;
                if (particle.isElementRef()) {
                    Restrictable restrictable2 = RestrictableHelper.this.choiceWithEquivalenceClassMembers(particle.asElementRef());
                    if (restrictable2 instanceof RestrictableGroup || restrictable2 instanceof ElementDeclWrapperParticle) {
                        return this.isRestrictionOf(restrictable2, vector);
                    }
                    return false;
                }
                if (particle.isElementDecl()) {
                    return this.isRestrictionOf(new RestrictableGroup(this.getCompositor(), new Particle[]{particle.asElementDecl()}), vector);
                }
                if (particle.isWildcard()) {
                    return this.isRestrictionOf(particle.asWildcard(), vector);
                }
                if (particle.isGroup()) {
                    Group group = particle.asGroup();
                    return this.isRestrictionOf(new RestrictableGroup(group.getOccurs(), group.getCompositor(), group.listParticle()), vector);
                }
                if (particle.isModelGroupRef()) {
                    ModelGroupDef modelGroupDef = (ModelGroupDef)particle.asModelGroupRef().resolve(false);
                    Group group = modelGroupDef.getGroup();
                    return this.isRestrictionOf(new RestrictableGroup(particle.asModelGroupRef().getOccurs(), group.getCompositor(), group.listParticle()), vector);
                }
            } else {
                if (restrictable instanceof ElementDeclWrapperParticle) {
                    return this.isRestrictionOf(new RestrictableGroup(this.getCompositor(), new Restrictable[]{(ElementDeclWrapperParticle)restrictable}), vector);
                }
                if (restrictable instanceof RestrictableGroup) {
                    return this.isRestrictionOf((RestrictableGroup)restrictable, vector);
                }
            }
            return false;
        }

        public int size() {
            return this.restrictables.size();
        }

        public boolean isEmptiable(Restrictable restrictable) throws ReferenceResolutionException {
            return restrictable.getMinEffectiveTotalRange() == 0;
        }

        public boolean isRestrictionOf(RestrictableGroup restrictableGroup, Vector vector) throws SchemaException {
            switch (this.compositor) {
                case 0: 
                case 2: {
                    if (restrictableGroup.getCompositor() == this.compositor) {
                        if (!this.getOccurs().isLessThan(restrictableGroup.getOccurs())) {
                            return false;
                        }
                        Vector vector2 = new Vector();
                        if (!RestrictableHelper.this.isThereAnOrderPreservingMapping(this.getRestrictables(), restrictableGroup.getRestrictables(), vector2, vector)) {
                            return false;
                        }
                        int n = 0;
                        while (n < vector2.size()) {
                            if (!this.isEmptiable((Restrictable)vector2.elementAt(n))) {
                                return false;
                            }
                            ++n;
                        }
                        return true;
                    }
                    if (this.compositor != 0) break;
                    if (restrictableGroup.getCompositor() == 1) {
                        Occurs occurs = (Occurs)((Object)SchemaObjectImpl.getDefaultXMIDocument().newInstance(FactoryImplGen.Occurs_MOFClass));
                        occurs.setMinOccurs(Integer.toString(Integer.parseInt(this.occurs.getMinOccurs()) * this.size()));
                        if (this.occurs.getMaxOccurs() == OccursImpl.UNBOUNDED) {
                            occurs.setMaxOccurs(OccursImpl.UNBOUNDED);
                        } else {
                            occurs.setMaxOccurs(Integer.toString(Integer.parseInt(this.occurs.getMaxOccurs()) * this.size()));
                        }
                        if (!occurs.isLessThan(restrictableGroup.getOccurs())) {
                            return false;
                        }
                        return RestrictableHelper.this.isThereAnOrderPreservingMapping(this.getRestrictables(), restrictableGroup.getRestrictables(), null, vector);
                    }
                    if (restrictableGroup.getCompositor() == 2) {
                        if (!this.getOccurs().isLessThan(restrictableGroup.getOccurs())) {
                            return false;
                        }
                        Vector vector3 = new Vector();
                        if (!RestrictableHelper.this.isThereAn_Seq_All_Mapping(this.getRestrictables(), restrictableGroup.getRestrictables(), vector3, vector)) {
                            return false;
                        }
                        int n = 0;
                        while (n < vector3.size()) {
                            if (!this.isEmptiable((Restrictable)vector3.elementAt(n))) {
                                return false;
                            }
                            ++n;
                        }
                        return true;
                    }
                    return false;
                }
                case 1: {
                    if (restrictableGroup.getCompositor() != 1) break;
                    if (!this.getOccurs().isLessThan(restrictableGroup.getOccurs())) {
                        return false;
                    }
                    return RestrictableHelper.this.isThereAnOrderPreservingMapping(this.getRestrictables(), restrictableGroup.getRestrictables(), null, vector);
                }
            }
            return false;
        }

        public boolean isRestrictionOf(ParticleWildcard particleWildcard, Vector vector) throws SchemaException {
            if (!this.getEffectiveTotalRange().isLessThan(particleWildcard.getOccurs())) {
                return false;
            }
            Restrictable[] restrictableArray = this.getRestrictables();
            int n = 0;
            while (n < restrictableArray.length) {
                if (!restrictableArray[n].isRestrictionOf(particleWildcard, vector)) {
                    return false;
                }
                ++n;
            }
            return true;
        }
    }

    private class ElementDeclWrapperParticle
    implements Restrictable {
        public static final String copyright = "Licensed Materials - Property of IBM (C) Copyright IBM Corp. 2000, 2001, 2002    All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
        private ElementDecl eltDecl;
        private Occurs occurs;

        private ElementDeclWrapperParticle(ElementDecl elementDecl, Occurs occurs) {
            this.eltDecl = elementDecl;
            this.occurs = occurs;
        }

        public int getMinEffectiveTotalRange() {
            return Integer.parseInt(this.occurs.getMinOccurs());
        }

        public String getMaxEffectiveTotalRange() {
            return this.occurs.getMaxOccurs();
        }

        public ElementDecl getElementDecl() {
            return this.eltDecl;
        }

        public Occurs getOccurs() {
            return this.occurs;
        }

        public boolean isRestrictionOf(Restrictable restrictable, Vector vector) throws SchemaException {
            if (restrictable instanceof Particle) {
                SchemaComponent schemaComponent;
                Particle particle = (Particle)restrictable;
                if (particle.isElementRef()) {
                    Restrictable restrictable2 = RestrictableHelper.this.choiceWithEquivalenceClassMembers(particle.asElementRef());
                    if (restrictable2 instanceof RestrictableGroup || restrictable2 instanceof ElementDeclWrapperParticle) {
                        return this.isRestrictionOf(restrictable2, vector);
                    }
                    return false;
                }
                if (particle.isElementDecl()) {
                    if (!this.getOccurs().isLessThan(particle.getOccurs())) {
                        return false;
                    }
                    return RestrictableHelper.this.isRestrictionOf_EltDecl_EltDecl(this.getElementDecl(), particle.asElementDecl(), vector);
                }
                if (particle.isWildcard()) {
                    if (!this.getOccurs().isLessThan(particle.asWildcard().getOccurs())) {
                        return false;
                    }
                    return particle.asWildcard().validate(this.getElementDecl().getTargetNamespace());
                }
                if (particle.isGroup()) {
                    schemaComponent = particle.asGroup();
                    if (!this.getOccurs().isLessThan(schemaComponent.getOccurs())) {
                        return false;
                    }
                    new RestrictableGroup(schemaComponent.getCompositor(), new Restrictable[]{this}).isRestrictionOf((Restrictable)((Object)schemaComponent), vector);
                }
                if (particle.isModelGroupRef()) {
                    schemaComponent = (ModelGroupDef)particle.asModelGroupRef().resolve(false);
                    Group group = schemaComponent.getGroup();
                    new RestrictableGroup(group.getCompositor(), new Restrictable[]{this}).isRestrictionOf(new RestrictableGroup(particle.asModelGroupRef().getOccurs(), group.getCompositor(), group.listParticle()), vector);
                }
                return false;
            }
            if (restrictable instanceof ElementDeclWrapperParticle) {
                if (!this.getOccurs().isLessThan(((ElementDeclWrapperParticle)restrictable).getOccurs())) {
                    return false;
                }
                return RestrictableHelper.this.isRestrictionOf_EltDecl_EltDecl(this.getElementDecl(), ((ElementDeclWrapperParticle)restrictable).getElementDecl(), vector);
            }
            if (restrictable instanceof RestrictableGroup) {
                RestrictableGroup restrictableGroup = (RestrictableGroup)restrictable;
                return new RestrictableGroup(restrictableGroup.getCompositor(), new Restrictable[]{this}).isRestrictionOf(restrictableGroup, vector);
            }
            return false;
        }
    }
}

