/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.ecm.schema.impl;

import com.ibm.mof.mof13.extn.impl.MOFAttributeSetting;
import com.ibm.sketch.graph.DefaultTraverseEdgeCondition;
import com.ibm.sketch.graph.DepthFirstTraversal;
import com.ibm.sketch.graph.EdgeEnd;
import com.ibm.sketch.graph.GraphVisitor;
import com.ibm.sketch.graph.Vertex;
import com.ibm.sketch.parser.SchemaTags;
import com.ibm.sketch.util.CollectionWithDuplications;
import com.ibm.sketch.util.LocationComparator;
import com.ibm.sketch.util.TopComponentComparator;
import com.ibm.sketch.util.TopComponentIdentifier;
import com.ibm.sketch.util.URIComparator;
import com.ibm.sketch.viewandvisitor.SchemaObjectVisitor;
import com.ibm.xmi.xmi11temp.IBMXMIDocument;
import com.ibm.xml.ecm.schema.Annotation;
import com.ibm.xml.ecm.schema.BlockElement;
import com.ibm.xml.ecm.schema.CompositionStatement;
import com.ibm.xml.ecm.schema.DependencyException;
import com.ibm.xml.ecm.schema.FinalElement;
import com.ibm.xml.ecm.schema.ImportStatement;
import com.ibm.xml.ecm.schema.IncludeStatement;
import com.ibm.xml.ecm.schema.Info;
import com.ibm.xml.ecm.schema.InvalidValueForBlockException;
import com.ibm.xml.ecm.schema.InvalidValueForFinalException;
import com.ibm.xml.ecm.schema.MalformedURIException;
import com.ibm.xml.ecm.schema.NamespaceDeclaration;
import com.ibm.xml.ecm.schema.PropertyNotFoundException;
import com.ibm.xml.ecm.schema.RedefineStatement;
import com.ibm.xml.ecm.schema.Reference;
import com.ibm.xml.ecm.schema.Schema;
import com.ibm.xml.ecm.schema.SchemaException;
import com.ibm.xml.ecm.schema.SchemaObject;
import com.ibm.xml.ecm.schema.TopComponent;
import com.ibm.xml.ecm.schema.URI;
import com.ibm.xml.ecm.schema.gen.impl.FactoryImplGen;
import com.ibm.xml.ecm.schema.gen.impl.SchemaImplGen;
import com.ibm.xml.ecm.schema.impl.AnnotationImpl;
import com.ibm.xml.ecm.schema.impl.Checker;
import com.ibm.xml.ecm.schema.impl.CheckerManagerImpl;
import com.ibm.xml.ecm.schema.impl.ComplexTypeSpecImpl;
import com.ibm.xml.ecm.schema.impl.CompositionStatementImpl;
import com.ibm.xml.ecm.schema.impl.Debug;
import com.ibm.xml.ecm.schema.impl.FactoryImpl;
import com.ibm.xml.ecm.schema.impl.GlobalElementDeclImpl;
import com.ibm.xml.ecm.schema.impl.IdContraintAndIdConstraintIdentifierComparator;
import com.ibm.xml.ecm.schema.impl.IncludeStatementImpl;
import com.ibm.xml.ecm.schema.impl.NamespaceDeclarationImpl;
import com.ibm.xml.ecm.schema.impl.OpenCloseManagerImpl;
import com.ibm.xml.ecm.schema.impl.ReferenceImpl;
import com.ibm.xml.ecm.schema.impl.SchemaObjectImpl;
import com.ibm.xml.ecm.schema.impl.SchemaVertex;
import com.ibm.xml.ecm.schema.impl.TopComponentImpl;
import com.ibm.xml.ecm.schema.impl.TopComponentImplAndTopComponentIdentifierComparator;
import com.ibm.xml.ecm.schema.impl.URIImpl;
import com.ibm.xml.ecm.schema.impl.VeryFastAlreadyDefinedTopComponent_Checker;
import com.ibm.xml.ecm.schema.impl.VeryFastDuplication_Checker;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.Stack;
import java.util.TreeSet;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SchemaImpl
extends SchemaImplGen
implements Schema,
Vertex {
    public static final String copyright = "Licensed Materials - Property of IBM (C) Copyright IBM Corp. 2000, 2001, 2002    All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String defaultTNS = "http://w3.research.ibm.com/SKETCH/App/DefaultTargetNamespace";
    private static long instanceCreatedCount = 0L;
    private static long instancesCreatedCount = 0L;
    private static boolean DEBUG = false;
    public static final URIImpl defaultTargetNamespace = (URIImpl)FactoryImpl.instance().createURI();
    public static final URIImpl schemaNS = (URIImpl)FactoryImpl.instance().createURI();
    public static final String defaultPrefixForTNS = "122::???--*56%^#^^@##@657090--#$1llbgfviufjbmndfgvab-1ole2313276--85ijshhgbvFDGGVVC:::";
    private boolean targetNamespaceSet = false;
    private OpenCloseManagerImpl openCloseManager = (OpenCloseManagerImpl)FactoryImpl.instance().getOpenCloseManager();
    private Checker[] checkers;
    private Vector childrenOfSchemaElt = new Vector();
    private boolean isAllBlock = false;
    private boolean isAllFinal = false;
    private URI saveAsLocation;
    private Date timestamp = Calendar.getInstance().getTime();
    private CollectionWithDuplications topComponents = new CollectionWithDuplications(new TopComponentImplAndTopComponentIdentifierComparator());
    private String encoding;
    private CollectionWithDuplications IdConstraints = new CollectionWithDuplications(new IdContraintAndIdConstraintIdentifierComparator());
    protected boolean isMergedSchema = false;

    public SchemaImpl() {
        this.ftargetNamespace = defaultTargetNamespace;
        if (SchemaObjectImpl.DEBUG_MEMORY) {
            System.out.println("Number of Schemas created since the beginning\t\t\t = " + ++instancesCreatedCount);
            System.out.println("Number od Schema Objects created since the beginning\t = " + SchemaObjectImpl.nbOfObjectsCreatedSinceTheBeginning);
            Enumeration enumeration = OpenCloseManagerImpl.getInstance().getAllSchemas();
            while (enumeration.hasMoreElements()) {
                System.out.print(enumeration.nextElement() + "    ");
            }
            System.out.println();
            Enumeration enumeration2 = SchemaObjectImpl.numberOfSchemaObjectImplsInMemoryPerClass.elements();
            int n = 0;
            while (enumeration2.hasMoreElements()) {
                n += ((Integer)enumeration2.nextElement()).intValue();
            }
            System.out.println("Number of Schemas in memory \t= " + SchemaObjectImpl.numberOfSchemaObjectImplsInMemoryPerClass.get(this.getClass().toString()));
            System.out.println("Number of Objects in memory \t= " + n);
            System.out.println("% of object destroyed \t\t= " + (100L - (long)(n * 100) / SchemaObjectImpl.nbOfObjectsCreatedSinceTheBeginning));
        }
    }

    boolean isMergedSchema() {
        return this.isMergedSchema;
    }

    public static void merge(Schema schema, Schema schema2) {
        IncludeStatementImpl includeStatementImpl = (IncludeStatementImpl)FactoryImpl.instance().createIncludeStatement();
        includeStatementImpl.setSchemaAfterComposition(schema2);
        includeStatementImpl.setIsMergedLink(true);
        ((SchemaImpl)schema2).isMergedSchema = true;
        schema.addIncludeStatement(includeStatementImpl);
    }

    public void accept(SchemaObjectVisitor schemaObjectVisitor) {
        schemaObjectVisitor.visitSchema(this);
    }

    public void addAnnotation(Annotation annotation) {
        super.addAnnotation(annotation);
        this.childrenOfSchemaElt.add(annotation);
    }

    public void addBlock(int n) {
        if (this.fblock != null) {
            int n2 = 0;
            while (n2 < this.fblock.length) {
                if (this.fblock[n2].getValue() == n) {
                    return;
                }
                ++n2;
            }
        }
        BlockElement blockElement = (BlockElement)((Object)((IBMXMIDocument)this.getXMIDocument()).newInstance(FactoryImplGen.BlockElement_MOFClass));
        blockElement.setValue(n);
        this.addBlock(blockElement);
    }

    public void addBlock(String string) {
        int n = SchemaTags.getBlockSubstitution(string);
        if (n >= 0) {
            this.addBlock(n);
        } else {
            this.getInvalidStateHandler().action(this, new SchemaException[]{new InvalidValueForBlockException(string)});
        }
    }

    public void addFinal(int n) {
        if (this.ffinal != null) {
            int n2 = 0;
            while (n2 < this.ffinal.length) {
                if (this.ffinal[n2].getValue() == n) {
                    return;
                }
                ++n2;
            }
        }
        FinalElement finalElement = (FinalElement)((Object)((IBMXMIDocument)this.getXMIDocument()).newInstance(FactoryImplGen.FinalElement_MOFClass));
        finalElement.setValue(n);
        this.addFinal(finalElement);
    }

    public void addFinal(String string) {
        int n = SchemaTags.getFinal(string);
        if (n >= 0) {
            this.addFinal(n);
        } else {
            this.getInvalidStateHandler().action(this, new SchemaException[]{new InvalidValueForFinalException(string)});
        }
    }

    public void addImportStatement(ImportStatement importStatement) {
        if (this == CompositionStatementImpl.NULLVERTEX) {
            return;
        }
        super.addImportStatement(importStatement);
        this.childrenOfSchemaElt.add(importStatement);
    }

    public void addIncludeLocation(URI uRI) {
        if (this.fincludeStatement != null) {
            int n = 0;
            while (n < this.fincludeStatement.length) {
                if (this.fincludeStatement[n].getLocation().equals(uRI)) {
                    return;
                }
                ++n;
            }
        }
        IncludeStatement includeStatement = (IncludeStatement)((Object)((IBMXMIDocument)this.getXMIDocument()).newInstance(FactoryImplGen.IncludeStatement_MOFClass));
        includeStatement.setLocation(uRI);
        this.addIncludeStatement(includeStatement);
    }

    public void addIncludeStatement(IncludeStatement includeStatement) {
        if (this == CompositionStatementImpl.NULLVERTEX) {
            return;
        }
        super.addIncludeStatement(includeStatement);
        this.childrenOfSchemaElt.add(includeStatement);
    }

    public void addNamespaceDeclaration(Element element) {
        if (this.fnamespaceDecl != null) {
            int n = 0;
            while (n < this.fnamespaceDecl.length) {
                String string = this.fnamespaceDecl[n].getPrefix();
                if (string != defaultPrefixForTNS && this.fnamespaceDecl[n].getTargetNamespace() != defaultTargetNamespace) {
                    URI uRI = this.fnamespaceDecl[n].getTargetNamespace();
                    if (string.equals("")) {
                        if (uRI != null) {
                            element.setAttribute("xmlns", uRI.toString());
                        }
                    } else if (uRI != null) {
                        element.setAttribute("xmlns:" + string, uRI.toString());
                    }
                }
                ++n;
            }
        }
    }

    public void addRedefineLocation(URI uRI) {
        if (this.fredefineStatement != null) {
            int n = 0;
            while (n < this.fredefineStatement.length) {
                if (this.fredefineStatement[n].getLocation().equals(uRI)) {
                    return;
                }
                ++n;
            }
        }
        RedefineStatement redefineStatement = FactoryImpl.instance().createRedefineStatement();
        redefineStatement.setLocation(uRI);
        this.addRedefineStatement(redefineStatement);
    }

    public void addRedefineStatement(RedefineStatement redefineStatement) {
        if (this == CompositionStatementImpl.NULLVERTEX) {
            return;
        }
        super.addRedefineStatement(redefineStatement);
        this.childrenOfSchemaElt.add(redefineStatement);
    }

    public void addTopComponent(TopComponent topComponent) {
        super.addTopComponent(topComponent);
        this.childrenOfSchemaElt.add(topComponent);
        if (DEBUG || Debug.DEBUG) {
            System.out.println("number of TopComponents = " + this.ftopComponent.length);
            System.out.println(" newly added TopComponent =" + topComponent);
        }
    }

    protected void addTopComponent(TopComponent topComponent, int n) {
        this.addValueAt(FactoryImplGen.Schema_topComponent, topComponent, n);
        this.childrenOfSchemaElt.add(n, topComponent);
    }

    protected void addTopComponent(TopComponent topComponent, int n, int n2) {
        this.addValueAt(FactoryImplGen.Schema_topComponent, topComponent, n);
        n2 = n2 < 0 ? this.childrenOfSchemaElt.size() : n2;
        this.childrenOfSchemaElt.add(n2, topComponent);
    }

    public void allBlock() {
        this.addBlock(2);
        this.addBlock(1);
        this.addBlock(0);
        this.addBlock(10);
        this.isAllBlock = true;
    }

    public void allFinal() {
        this.addFinal(2);
        this.addFinal(1);
        this.addFinal(0);
        this.isAllFinal = true;
    }

    public void applied(MOFAttributeSetting mOFAttributeSetting) {
        super.applied(mOFAttributeSetting);
        this.primApplied(mOFAttributeSetting);
    }

    public void applied(MOFAttributeSetting mOFAttributeSetting, int n, MOFAttributeSetting mOFAttributeSetting2) {
        super.applied(mOFAttributeSetting, n, mOFAttributeSetting2);
        this.primApplied(mOFAttributeSetting);
    }

    public void canceled(MOFAttributeSetting mOFAttributeSetting) {
        super.canceled(mOFAttributeSetting);
        this.primCanceled(mOFAttributeSetting);
    }

    public void canceled(MOFAttributeSetting mOFAttributeSetting, int n) {
        super.canceled(mOFAttributeSetting, n);
        this.primCanceled(mOFAttributeSetting);
    }

    public void deleteImportLocation(URI uRI) {
        if (this.fimportStatement != null) {
            Vector vector = new Vector();
            int n = 0;
            while (n < this.fimportStatement.length) {
                if (uRI == null && this.fimportStatement[n].getExplicitTargetNamespace() == null || uRI != null && uRI.equals(this.fimportStatement[n].getExplicitTargetNamespace())) {
                    this.removeImportStatement(this.fimportStatement[n]);
                    return;
                }
                ++n;
            }
        }
    }

    public boolean equals(Object object) {
        return this == object;
    }

    public int[] getBlockList() {
        int[] nArray = null;
        if (this.fblock != null) {
            nArray = new int[this.fblock.length];
            int n = 0;
            while (n < this.fblock.length) {
                nArray[n] = this.fblock[n].getValue();
                ++n;
            }
        }
        return nArray;
    }

    public Checker[] getCheckers() {
        if (this.checkers != null) {
            this.checkers = new Checker[2];
            this.checkers[0] = new VeryFastDuplication_Checker((SchemaObject)this, this.topComponents);
            this.checkers[1] = new VeryFastDuplication_Checker((SchemaObject)this, this.IdConstraints);
        }
        return this.checkers;
    }

    public SchemaObject[] getChildren() {
        return this.childrenOfSchemaElt.toArray(new SchemaObject[this.childrenOfSchemaElt.size()]);
    }

    public Vector getChildrenOfSchemaElt() {
        return this.childrenOfSchemaElt;
    }

    public CollectionWithDuplications getCollectionOfExplicitlyDefinedTopComponents() {
        return this.topComponents;
    }

    public CompositionStatement[] getCompositionStatement() {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        if (this.fincludeStatement != null) {
            n = this.fincludeStatement.length;
        }
        if (this.fimportStatement != null) {
            n2 = this.fimportStatement.length;
        }
        if (this.fredefineStatement != null) {
            n3 = this.fredefineStatement.length;
        }
        CompositionStatement[] compositionStatementArray = new CompositionStatement[n + n2 + n3];
        if (n > 0) {
            System.arraycopy(this.fincludeStatement, 0, compositionStatementArray, 0, this.fincludeStatement.length);
        }
        if (n3 > 0) {
            System.arraycopy(this.fredefineStatement, 0, compositionStatementArray, n, this.fredefineStatement.length);
        }
        if (n2 > 0) {
            System.arraycopy(this.fimportStatement, 0, compositionStatementArray, n + n3, this.fimportStatement.length);
        }
        return compositionStatementArray;
    }

    public static CompositionStatement[] getCompositionStatement(Schema schema, URI uRI, URI uRI2, float f) {
        CompositionStatement[] compositionStatementArray;
        Vector<CompositionStatement> vector = new Vector<CompositionStatement>();
        if (f == 1.0f || f == 2.0f) {
            compositionStatementArray = schema.listIncludeStatement();
            if (compositionStatementArray != null) {
                int n = 0;
                while (n < compositionStatementArray.length) {
                    URI uRI3 = compositionStatementArray[n].getLocation();
                    if (uRI3 != null && uRI3.equals(uRI)) {
                        vector.add(compositionStatementArray[n]);
                    }
                    ++n;
                }
            }
        } else if (f == 3.0f || f == 4.0f) {
            compositionStatementArray = schema.listRedefineStatement();
            if (compositionStatementArray != null) {
                int n = 0;
                while (n < compositionStatementArray.length) {
                    URI uRI4 = compositionStatementArray[n].getLocation();
                    if (uRI4 != null && uRI4.equals(uRI)) {
                        vector.add(compositionStatementArray[n]);
                    }
                    ++n;
                }
            }
        } else if (f == 5.0f && (compositionStatementArray = schema.listImportStatement()) != null) {
            int n = 0;
            while (n < compositionStatementArray.length) {
                URI uRI5;
                URI uRI6 = compositionStatementArray[n].getLocation();
                if (uRI6 != null && uRI6.equals(uRI) && ((uRI5 = compositionStatementArray[n].getExplicitTargetNamespace()) == null && uRI2 == null || uRI5 != null && uRI5.equals(uRI2))) {
                    vector.add(compositionStatementArray[n]);
                }
                ++n;
            }
        }
        if (vector.size() > 0) {
            compositionStatementArray = new CompositionStatement[vector.size()];
            vector.copyInto(compositionStatementArray);
            return compositionStatementArray;
        }
        return null;
    }

    public CompositionStatement[] getCompositionStatementWithSchemaTNS() {
        int n = 0;
        int n2 = 0;
        if (this.fincludeStatement != null) {
            n = this.fincludeStatement.length;
        }
        if (this.fredefineStatement != null) {
            n2 = this.fredefineStatement.length;
        }
        Object var3_3 = null;
        CompositionStatement[] compositionStatementArray = new CompositionStatement[n + n2];
        if (n > 0) {
            System.arraycopy(this.fincludeStatement, 0, compositionStatementArray, 0, this.fincludeStatement.length);
        }
        if (n2 > 0) {
            System.arraycopy(this.fredefineStatement, 0, compositionStatementArray, n, this.fredefineStatement.length);
        }
        return compositionStatementArray;
    }

    public EdgeEnd[] getEdgeEnds() {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        if (this.fincludeStatement != null) {
            n = this.fincludeStatement.length;
        }
        if (this.fimportStatement != null) {
            n2 = this.fimportStatement.length;
        }
        if (this.fredefineStatement != null) {
            n3 = this.fredefineStatement.length;
        }
        EdgeEnd[] edgeEndArray = new EdgeEnd[n + n2 + n3];
        if (n > 0) {
            System.arraycopy(this.fincludeStatement, 0, edgeEndArray, 0, this.fincludeStatement.length);
        }
        if (n3 > 0) {
            System.arraycopy(this.fredefineStatement, 0, edgeEndArray, n, this.fredefineStatement.length);
        }
        if (n2 > 0) {
            System.arraycopy(this.fimportStatement, 0, edgeEndArray, n + n3, this.fimportStatement.length);
        }
        return edgeEndArray;
    }

    public String getEncoding() {
        return this.encoding;
    }

    protected TopComponent getExplicitlyDefinedTopComponent(int n, String string, boolean bl) {
        if (string == null) {
            return null;
        }
        TopComponentImpl topComponentImpl = null;
        if (n == 1 || n == 2) {
            Object[] objectArray = this.topComponents.getElementsIdenticalTo(new TopComponentIdentifier(this.getTargetNamespace(), n, string));
            if (objectArray != null) {
                int n2 = 0;
                while (n2 < objectArray.length) {
                    TopComponentImpl topComponentImpl2 = (TopComponentImpl)objectArray[n2];
                    if (n == topComponentImpl2.getComponentType()) {
                        topComponentImpl = topComponentImpl2;
                        break;
                    }
                    ++n2;
                }
            }
        } else {
            topComponentImpl = (TopComponentImpl)this.topComponents.getFirstElementIdenticalTo(new TopComponentIdentifier(this.getTargetNamespace(), n, string));
        }
        if (topComponentImpl != null && (bl ? topComponentImpl.isRedefined() : !topComponentImpl.isRedefined())) {
            return topComponentImpl;
        }
        return null;
    }

    public URI getExplicitNamespace(String string) {
        NamespaceDeclaration[] namespaceDeclarationArray = this.fnamespaceDecl;
        if (namespaceDeclarationArray == null) {
            return null;
        }
        int n = 0;
        while (n < namespaceDeclarationArray.length) {
            if (namespaceDeclarationArray[n].getPrefix().equals(string)) {
                if (!namespaceDeclarationArray[n].getTargetNamespace().equals(defaultTargetNamespace)) {
                    return namespaceDeclarationArray[n].getTargetNamespace();
                }
                return null;
            }
            ++n;
        }
        return null;
    }

    public String[] getExplicitPrefixes(URI uRI) {
        Object[] objectArray = null;
        NamespaceDeclaration[] namespaceDeclarationArray = this.fnamespaceDecl;
        if (namespaceDeclarationArray == null) {
            return null;
        }
        Vector<String> vector = new Vector<String>();
        int n = 0;
        while (n < namespaceDeclarationArray.length) {
            String string;
            if (namespaceDeclarationArray[n].getTargetNamespace().equals(uRI) && (string = namespaceDeclarationArray[n].getPrefix()) != defaultPrefixForTNS) {
                vector.add(string);
            }
            ++n;
        }
        if (vector.size() > 0) {
            objectArray = new String[vector.size()];
            vector.copyInto(objectArray);
        }
        return objectArray;
    }

    public int[] getFinalList() {
        int[] nArray = null;
        if (this.ffinal != null) {
            nArray = new int[this.ffinal.length];
            int n = 0;
            while (n < this.ffinal.length) {
                nArray[n] = this.ffinal[n].getValue();
                ++n;
            }
        }
        return nArray;
    }

    public CollectionWithDuplications getIdentityConstraints() {
        return this.IdConstraints;
    }

    protected ImportStatement getImportStatement(URI uRI) {
        if (this.fimportStatement != null) {
            int n = 0;
            while (n < this.fimportStatement.length) {
                if (uRI == null && this.fimportStatement[n].getExplicitTargetNamespace() == null || uRI != null && uRI.equals(this.fimportStatement[n].getExplicitTargetNamespace())) {
                    return this.fimportStatement[n];
                }
                ++n;
            }
        }
        return null;
    }

    protected TopComponent getIncludedOrRedefinedTopComponent(Stack stack, int n, String string, boolean bl) {
        TopComponent topComponent = null;
        CompositionStatement[] compositionStatementArray = this.getCompositionStatementWithSchemaTNS();
        if (compositionStatementArray != null) {
            int n2 = 0;
            while (n2 < compositionStatementArray.length) {
                topComponent = ((CompositionStatementImpl)compositionStatementArray[n2]).getTopComponent(stack, n, string, true, bl);
                if (topComponent != null) break;
                ++n2;
            }
        }
        return topComponent;
    }

    public IncludeStatement getIncludeStatement(URI uRI) {
        if (this.fincludeStatement != null) {
            Vector vector = new Vector();
            int n = 0;
            while (n < this.fincludeStatement.length) {
                if (uRI.equals(this.fincludeStatement[n].getLocation())) {
                    return this.fincludeStatement[n];
                }
                ++n;
            }
        }
        return null;
    }

    public Object getObject() {
        return this;
    }

    public RedefineStatement getRedefineStatement(URI uRI) {
        if (this.fredefineStatement != null) {
            Vector vector = new Vector();
            int n = 0;
            while (n < this.fredefineStatement.length) {
                if (uRI.equals(this.fredefineStatement[n].getLocation())) {
                    return this.fredefineStatement[n];
                }
                ++n;
            }
        }
        return null;
    }

    public URI getSaveAsLocation() {
        return this.saveAsLocation;
    }

    public Schema getSchema() {
        return this;
    }

    public String getSchemaXMLNSPrefix() {
        if (this.ftagNamePrefix != null) {
            return this.ftagNamePrefix;
        }
        NamespaceDeclaration[] namespaceDeclarationArray = this.getNamespaceDeclaration(this.getXmlSchemaRef());
        return namespaceDeclarationArray[0].getPrefix();
    }

    public URI getTargetNamespace() {
        if (this.isTargetNamespaceSet()) {
            return super.getTargetNamespace();
        }
        return null;
    }

    URI getTargetNamespaceOrDefaultTargetNamespace() {
        return this.ftargetNamespace;
    }

    public TopComponent getTopComponent(int n, String string) {
        return this.getTopComponent(n, string, true);
    }

    public TopComponent getTopComponent(int n, String string, boolean bl) {
        return this.getTopComponent(new Stack(), n, string, bl, false);
    }

    TopComponent getTopComponent(int n, String string, boolean bl, boolean bl2) {
        return this.getTopComponent(new Stack(), n, string, bl, bl2);
    }

    public TopComponent getTopComponent(Stack stack, int n, String string, boolean bl, boolean bl2) {
        if (stack.contains(this)) {
            return null;
        }
        TopComponent topComponent = this.getExplicitlyDefinedTopComponent(n, string, bl2);
        if (topComponent != null) {
            return topComponent;
        }
        if (bl) {
            stack.push(this);
            topComponent = this.getIncludedOrRedefinedTopComponent(stack, n, string, bl2);
            stack.pop();
        }
        return topComponent;
    }

    public URI getXmlSchemaRef() {
        return schemaNS;
    }

    boolean hasAnnotation(URI uRI, int n) {
        Annotation[] annotationArray = this.listAnnotation();
        if (annotationArray != null) {
            int n2 = 0;
            while (n2 < annotationArray.length) {
                Info[] infoArray;
                if (annotationArray[n2] instanceof AnnotationImpl && (infoArray = ((AnnotationImpl)annotationArray[n2]).getInfo(uRI, n)) != null && infoArray.length > 0) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    public int hashCode() {
        return this.timestamp.hashCode();
    }

    public void insertBefore(TopComponent topComponent, TopComponent topComponent2) throws PropertyNotFoundException {
        if (topComponent2 == null) {
            this.addTopComponent(topComponent);
        } else {
            int n;
            int n2 = -1;
            if (this.ftopComponent != null) {
                n = 0;
                while (n < this.ftopComponent.length) {
                    if (topComponent2 == this.ftopComponent[n]) {
                        n2 = n;
                        break;
                    }
                    ++n;
                }
            }
            if (n2 == -1) {
                throw new PropertyNotFoundException("top component", topComponent2, this);
            }
            n = -1;
            int n3 = 0;
            while (n3 < this.childrenOfSchemaElt.size()) {
                if (topComponent2 == this.childrenOfSchemaElt.get(n3)) {
                    n = n3;
                    break;
                }
                ++n3;
            }
            this.addTopComponent(topComponent, n2, n);
        }
        if (DEBUG || Debug.DEBUG) {
            System.out.println("number of TopComponents = " + this.ftopComponent.length);
            System.out.println(" newly added TopComponent =" + topComponent);
        }
    }

    public boolean isAllBlock() {
        return this.isAllBlock;
    }

    public boolean isAllFinal() {
        return this.isAllFinal;
    }

    public boolean isLocalAttributeDeclQualified() {
        return this.flocalAttributeDeclQualified;
    }

    public boolean isLocalElementDeclQualified() {
        return this.flocalElementDeclQualified;
    }

    protected boolean isTargetNamespaceSet() {
        return this.targetNamespaceSet;
    }

    public TopComponent[] listAllTopComponent(boolean bl) {
        DefaultTraverseEdgeCondition defaultTraverseEdgeCondition = bl ? new DefaultTraverseEdgeCondition() : new DefaultTraverseEdgeCondition(){

            public boolean traverse(Vertex vertex, EdgeEnd edgeEnd, GraphVisitor graphVisitor) {
                float f = edgeEnd.getWeight();
                return f != 5.0f;
            }
        };
        VeryFastAlreadyDefinedTopComponent_Checker.TopComponentCollector topComponentCollector = new VeryFastAlreadyDefinedTopComponent_Checker.TopComponentCollector();
        new DepthFirstTraversal(defaultTraverseEdgeCondition).traverse(new SchemaVertex(this), (GraphVisitor)topComponentCollector);
        CollectionWithDuplications[] collectionWithDuplicationsArray = topComponentCollector.getCollectionsOfTopComponents();
        if (collectionWithDuplicationsArray == null) {
            return null;
        }
        TreeSet<Object> treeSet = new TreeSet<Object>(new TopComponentComparator());
        int n = 0;
        while (n < collectionWithDuplicationsArray.length) {
            Object[] objectArray = collectionWithDuplicationsArray[n].getElementsWithoutDuplications();
            if (objectArray != null) {
                int n2 = 0;
                while (n2 < objectArray.length) {
                    treeSet.add(objectArray[n2]);
                    ++n2;
                }
            }
            ++n;
        }
        if (treeSet.size() > 0) {
            return treeSet.toArray(new TopComponent[treeSet.size()]);
        }
        return null;
    }

    public URI[] listExplicitNamespace() {
        URI[] uRIArray = null;
        NamespaceDeclaration[] namespaceDeclarationArray = this.listNamespaceDecl();
        if (namespaceDeclarationArray == null) {
            return null;
        }
        TreeSet<URI> treeSet = new TreeSet<URI>(new URIComparator());
        int n = 0;
        while (n < namespaceDeclarationArray.length) {
            if (!defaultTargetNamespace.equals(namespaceDeclarationArray[n].getTargetNamespace())) {
                treeSet.add(namespaceDeclarationArray[n].getTargetNamespace());
            } else {
                treeSet.add(null);
            }
            ++n;
        }
        if (treeSet.size() > 0) {
            uRIArray = treeSet.toArray(new URI[treeSet.size()]);
        }
        return uRIArray;
    }

    public String[] listExplicitPrefix() {
        NamespaceDeclaration[] namespaceDeclarationArray = this.fnamespaceDecl;
        if (namespaceDeclarationArray == null) {
            return null;
        }
        TreeSet<String> treeSet = new TreeSet<String>();
        int n = 0;
        while (n < namespaceDeclarationArray.length) {
            if (!namespaceDeclarationArray[n].getTargetNamespace().equals(defaultTargetNamespace)) {
                treeSet.add(namespaceDeclarationArray[n].getPrefix());
            }
            ++n;
        }
        if (treeSet.size() > 0) {
            return treeSet.toArray(new String[treeSet.size()]);
        }
        return null;
    }

    public URI[] listImportedNamespaces() {
        TreeSet<URI> treeSet = new TreeSet<URI>(new URIComparator());
        int n = 0;
        while (this.fimportStatement != null && n < this.fimportStatement.length) {
            treeSet.add(this.fimportStatement[n].getExplicitTargetNamespace());
            ++n;
        }
        if (treeSet.size() > 0) {
            return treeSet.toArray(new URI[treeSet.size()]);
        }
        return null;
    }

    public URI[] listLocation(URI uRI) {
        URI[] uRIArray = null;
        TreeSet<URI> treeSet = new TreeSet<URI>(new LocationComparator());
        if (uRI == this.getTargetNamespace() || uRI != null && uRI.equals(this.getTargetNamespaceOrDefaultTargetNamespace())) {
            int n;
            if (this.fincludeStatement != null) {
                n = 0;
                while (n < this.fincludeStatement.length) {
                    if (this.fincludeStatement[n].getLocation() != null) {
                        treeSet.add(this.fincludeStatement[n].getLocation());
                    }
                    ++n;
                }
            }
            if (this.fredefineStatement != null) {
                n = 0;
                while (n < this.fredefineStatement.length) {
                    if (this.fredefineStatement[n].getLocation() != null) {
                        treeSet.add(this.fredefineStatement[n].getLocation());
                    }
                    ++n;
                }
            }
        } else if (this.fimportStatement != null) {
            int n = 0;
            while (n < this.fimportStatement.length) {
                URI uRI2 = this.fimportStatement[n].getLocation();
                if (uRI2 != null && (uRI != null && uRI.equals(this.fimportStatement[n].getExplicitTargetNamespace()) || uRI == null && this.fimportStatement[n].getExplicitTargetNamespace() == null)) {
                    treeSet.add(uRI2);
                }
                ++n;
            }
        }
        if (treeSet.size() > 0) {
            uRIArray = treeSet.toArray(new URI[treeSet.size()]);
        }
        return uRIArray;
    }

    public TopComponent[] listTopComponent(int n, boolean bl) {
        TopComponent[] topComponentArray = this.listTopComponent(bl);
        if (topComponentArray != null) {
            Vector<TopComponent> vector = new Vector<TopComponent>();
            int n2 = 0;
            while (n2 < topComponentArray.length) {
                if (topComponentArray[n2].getComponentType() == 4) {
                    vector.add(topComponentArray[n2]);
                }
                ++n2;
            }
            if (vector.size() > 0) {
                topComponentArray = vector.toArray(new TopComponent[vector.size()]);
            }
        }
        return topComponentArray;
    }

    public TopComponent[] listTopComponent(boolean bl) {
        if (!bl) {
            return this.listTopComponent();
        }
        Vector<TopComponent> vector = new Vector<TopComponent>();
        if (this.fredefineStatement != null) {
            int n = 0;
            while (n < this.fredefineStatement.length) {
                TopComponent[] topComponentArray = this.fredefineStatement[n].listRedefinedComponent();
                if (topComponentArray != null) {
                    int n2 = 0;
                    while (n2 < topComponentArray.length) {
                        vector.add(topComponentArray[n2]);
                        ++n2;
                    }
                }
                ++n;
            }
        }
        if (this.ftopComponent != null) {
            vector.addAll(Arrays.asList(this.ftopComponent));
        }
        if (vector.size() > 0) {
            Object[] objectArray = new TopComponent[vector.size()];
            vector.copyInto(objectArray);
            return objectArray;
        }
        return null;
    }

    private void primApplied(MOFAttributeSetting mOFAttributeSetting) {
        if (mOFAttributeSetting.getMetaObject() == FactoryImplGen.Schema_targetNamespace) {
            Object object;
            this.targetNamespaceSet = true;
            Exception exception = null;
            if (this.ftargetNamespace != null && this.ftargetNamespace.getValue() != null && (exception = URIImpl.isValidAbsoluteURI(this.ftargetNamespace.getValue())) != null) {
                object = null;
                if (!URIImpl.isValidURI(this.ftargetNamespace.getValue())) {
                    object = new MalformedURIException(this.ftargetNamespace.getValue(), false);
                } else if (!CheckerManagerImpl.getInstance().noWarning(CheckerManagerImpl.NO_WARNING_URI_OMITS_SCHEME)) {
                    object = new MalformedURIException(this.ftargetNamespace.getValue(), true, exception);
                    ((SchemaException)object).setSchemaExceptionType(1);
                }
                if (object != null) {
                    this.getInvalidStateHandler().action(this, new SchemaException[]{object});
                }
            }
            if ((object = this.topComponents.getAllEquivalenceClasses()) != null && ((CollectionWithDuplications.EquivalenceClass[])object).length > 0) {
                this.topComponents.clear();
                int n = 0;
                while (n < ((CollectionWithDuplications.EquivalenceClass[])object).length) {
                    this.topComponents.addEquivalenceClass(object[n]);
                    ++n;
                }
            }
            return;
        }
        if (mOFAttributeSetting.getMetaObject() == FactoryImplGen.Schema_redefineStatement) {
            RedefineStatement redefineStatement = (RedefineStatement)mOFAttributeSetting.getObject();
            redefineStatement.setParent(this);
            TopComponent[] topComponentArray = redefineStatement.listRedefinedComponent();
            if (topComponentArray != null) {
                int n = 0;
                while (n < topComponentArray.length) {
                    this.topComponents.add(topComponentArray[n]);
                    VeryFastAlreadyDefinedTopComponent_Checker veryFastAlreadyDefinedTopComponent_Checker = new VeryFastAlreadyDefinedTopComponent_Checker(this, topComponentArray[n]);
                    if (!this.checkerManager.check(veryFastAlreadyDefinedTopComponent_Checker, true)) {
                        this.handleError(veryFastAlreadyDefinedTopComponent_Checker.getExceptions());
                    }
                    ++n;
                }
            }
            return;
        }
    }

    private void primCanceled(MOFAttributeSetting mOFAttributeSetting) {
        if (mOFAttributeSetting.getMetaObject() == FactoryImplGen.Schema_targetNamespace) {
            this.targetNamespaceSet = false;
            CollectionWithDuplications.EquivalenceClass[] equivalenceClassArray = this.topComponents.getAllEquivalenceClasses();
            if (equivalenceClassArray != null && equivalenceClassArray.length > 0) {
                this.topComponents.clear();
                int n = 0;
                while (n < equivalenceClassArray.length) {
                    this.topComponents.addEquivalenceClass(equivalenceClassArray[n]);
                    ++n;
                }
            }
            return;
        }
        if (mOFAttributeSetting.getMetaObject() == FactoryImplGen.Schema_redefineStatement) {
            RedefineStatement redefineStatement = (RedefineStatement)mOFAttributeSetting.getObject();
            TopComponent[] topComponentArray = redefineStatement.listRedefinedComponent();
            if (topComponentArray != null) {
                int n = 0;
                while (n < topComponentArray.length) {
                    this.topComponents.remove(topComponentArray[n], true);
                    ++n;
                }
            }
            return;
        }
    }

    public void removeAnnotation(Annotation annotation) {
        super.removeAnnotation(annotation);
        this.childrenOfSchemaElt.remove(annotation);
    }

    public void removeImportStatement(ImportStatement importStatement) {
        super.removeImportStatement(importStatement);
        this.childrenOfSchemaElt.remove(importStatement);
    }

    public void removeIncludeLocation(URI uRI) {
        if (this.fincludeStatement != null) {
            Vector<IncludeStatement> vector = new Vector<IncludeStatement>();
            int n = 0;
            while (n < this.fincludeStatement.length) {
                if (uRI.equals(this.fincludeStatement[n].getLocation())) {
                    vector.add(this.fincludeStatement[n]);
                }
                ++n;
            }
            if (vector.size() > 0) {
                int n2 = 0;
                while (n2 < vector.size()) {
                    this.removeIncludeStatement((IncludeStatement)vector.get(n2));
                    ++n2;
                }
            }
        }
    }

    public void removeIncludeStatement(IncludeStatement includeStatement) {
        super.removeIncludeStatement(includeStatement);
        this.childrenOfSchemaElt.remove(includeStatement);
    }

    public void removeNamespace(URI uRI) throws DependencyException {
        NamespaceDeclaration[] namespaceDeclarationArray = this.getExplicitNamespaceDeclaration(uRI);
        if (namespaceDeclarationArray == null) {
            return;
        }
        if (uRI.equals(this.getXmlSchemaRef())) {
            throw new DependencyException(uRI, new Schema[]{this});
        }
        if (uRI.equals(this.getTargetNamespace())) {
            throw new DependencyException(uRI, new Schema[]{this});
        }
        int n = 0;
        while (n < namespaceDeclarationArray.length) {
            if (namespaceDeclarationArray[n].hasMoreReferences()) {
                throw new DependencyException(uRI, namespaceDeclarationArray[n].listReference());
            }
            this.removeNamespaceDecl(namespaceDeclarationArray[n]);
            ++n;
        }
    }

    public void removeRedefineLocation(URI uRI) {
        if (this.fredefineStatement != null) {
            Vector<RedefineStatement> vector = new Vector<RedefineStatement>();
            int n = 0;
            while (n < this.fredefineStatement.length) {
                if (uRI.equals(this.fredefineStatement[n].getLocation())) {
                    vector.add(this.fredefineStatement[n]);
                }
                ++n;
            }
            if (vector.size() > 0) {
                int n2 = 0;
                while (n2 < vector.size()) {
                    this.removeRedefineStatement((RedefineStatement)vector.get(n2));
                    ++n2;
                }
            }
        }
    }

    public void removeRedefineStatement(RedefineStatement redefineStatement) {
        TopComponent[] topComponentArray = redefineStatement.listRedefinedComponent();
        if (topComponentArray != null) {
            int n = 0;
            while (n < topComponentArray.length) {
                this.topComponents.remove(topComponentArray[n], true);
                ++n;
            }
        }
        super.removeRedefineStatement(redefineStatement);
        this.childrenOfSchemaElt.remove(redefineStatement);
    }

    public void removeTopComponent(TopComponent topComponent) {
        this.topComponents.remove(topComponent, true);
        super.removeTopComponent(topComponent);
        if (this.childrenOfSchemaElt != null) {
            this.childrenOfSchemaElt.remove(topComponent);
        }
    }

    public boolean replacePrefix(String string, String string2) {
        Object object;
        if (!this.isTargetNamespaceSet() && (object = this.getNamespaceDeclaration(defaultTargetNamespace)) != null && string2.equals(object[0].getPrefix())) {
            return false;
        }
        object = this.getNamespaceDeclaration(string);
        NamespaceDeclaration namespaceDeclaration = this.getNamespaceDeclaration(string2);
        if (object == null || namespaceDeclaration != null) {
            return false;
        }
        object.setPrefix(string2);
        return true;
    }

    public void setEncoding(String string) {
        this.encoding = string;
    }

    public ImportStatement setImportLocation(URI uRI, URI uRI2) throws PropertyNotFoundException {
        ImportStatement importStatement = (ImportStatement)((Object)((IBMXMIDocument)this.getXMIDocument()).newInstance(FactoryImplGen.ImportStatement_MOFClass));
        importStatement.setExplicitTargetNamespace(uRI);
        if (uRI2 != null) {
            importStatement.setLocation(uRI2);
        }
        this.addImportStatement(importStatement);
        return importStatement;
    }

    public void setSaveAsLocation(URI uRI) {
        this.saveAsLocation = uRI;
    }

    public void setTargetNamespace(URI uRI) {
        this.setTargetNamespace("", uRI);
    }

    public void setTargetNamespace(String string, URI uRI) {
        NamespaceDeclaration[] namespaceDeclarationArray = this.getNamespaceDeclaration(uRI);
        NamespaceDeclaration[] namespaceDeclarationArray2 = this.getNamespaceDeclaration(this.ftargetNamespace);
        if (string == null) {
            string = defaultPrefixForTNS;
        }
        if (namespaceDeclarationArray == null) {
            if (namespaceDeclarationArray2[0].getTargetNamespace().equals(defaultTargetNamespace)) {
                NamespaceDeclaration namespaceDeclaration;
                URI uRI2;
                String string2 = string;
                string = this.findAvailablePrefixFor(string);
                if (string2.equals("") && !string.equals(string2) && (uRI2 = (namespaceDeclaration = this.getNamespaceDeclaration(string2)).getTargetNamespace()) != null && uRI2.equals(defaultTargetNamespace)) {
                    string = string2;
                }
                namespaceDeclarationArray2[0].setPrefix(string);
                namespaceDeclarationArray2[0].setTargetNamespace(uRI);
            } else {
                this.addNamespaceDeclaration(string, uRI);
            }
        } else if (namespaceDeclarationArray2[0].getTargetNamespace().equals(defaultTargetNamespace)) {
            Reference[] referenceArray = namespaceDeclarationArray2[0].listReference();
            if (referenceArray != null) {
                int n = 0;
                while (n < referenceArray.length) {
                    ((ReferenceImpl)referenceArray[n]).setNamespaceDecl(namespaceDeclarationArray[0]);
                    ++n;
                }
            }
            this.removeNamespaceDecl(namespaceDeclarationArray2[0]);
        }
        super.setTargetNamespace(uRI);
    }

    public void setXmlSchemaPrefix(String string) {
        String string2 = string;
        NamespaceDeclaration[] namespaceDeclarationArray = this.getNamespaceDeclaration(schemaNS);
        if (namespaceDeclarationArray != null) {
            NamespaceDeclaration namespaceDeclaration;
            if (!(string = this.findAvailablePrefixFor(string)).equals(string2) && (namespaceDeclaration = this.getNamespaceDeclaration(string2)) != null) {
                if (schemaNS.equals(namespaceDeclaration.getTargetNamespace())) {
                    string = string2;
                } else if (defaultTargetNamespace == namespaceDeclaration.getTargetNamespace()) {
                    namespaceDeclaration.setPrefix(string);
                    string = string2;
                }
            }
            namespaceDeclarationArray[0].setPrefix(string);
        } else {
            URIImpl uRIImpl = (URIImpl)((IBMXMIDocument)this.getXMIDocument()).newInstance(FactoryImplGen.URI_MOFClass);
            uRIImpl.setValue(schemaNS.getValue());
            this.addNamespaceDeclaration(string, uRIImpl);
        }
        this.setTagNamePrefix(string);
    }

    public Schema softClone() {
        int n;
        SchemaImpl schemaImpl = (SchemaImpl)SchemaObjectImpl.getDefaultXMIDocument().newInstance(FactoryImplGen.Schema_MOFClass);
        schemaImpl.ftagNamePrefix = this.ftagNamePrefix;
        schemaImpl.fversion = this.fversion;
        schemaImpl.flocalAttributeDeclQualified = this.flocalAttributeDeclQualified;
        schemaImpl.flocalElementDeclQualified = this.flocalElementDeclQualified;
        schemaImpl.ftargetNamespace = this.ftargetNamespace;
        if (this.fblock != null) {
            n = 0;
            while (n < this.fblock.length) {
                schemaImpl.addBlock(this.fblock[n].getValue());
                ++n;
            }
        }
        if (this.ffinal != null) {
            n = 0;
            while (n < this.ffinal.length) {
                schemaImpl.addFinal(this.ffinal[n].getValue());
                ++n;
            }
        }
        schemaImpl.targetNamespaceSet = this.targetNamespaceSet;
        schemaImpl.isAllBlock = this.isAllBlock;
        schemaImpl.isAllFinal = this.isAllFinal;
        NamespaceDeclaration[] namespaceDeclarationArray = this.listNamespaceDecl();
        if (namespaceDeclarationArray != null) {
            int n2 = 0;
            while (n2 < namespaceDeclarationArray.length) {
                schemaImpl.addNamespaceDecl((NamespaceDeclarationImpl)((NamespaceDeclarationImpl)namespaceDeclarationArray[n2]).clone());
                ++n2;
            }
        }
        return schemaImpl;
    }

    public String toString() {
        return "<schema" + (this.getTargetNamespace() != null ? " targetNamespace=\"" + this.getTargetNamespace() + "\"" : "") + " >";
    }

    public Node toXMLRepresentation(Document document) {
        int n;
        String string = this.getSchemaXMLNSPrefix();
        String string2 = this.getTagNameWithPrefix("schema");
        String string3 = this.getTagNameWithPrefix("import");
        String string4 = this.getTagNameWithPrefix("include");
        Element element = document.createElement(string2);
        URI uRI = this.getTargetNamespace();
        if (uRI != null) {
            element.setAttribute("targetNamespace", uRI.toString());
        }
        this.addNamespaceDeclaration(element);
        if (this.flocalAttributeDeclQualified) {
            element.setAttribute("attributeFormDefault", "qualified");
        } else {
            element.setAttribute("attributeFormDefault", "unqualified");
        }
        if (this.flocalElementDeclQualified) {
            element.setAttribute("elementFormDefault", "qualified");
        } else {
            element.setAttribute("elementFormDefault", "unqualified");
        }
        StringBuffer stringBuffer = new StringBuffer();
        int[] nArray = this.getFinalList();
        if (nArray != null) {
            if (this.isAllFinal) {
                element.setAttribute("finalDefault", "#all");
            } else {
                n = 0;
                while (n < nArray.length) {
                    if (n != 0) {
                        stringBuffer.append(" ");
                    }
                    stringBuffer.append(ComplexTypeSpecImpl.derivationType(nArray[n]));
                    ++n;
                }
                element.setAttribute("finalDefault", stringBuffer.toString());
            }
        }
        nArray = this.getBlockList();
        stringBuffer = new StringBuffer();
        if (nArray != null) {
            if (this.isAllBlock) {
                element.setAttribute("blockDefault", "#all");
            } else {
                n = 0;
                while (n < nArray.length) {
                    if (n != 0) {
                        stringBuffer.append(" ");
                    }
                    stringBuffer.append(GlobalElementDeclImpl.blockType(nArray[n]));
                    ++n;
                }
                element.setAttribute("blockDefault", stringBuffer.toString());
            }
        }
        n = 0;
        while (n < this.childrenOfSchemaElt.size()) {
            Node node = this.toXMLRepresentation(document, this.childrenOfSchemaElt.get(n));
            if (node != null) {
                element.appendChild(node);
            }
            ++n;
        }
        return element;
    }

    private Node toXMLRepresentation(Document document, ImportStatement importStatement) {
        String string = this.getTagNameWithPrefix("import");
        URI uRI = this.getXmlSchemaRef();
        Element element = document.createElement(string);
        if (importStatement.getExplicitTargetNamespace() != null) {
            element.setAttribute("namespace", importStatement.getExplicitTargetNamespace().toString());
        }
        if (importStatement.getLocation() != null) {
            element.setAttribute("schemaLocation", importStatement.getLocation().toString());
        }
        return element;
    }

    private Node toXMLRepresentation(Document document, IncludeStatement includeStatement) {
        if (includeStatement instanceof IncludeStatementImpl && ((IncludeStatementImpl)includeStatement).isVirtual()) {
            return null;
        }
        String string = this.getSchemaXMLNSPrefix();
        String string2 = this.getTagNameWithPrefix("include");
        Element element = document.createElement(string2);
        if (includeStatement.getLocation() != null) {
            element.setAttribute("schemaLocation", includeStatement.getLocation().toString());
        }
        return element;
    }

    private Node toXMLRepresentation(Document document, Object object) {
        if (object instanceof SchemaObject) {
            return ((SchemaObject)object).toXMLRepresentation(document);
        }
        return null;
    }

    public String unparse() {
        return this.toXMLString();
    }

    public boolean hasAnImportStatementWithoutNS() {
        return this.getImportStatement(null) != null;
    }

    static {
        defaultTargetNamespace.setValue(defaultTNS);
        schemaNS.setValue("http://www.w3.org/2001/XMLSchema");
    }
}

