/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.ecm.schema.impl;

import com.ibm.xml.ecm.schema.SchemaException;
import com.ibm.xml.ecm.schema.SchemaObject;
import com.ibm.xml.ecm.schema.State;
import java.util.Vector;

public class StateImpl
implements State {
    public static final String copyright = "Licensed Materials - Property of IBM (C) Copyright IBM Corp. 2000, 2001, 2002    All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private boolean valid = true;
    private SchemaObject schemaObject;
    private Vector exceptions = new Vector();
    private Vector statesOfInvalidChildren = new Vector();

    public StateImpl(SchemaObject schemaObject) {
        this.schemaObject = schemaObject;
    }

    public void addException(SchemaException[] schemaExceptionArray) {
        int n = 0;
        while (n < schemaExceptionArray.length) {
            this.addException(schemaExceptionArray[n]);
            ++n;
        }
    }

    public void addException(SchemaException schemaException) {
        this.exceptions.add(schemaException);
    }

    public void addInvalidChild(State[] stateArray) {
        int n = 0;
        while (n < stateArray.length) {
            this.addInvalidChild(stateArray[n]);
            ++n;
        }
    }

    public void addInvalidChild(State state) {
        this.statesOfInvalidChildren.add(state);
    }

    public SchemaException[] getExceptions() {
        Object[] objectArray = null;
        if (this.exceptions.size() > 0) {
            objectArray = new SchemaException[this.exceptions.size()];
            this.exceptions.copyInto(objectArray);
        }
        return objectArray;
    }

    public State[] getInvalidChildrenStates() {
        Object[] objectArray = null;
        if (this.statesOfInvalidChildren.size() > 0) {
            objectArray = new State[this.statesOfInvalidChildren.size()];
            this.statesOfInvalidChildren.copyInto(objectArray);
        }
        return objectArray;
    }

    public SchemaObject getSchemaObject() {
        return this.schemaObject;
    }

    public boolean isValid() {
        return this.statesOfInvalidChildren.size() == 0 && this.exceptions.size() == 0;
    }

    public void removeInvalidChild(State state) {
        this.statesOfInvalidChildren.remove(state);
    }

    public void setSchemaObject(SchemaObject schemaObject) {
        this.schemaObject = schemaObject;
    }
}

