/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.ecm.schema.impl;

import com.ibm.sketch.util.uri.URI;
import com.ibm.sketch.util.uri.ValidAbsoluteURI;
import com.ibm.xmi.xmi11temp.IBMXMIDocument;
import com.ibm.xml.ecm.schema.DatatypeFormatException;
import com.ibm.xml.ecm.schema.MalformedURIException;
import com.ibm.xml.ecm.schema.URI;
import com.ibm.xml.ecm.schema.gen.impl.FactoryImplGen;
import com.ibm.xml.ecm.schema.gen.impl.URIImplGen;
import com.ibm.xml.ecm.schema.impl.Debug;
import com.ibm.xml.ecm.schema.impl.UriLiteral;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;

public class URIImpl
extends URIImplGen
implements URI {
    public static final String copyright = "Licensed Materials - Property of IBM (C) Copyright IBM Corp. 2000, 2001, 2002    All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private UriLiteral value;
    private ValidAbsoluteURI context;

    public Object clone() {
        IBMXMIDocument iBMXMIDocument = (IBMXMIDocument)this.getXMIDocument();
        URIImpl uRIImpl = (URIImpl)iBMXMIDocument.newInstance(FactoryImplGen.URI_MOFClass);
        uRIImpl.setValue(new String(this.fvalue));
        try {
            if (this.context != null) {
                uRIImpl.context = new ValidAbsoluteURI(this.context.toString());
            }
        }
        catch (URI.MalformedURIException malformedURIException) {
            malformedURIException.printStackTrace();
        }
        return uRIImpl;
    }

    public boolean equals(Object object) {
        if (!(object instanceof URI)) {
            return false;
        }
        try {
            URL uRL = this.getAbsoluteURL();
            URL uRL2 = ((URI)object).getAbsoluteURL();
            return uRL.equals(uRL2) && uRL.getHost().equalsIgnoreCase(uRL2.getHost());
        }
        catch (MalformedURLException malformedURLException) {
            try {
                ValidAbsoluteURI validAbsoluteURI = this.getAbsoluteURI();
                ValidAbsoluteURI validAbsoluteURI2 = ((URI)object).getAbsoluteURI();
                return validAbsoluteURI.equals(validAbsoluteURI2);
            }
            catch (MalformedURIException malformedURIException) {
                String string = ((URI)object).getValue();
                if (this.fvalue == null) {
                    return string == null;
                }
                if (string == null) {
                    return this.fvalue == null;
                }
                String string2 = this.fvalue.trim();
                String string3 = string.trim();
                return string2.equalsIgnoreCase(string3);
            }
        }
    }

    public ValidAbsoluteURI getAbsoluteURI() throws MalformedURIException {
        try {
            return new ValidAbsoluteURI(this.context, this.fvalue);
        }
        catch (URI.MalformedURIException malformedURIException) {
            throw new MalformedURIException(this);
        }
    }

    public URL getAbsoluteURL() throws MalformedURLException {
        String string;
        URL uRL = null;
        if (this.context != null) {
            uRL = new URL(this.context.toString());
        }
        URL uRL2 = this.fvalue != null ? new URL(uRL, this.fvalue.trim()) : new URL(uRL, this.fvalue);
        try {
            string = uRL2.getProtocol().equalsIgnoreCase("file") ? new File(uRL2.getFile()).getCanonicalPath() : uRL2.getFile();
        }
        catch (IOException iOException) {
            if (Debug.DEBUG) {
                iOException.printStackTrace(System.err);
            }
            string = uRL2.getFile();
        }
        string = string.replace(File.separatorChar, '/');
        if (uRL2.getRef() != null) {
            string = string + "#" + uRL2.getRef();
        }
        uRL2 = new URL(uRL2.getProtocol(), uRL2.getHost(), uRL2.getPort(), string);
        return uRL2;
    }

    public ValidAbsoluteURI getContext() {
        return this.context;
    }

    public String getFile() {
        try {
            URL uRL = new URL(this.fvalue);
            return uRL.getFile();
        }
        catch (MalformedURLException malformedURLException) {
            if (Debug.DEBUG) {
                malformedURLException.printStackTrace(System.err);
            }
            return null;
        }
    }

    public int hashCode() {
        if (this.fvalue != null) {
            try {
                return this.getAbsoluteURL().getPath().hashCode();
            }
            catch (MalformedURLException malformedURLException) {
                return this.fvalue.hashCode();
            }
        }
        return 0;
    }

    public static Exception isValidAbsoluteURI(String string) {
        ValidAbsoluteURI validAbsoluteURI = null;
        try {
            validAbsoluteURI = new ValidAbsoluteURI(string);
        }
        catch (URI.MalformedURIException malformedURIException) {
            return malformedURIException;
        }
        return null;
    }

    public static boolean isValidRelativeURI(String string) {
        ValidAbsoluteURI validAbsoluteURI = null;
        try {
            validAbsoluteURI = new ValidAbsoluteURI(string);
            return false;
        }
        catch (URI.MalformedURIException malformedURIException) {
            try {
                new ValidAbsoluteURI(new ValidAbsoluteURI("scheme:"), string);
            }
            catch (URI.MalformedURIException malformedURIException2) {
                return false;
            }
            return true;
        }
    }

    public static boolean isValidURI(String string) {
        try {
            new ValidAbsoluteURI(string);
        }
        catch (URI.MalformedURIException malformedURIException) {
            try {
                new ValidAbsoluteURI(new ValidAbsoluteURI("scheme:"), string);
            }
            catch (URI.MalformedURIException malformedURIException2) {
                return false;
            }
        }
        return true;
    }

    public static void main(String[] stringArray) throws Exception {
        int n = 0;
        while (n < stringArray.length) {
            System.out.println(stringArray[n] + " is a valid URI \t\t : " + URIImpl.isValidURI(stringArray[n]));
            System.out.println(stringArray[n] + " is a valid absolute URI: " + URIImpl.isValidAbsoluteURI(stringArray[n]));
            System.out.println(stringArray[n] + " is a valid relative URI: " + URIImpl.isValidRelativeURI(stringArray[n]));
            ++n;
        }
    }

    public void setContext(ValidAbsoluteURI validAbsoluteURI) {
        this.context = validAbsoluteURI;
    }

    public void setContext(URL uRL) {
        try {
            this.setContext(new ValidAbsoluteURI(uRL.toString()));
        }
        catch (URI.MalformedURIException malformedURIException) {
            throw new RuntimeException("Application fatal error in URI.setContext : " + malformedURIException.getMessage());
        }
    }

    void setValueCA(String string) throws DatatypeFormatException {
        if (this.value == null) {
            this.setValue(string);
        }
    }

    public String toString() {
        String string = this.getValue();
        if (string != null) {
            return string.trim();
        }
        return null;
    }
}

