/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.ecm.schema.impl;

import com.ibm.xml.ecm.schema.AmbiguousContentModelException;
import com.ibm.xml.ecm.schema.ComplexType;
import com.ibm.xml.ecm.schema.Factory;
import com.ibm.xml.ecm.schema.Group;
import com.ibm.xml.ecm.schema.LocalElementDecl;
import com.ibm.xml.ecm.schema.ModelGroupDef;
import com.ibm.xml.ecm.schema.Particle;
import com.ibm.xml.ecm.schema.ReferenceResolutionException;
import com.ibm.xml.ecm.schema.SchemaException;
import com.ibm.xml.ecm.schema.impl.AbstractChecker;
import com.ibm.xml.ecm.schema.impl.CheckType;
import com.ibm.xml.ecm.schema.impl.CircularDefinitionInAGroup_Checker;
import com.ibm.xml.ecm.schema.impl.Debug;
import com.ibm.xml.ecm.schema.impl.FactoryImpl;
import com.ibm.xml.ecm.schema.impl.GroupImpl;
import com.ibm.xml.ecm.schema.impl.OccursImpl;
import java.util.Vector;

public class UnambiguousContentModel_Checker
extends AbstractChecker {
    public static final String copyright = "Licensed Materials - Property of IBM (C) Copyright IBM Corp. 2000, 2001, 2002    All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private SchemaException[] exceptions;
    private ComplexType complextype;
    public static CheckType ID = new CheckType("Unambiguous content model checker");
    static /* synthetic */ Class class$com$ibm$xml$ecm$schema$Particle;

    public UnambiguousContentModel_Checker() {
    }

    public UnambiguousContentModel_Checker(Particle particle) {
        super(particle);
    }

    public UnambiguousContentModel_Checker(Particle particle, ComplexType complexType) {
        super(particle);
        this.complextype = complexType;
    }

    private boolean allGroupCheck(Group group, boolean bl) {
        Particle[] particleArray = group.listParticle();
        this.exceptions = null;
        if (particleArray != null) {
            Vector vector = new Vector();
            UnambiguousContentModel_Checker.getPossibleFirstSimpleParticles(group, vector);
            if (vector.size() > 0) {
                Object[] objectArray = new Particle[vector.size()];
                vector.copyInto(objectArray);
                Particle[] particleArray2 = this.findAPairOfOverlappingParticles((Particle[])objectArray, (Particle[])objectArray);
                if (particleArray2 != null) {
                    this.exceptions = new SchemaException[]{new AmbiguousContentModelException(group, particleArray2, this.complextype)};
                    return false;
                }
            }
        }
        return true;
    }

    public boolean check(boolean bl) {
        Particle particle = (Particle)this.subject;
        if (particle.isGroup() && CircularDefinitionInAGroup_Checker.checkCircularDefinitionException(particle.asGroup()) != null) {
            return true;
        }
        try {
            switch (particle.getParticleType()) {
                case 0: {
                    Group group = particle.asGroup();
                    return this.GroupCheck(group, bl, group.getMinOccurs(), group.getMaxOccurs());
                }
                case 3: {
                    return this.GroupCheck(((ModelGroupDef)particle.asModelGroupRef().resolve(false)).getGroup(), bl, particle.getMinOccurs(), particle.getMaxOccurs());
                }
            }
            return true;
        }
        catch (ReferenceResolutionException referenceResolutionException) {
            if (Debug.DEBUG) {
                referenceResolutionException.printStackTrace(System.err);
            }
            return true;
        }
    }

    private boolean choiceGroupCheck(Group group, boolean bl) {
        return this.choiceGroupCheck(group, bl, group.getMinOccurs(), group.getMaxOccurs());
    }

    private boolean choiceGroupCheck(Group group, boolean bl, String string, String string2) {
        Particle[] particleArray = group.listParticle();
        this.exceptions = null;
        if (particleArray == null) {
            return true;
        }
        Vector vector = new Vector();
        UnambiguousContentModel_Checker.getPossibleFirstSimpleParticles(group, vector);
        if (vector.size() > 0) {
            Object[] objectArray = new Particle[vector.size()];
            vector.copyInto(objectArray);
            Particle[] particleArray2 = this.findAPairOfOverlappingParticles((Particle[])objectArray, (Particle[])objectArray);
            if (particleArray2 != null) {
                this.exceptions = new SchemaException[]{new AmbiguousContentModelException(group, particleArray2, this.complextype)};
                return false;
            }
            if (OccursImpl.UNBOUNDED.equals(string2) || Integer.parseInt(string2) > 1) {
                Vector vector2 = new Vector();
                UnambiguousContentModel_Checker.getLastFrontier(group, vector2);
                Particle[] particleArray3 = this.getPossibleFirstSimpleParticles(vector2);
                if (particleArray3 != null && (particleArray2 = this.findAPairOfOverlappingParticles((Particle[])objectArray, particleArray3)) != null) {
                    this.exceptions = new SchemaException[]{new AmbiguousContentModelException(group, particleArray2, this.complextype)};
                    return false;
                }
            }
        }
        return true;
    }

    private Particle[] findAPairOfOverlappingParticles(Particle[] particleArray, Particle[] particleArray2) {
        if (particleArray == null || particleArray2 == null) {
            return null;
        }
        int n = 0;
        while (n < particleArray.length) {
            int n2 = 0;
            while (n2 < particleArray2.length) {
                block6: {
                    try {
                        if (particleArray[n] != particleArray2[n2] && particleArray[n].overlap(particleArray2[n2])) {
                            Particle[] particleArray3 = new Particle[]{particleArray[n], particleArray2[n2]};
                            return particleArray3;
                        }
                    }
                    catch (SchemaException schemaException) {
                        if (!Debug.DEBUG) break block6;
                        schemaException.printStackTrace(System.err);
                    }
                }
                ++n2;
            }
            ++n;
        }
        return null;
    }

    public CheckType getCheckType() {
        return ID;
    }

    public int getCost() {
        return 10;
    }

    public SchemaException[] getExceptions() {
        return this.exceptions;
    }

    protected static void getLastFrontier(Particle particle, Vector vector) {
        block16: {
            try {
                if (particle.getMaxOccurs().trim().equals("0")) {
                    return;
                }
                block1 : switch (particle.getParticleType()) {
                    case 0: {
                        Group group = particle.asGroup();
                        switch (group.getCompositor()) {
                            case 2: {
                                UnambiguousContentModel_Checker.getLastFrontierForAll(group, vector);
                                break block1;
                            }
                            case 1: {
                                if (!group.getMinOccurs().equals(group.getMaxOccurs())) {
                                    vector.add(group);
                                }
                                UnambiguousContentModel_Checker.getLastFrontierForChoice(group, vector);
                                break block1;
                            }
                            case 0: {
                                if (!group.getMinOccurs().equals(group.getMaxOccurs())) {
                                    vector.add(group);
                                }
                                UnambiguousContentModel_Checker.getLastFrontierForSequence(group, vector);
                            }
                        }
                        break;
                    }
                    case 3: {
                        if (!particle.getMinOccurs().equals(particle.getMaxOccurs())) {
                            vector.add(particle);
                        }
                        Group group = ((ModelGroupDef)particle.asModelGroupRef().resolve(false)).getGroup();
                        UnambiguousContentModel_Checker.getLastFrontier(group, vector);
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 4: {
                        if (particle.getMinOccurs().equals(particle.getMaxOccurs())) break;
                        vector.add(particle);
                    }
                }
            }
            catch (ReferenceResolutionException referenceResolutionException) {
                if (!Debug.DEBUG) break block16;
                referenceResolutionException.printStackTrace(System.err);
            }
        }
    }

    private static void getLastFrontierForAll(Group group, Vector vector) {
    }

    private static void getLastFrontierForChoice(Group group, Vector vector) {
        if (group.getCompositor() != 1) {
            throw new IllegalArgumentException(group + " must  be a choice Group");
        }
        Particle[] particleArray = group.listParticle();
        if (particleArray != null) {
            int n = 0;
            while (n < particleArray.length) {
                UnambiguousContentModel_Checker.getLastFrontier(particleArray[n], vector);
                ++n;
            }
        }
    }

    private static void getLastFrontierForSequence(Group group, Vector vector) {
        if (group.getCompositor() != 0) {
            throw new IllegalArgumentException(group + " must  be a sequence Group");
        }
        Particle[] particleArray = group.listParticle();
        if (particleArray != null) {
            int n = GroupImpl.indexOfLastMandatory(particleArray);
            int n2 = n = n == -1 ? 0 : n;
            while (n2 < particleArray.length) {
                UnambiguousContentModel_Checker.getLastFrontier(particleArray[n2], vector);
                ++n2;
            }
        }
    }

    protected static void getPossibleFirstSimpleParticles(Particle particle, Vector vector) {
        block12: {
            try {
                if (particle.getMaxOccurs().equals("0")) {
                    return;
                }
                block1 : switch (particle.getParticleType()) {
                    case 0: {
                        Group group = particle.asGroup();
                        switch (group.getCompositor()) {
                            case 1: 
                            case 2: {
                                UnambiguousContentModel_Checker.getPossibleFirstSimpleParticlesForAllOrChoice(group, vector);
                                break block1;
                            }
                            case 0: {
                                UnambiguousContentModel_Checker.getPossibleFirstSimpleParticlesForSequence(group, vector);
                            }
                        }
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 4: {
                        vector.add(particle);
                        break;
                    }
                    case 3: {
                        UnambiguousContentModel_Checker.getPossibleFirstSimpleParticles(((ModelGroupDef)particle.asModelGroupRef().resolve(false)).getGroup(), vector);
                    }
                }
            }
            catch (ReferenceResolutionException referenceResolutionException) {
                if (!Debug.DEBUG) break block12;
                referenceResolutionException.printStackTrace(System.err);
            }
        }
    }

    private Particle[] getPossibleFirstSimpleParticles(Vector vector) {
        Vector vector2 = new Vector();
        Vector vector3 = new Vector();
        int n = 0;
        while (n < vector.size()) {
            vector2.clear();
            UnambiguousContentModel_Checker.getPossibleFirstSimpleParticles((Particle)vector.get(n), vector2);
            vector3.addAll(vector2);
            ++n;
        }
        if (vector2.size() > 0) {
            Object[] objectArray = new Particle[vector3.size()];
            vector3.copyInto(objectArray);
            return objectArray;
        }
        return null;
    }

    private static void getPossibleFirstSimpleParticlesForAllOrChoice(Group group, Vector vector) {
        Particle[] particleArray = group.listParticle();
        if (particleArray != null) {
            int n = 0;
            while (n < particleArray.length) {
                UnambiguousContentModel_Checker.getPossibleFirstSimpleParticles(particleArray[n], vector);
                ++n;
            }
        }
    }

    private static void getPossibleFirstSimpleParticlesForSequence(Group group, Vector vector) {
        if (group.getCompositor() != 0) {
            throw new IllegalArgumentException(group + " must  be a sequence Group");
        }
        if (group.getMaxOccurs().equals("0")) {
            return;
        }
        Particle[] particleArray = group.listParticle();
        if (particleArray != null) {
            int n = GroupImpl.indexOfFirstMandatory(particleArray);
            n = n == -1 ? particleArray.length - 1 : n;
            int n2 = 0;
            while (n2 <= n) {
                UnambiguousContentModel_Checker.getPossibleFirstSimpleParticles(particleArray[n2], vector);
                ++n2;
            }
        }
    }

    public Class getSubjectClass() {
        return class$com$ibm$xml$ecm$schema$Particle == null ? (class$com$ibm$xml$ecm$schema$Particle = UnambiguousContentModel_Checker.class$("com.ibm.xml.ecm.schema.Particle")) : class$com$ibm$xml$ecm$schema$Particle;
    }

    private boolean GroupCheck(Group group, boolean bl, String string, String string2) {
        switch (group.getCompositor()) {
            case 2: {
                return this.allGroupCheck(group, bl);
            }
            case 1: {
                return this.choiceGroupCheck(group, bl, string, string2);
            }
            case 0: {
                return this.sequenceGroupCheck(group, bl, string, string2);
            }
        }
        return true;
    }

    private int indexOfNextMandatoryParticle(Particle[] particleArray, int n) {
        int n2 = n + 1;
        while (n2 < particleArray.length) {
            if (particleArray[n2].getMinOccursAsInt() > 0) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public static void main(String[] stringArray) throws Exception {
        Factory factory = FactoryImpl.instance();
        Group group = factory.createGroup();
        group.setCompositor(0);
        Group group2 = factory.createGroup();
        group2.setCompositor(1);
        group.addParticle(group2);
        LocalElementDecl localElementDecl = factory.createLocalElementDecl();
        localElementDecl.setNCName("a");
        group2.addParticle(localElementDecl);
        localElementDecl = factory.createLocalElementDecl();
        localElementDecl.setNCName("b");
        localElementDecl.setMaxOccurs("4");
        localElementDecl.setMinOccurs("0");
        group2.addParticle(localElementDecl);
        Group group3 = factory.createGroup();
        group3.setCompositor(1);
        group3.setMaxOccurs("1");
        group.addParticle(group3);
        localElementDecl = factory.createLocalElementDecl();
        localElementDecl.setNCName("a");
        group3.addParticle(localElementDecl);
        localElementDecl = factory.createLocalElementDecl();
        localElementDecl.setNCName("c");
        localElementDecl.setMaxOccurs("4");
        localElementDecl.setMinOccurs("0");
        group3.addParticle(localElementDecl);
        UnambiguousContentModel_Checker unambiguousContentModel_Checker = new UnambiguousContentModel_Checker(group);
        unambiguousContentModel_Checker.check(false);
        System.out.println("Group = " + group.toXMLString());
        if (unambiguousContentModel_Checker.getExceptions() != null && unambiguousContentModel_Checker.getExceptions().length > 0) {
            throw unambiguousContentModel_Checker.getExceptions()[0];
        }
    }

    private boolean sequenceGroupCheck(Group group, boolean bl) {
        return this.sequenceGroupCheck(group, bl, group.getMinOccurs(), group.getMaxOccurs());
    }

    private boolean sequenceGroupCheck(Group group, boolean bl, String string, String string2) {
        Particle[] particleArray = group.listParticle();
        this.exceptions = null;
        if (particleArray == null) {
            return true;
        }
        if (OccursImpl.UNBOUNDED.equals(string2) || Integer.parseInt(string2) > 1) {
            Particle[] particleArray2 = particleArray;
            particleArray = new Particle[particleArray2.length + 1];
            System.arraycopy(particleArray2, 0, particleArray, 0, particleArray2.length);
            particleArray[particleArray2.length] = group;
        }
        int n = 0;
        while (n < particleArray.length) {
            Vector vector = new Vector();
            UnambiguousContentModel_Checker.getLastFrontier(particleArray[n], vector);
            Vector vector2 = new Vector();
            Particle[] particleArray3 = this.getPossibleFirstSimpleParticles(vector);
            if (particleArray3 != null) {
                int n2 = this.indexOfNextMandatoryParticle(particleArray, n);
                n2 = n2 != -1 ? n2 : particleArray.length - 1;
                int n3 = n + 1;
                while (n3 <= n2) {
                    if (OccursImpl.UNBOUNDED.equals(particleArray[n3].getMaxOccurs()) || Integer.parseInt(particleArray[n3].getMaxOccurs()) > 0) {
                        vector2.clear();
                        UnambiguousContentModel_Checker.getPossibleFirstSimpleParticles(particleArray[n3], vector2);
                        Object[] objectArray = new Particle[vector2.size()];
                        vector2.copyInto(objectArray);
                        Particle[] particleArray4 = this.findAPairOfOverlappingParticles(particleArray3, (Particle[])objectArray);
                        if (particleArray4 != null) {
                            this.exceptions = new SchemaException[]{new AmbiguousContentModelException(group, particleArray4, this.complextype)};
                            return false;
                        }
                    }
                    ++n3;
                }
            }
            ++n;
        }
        return true;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        CheckType.register(ID);
    }
}

