/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.ecm.schema.impl;

import com.ibm.xml.ecm.schema.DatatypeFormatException;
import com.ibm.xml.ecm.schema.URI;
import com.ibm.xml.ecm.schema.gen.impl.FactoryImplGen;
import com.ibm.xml.ecm.schema.impl.BuiltInDatatypeFactory;
import com.ibm.xml.ecm.schema.impl.Debug;
import com.ibm.xml.ecm.schema.impl.LiteralValueImpl;
import com.ibm.xml.ecm.schema.impl.SchemaObjectImpl;
import com.ibm.xml.ecm.schema.impl.URIImpl;

public class UriLiteral
extends LiteralValueImpl {
    public static final String copyright = "Licensed Materials - Property of IBM (C) Copyright IBM Corp. 2000, 2001, 2002    All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected String valueAsString;
    protected URI value;

    private UriLiteral() {
    }

    public UriLiteral(String string) throws DatatypeFormatException {
        super(string);
    }

    public Object clone() {
        try {
            return new UriLiteral(this.value.toString());
        }
        catch (DatatypeFormatException datatypeFormatException) {
            if (Debug.DEBUG) {
                datatypeFormatException.printStackTrace(System.err);
            }
            return null;
        }
    }

    protected void conversion(String string) throws DatatypeFormatException {
        this.valueAsString = string;
        if (!URIImpl.isValidURI(string)) {
            throw new DatatypeFormatException(BuiltInDatatypeFactory.getInstance().getBuiltInDatatype("anyURI"), string);
        }
        this.value = (URI)((Object)SchemaObjectImpl.getDefaultXMIDocument().newInstance(FactoryImplGen.URI_MOFClass));
        this.value.setValue(string);
    }

    public boolean equals(Object object) {
        if (object instanceof UriLiteral) {
            return this.value.equals(((UriLiteral)object).value);
        }
        return false;
    }

    public Object getValue() {
        return this.value;
    }

    public boolean inOrder(Object object) {
        return this.equals(object);
    }

    public boolean isTotallyOrdered() {
        return false;
    }

    public String toString() {
        return this.valueAsString;
    }
}

