/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.ecm.schema.impl;

import com.ibm.sketch.util.CollectionWithDuplications;
import com.ibm.xml.ecm.schema.ComponentDefinedMoreThanOnceException;
import com.ibm.xml.ecm.schema.OpenCloseManager;
import com.ibm.xml.ecm.schema.SchemaObject;
import com.ibm.xml.ecm.schema.impl.Duplication_Checker;
import com.ibm.xml.ecm.schema.impl.OpenCloseManagerImpl;

public class VeryFastDuplication_Checker
extends Duplication_Checker {
    public static final String copyright = "Licensed Materials - Property of IBM (C) Copyright IBM Corp. 2000, 2001, 2002    All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private CollectionWithDuplications collection;

    public VeryFastDuplication_Checker() {
    }

    public VeryFastDuplication_Checker(SchemaObject schemaObject, CollectionWithDuplications collectionWithDuplications) {
        this.setSubject(schemaObject);
        this.collection = collectionWithDuplications;
    }

    public boolean check(boolean bl) {
        this.exceptions.clear();
        OpenCloseManager openCloseManager = OpenCloseManagerImpl.getInstance();
        if (((OpenCloseManagerImpl)openCloseManager).isDisableDuplicationChecker()) {
            return true;
        }
        Object[][] objectArray = this.collection.getDuplications();
        if (objectArray != null && objectArray.length > 0) {
            int n = 0;
            while (n < objectArray.length) {
                this.exceptions.addElement(new ComponentDefinedMoreThanOnceException((SchemaObject)this.subject, objectArray[n]));
                ++n;
            }
            return false;
        }
        return true;
    }

    public int getCost() {
        return 4;
    }
}

