/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.ecm.schema.impl;

import com.ibm.xml.ecm.schema.DatatypeFormatException;
import com.ibm.xml.ecm.schema.Facet;
import com.ibm.xml.ecm.schema.InvalidStateException;
import com.ibm.xml.ecm.schema.InvalidValueForWhiteSpaceFacet;
import com.ibm.xml.ecm.schema.SchemaException;
import com.ibm.xml.ecm.schema.SimpleType;
import com.ibm.xml.ecm.schema.Type;
import com.ibm.xml.ecm.schema.impl.CheckerManagerImpl;
import com.ibm.xml.ecm.schema.impl.Debug;
import com.ibm.xml.ecm.schema.impl.FacetImpl;
import com.ibm.xml.ecm.schema.impl.FacetStrategy;
import java.util.Vector;

public class WhiteSpaceFacetStrategy
extends FacetStrategy {
    public static final String copyright = "Licensed Materials - Property of IBM (C) Copyright IBM Corp. 2000, 2001, 2002    All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    SchemaException[] compatibleWithOtherFacet(Type type, Facet facet, Facet facet2, boolean bl) {
        SchemaException[] schemaExceptionArray = null;
        if (schemaExceptionArray != null) {
            return schemaExceptionArray;
        }
        return null;
    }

    Object convertToAppropriatedObject(String[] stringArray) throws DatatypeFormatException {
        if (stringArray[0].equals("preserve") || stringArray[0].equals("replace") || stringArray[0].equals("collapse")) {
            return stringArray[0];
        }
        throw new InvalidValueForWhiteSpaceFacet(stringArray[0]);
    }

    protected String getValue(Facet facet) throws ClassCastException, DatatypeFormatException, InvalidStateException {
        String string = null;
        if (facet instanceof FacetImpl) {
            string = (String)((FacetImpl)facet).getValueAsObject();
        }
        if (string == null) {
            string = (String)this.convertToAppropriatedObject(facet.getValuesAsString());
        }
        return string;
    }

    boolean inOrder(Facet facet, Facet facet2) {
        if (facet == null || facet2 == null) {
            return false;
        }
        try {
            String string = this.getValue(facet);
            String string2 = this.getValue(facet2);
            return this.inOrder(string, string2);
        }
        catch (InvalidStateException invalidStateException) {
            if (Debug.DEBUG) {
                invalidStateException.printStackTrace();
            }
            return false;
        }
        catch (DatatypeFormatException datatypeFormatException) {
            if (Debug.DEBUG) {
                datatypeFormatException.printStackTrace();
            }
            return false;
        }
        catch (ClassCastException classCastException) {
            if (Debug.DEBUG) {
                classCastException.printStackTrace();
            }
            return false;
        }
    }

    boolean inOrder(String string, String string2) {
        if (string2 == null || string == null) {
            return false;
        }
        if (string2.equals("preserve") && (string.equals("replace") || string.equals("collapse") || string.equals("preserve"))) {
            return true;
        }
        if (string2.equals("replace") && (string.equals("replace") || string.equals("collapse"))) {
            return true;
        }
        return string2.equals("collapse") && string.equals("collapse");
    }

    boolean isEqual(Facet facet, Facet facet2) {
        try {
            return this.getValue(facet).equals(this.getValue(facet2));
        }
        catch (DatatypeFormatException datatypeFormatException) {
            if (Debug.DEBUG) {
                datatypeFormatException.printStackTrace(System.err);
            }
            return false;
        }
        catch (InvalidStateException invalidStateException) {
            if (Debug.DEBUG) {
                invalidStateException.printStackTrace(System.err);
            }
            return false;
        }
    }

    public static void main(String[] stringArray) {
        System.out.println(new String("\n\t\r ").replace('\n', 'p'));
    }

    public static String normalize(String string, SimpleType simpleType) {
        Facet facet;
        if (simpleType == null) {
            return string;
        }
        CheckerManagerImpl checkerManagerImpl = CheckerManagerImpl.getInstance();
        int n = checkerManagerImpl.getMaxCost();
        checkerManagerImpl.setMaxCost(-1);
        try {
            try {
                facet = simpleType.getFacet(12);
            }
            catch (SchemaException schemaException) {
                facet = simpleType.getFacetDefinedHere(12);
                Object var7_6 = null;
                checkerManagerImpl.setMaxCost(n);
            }
            Object var7_5 = null;
            checkerManagerImpl.setMaxCost(n);
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            checkerManagerImpl.setMaxCost(n);
            throw throwable;
        }
        if (facet == null || facet.getValuesAsString() == null || facet.getValuesAsString().length == 0) {
            return string;
        }
        return WhiteSpaceFacetStrategy.normalize(string, facet.getValuesAsString()[0]);
    }

    public static String normalize(String string, String string2) {
        if (string2 == null) {
            return string;
        }
        if (string2.equals("preserve")) {
            return string;
        }
        char[] cArray = string.toCharArray();
        if (string2.equals("replace")) {
            if (cArray != null) {
                int n = 0;
                while (n < cArray.length) {
                    if (cArray[n] == '\t' || cArray[n] == '\n' || cArray[n] == '\r') {
                        cArray[n] = 32;
                    }
                    ++n;
                }
                return new String(cArray);
            }
            return string;
        }
        if (string2.equals("collapse")) {
            Vector<Character> vector = new Vector<Character>();
            boolean bl = true;
            if (cArray != null) {
                int n = 0;
                while (n < cArray.length) {
                    if (cArray[n] == '\t' || cArray[n] == '\n' || cArray[n] == '\r' || cArray[n] == ' ') {
                        if (!bl) {
                            vector.add(new Character(' '));
                            bl = true;
                        }
                    } else {
                        vector.add(new Character(cArray[n]));
                        bl = false;
                    }
                    ++n;
                }
                if (vector.size() > 0 && vector.get(vector.size() - 1).equals(new Character(' '))) {
                    vector.remove(vector.size() - 1);
                }
                char[] cArray2 = new char[vector.size()];
                int n2 = 0;
                while (n2 < vector.size()) {
                    cArray2[n2] = ((Character)vector.get(n2)).charValue();
                    ++n2;
                }
                return new String(cArray2);
            }
            return string;
        }
        return string;
    }

    boolean validate(Facet facet, String string) {
        try {
            if (facet != null && facet instanceof FacetImpl && ((FacetImpl)facet).getFacetStrategy() != null && ((FacetImpl)facet).getFacetStrategy() instanceof WhiteSpaceFacetStrategy) {
                String string2 = this.getValue(facet);
                if (string2 == null) {
                    return false;
                }
                if (string == null || string.length() == 0) {
                    return true;
                }
                if ((string2.equals("replace") || string2.equals("collapse")) && (string.indexOf("\t") != -1 || string.indexOf("\n") != -1 || string.indexOf("\r") != -1)) {
                    return false;
                }
                return !string2.equals("collapse") || string.indexOf("  ") == -1 && string.charAt(0) != ' ' && string.charAt(string.length() - 1) != ' ';
            }
            return false;
        }
        catch (DatatypeFormatException datatypeFormatException) {
            if (Debug.DEBUG) {
                datatypeFormatException.printStackTrace();
            }
            return false;
        }
        catch (NullPointerException nullPointerException) {
            if (Debug.DEBUG) {
                nullPointerException.printStackTrace();
            }
            return false;
        }
        catch (InvalidStateException invalidStateException) {
            if (Debug.DEBUG) {
                invalidStateException.printStackTrace();
            }
            return false;
        }
        catch (ClassCastException classCastException) {
            if (Debug.DEBUG) {
                classCastException.printStackTrace();
            }
            return false;
        }
    }
}

