/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.ecm.schema.impl;

import com.ibm.sketch.util.URIComparator;
import com.ibm.xml.ecm.schema.Schema;
import com.ibm.xml.ecm.schema.URI;
import com.ibm.xml.ecm.schema.Wildcard;
import com.ibm.xml.ecm.schema.gen.impl.FactoryImplGen;
import com.ibm.xml.ecm.schema.gen.impl.WildcardImplGen;
import com.ibm.xml.ecm.schema.impl.SchemaObjectImpl;
import java.util.Arrays;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.Vector;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class WildcardImpl
extends WildcardImplGen
implements Wildcard {
    private URI targetNamespace;

    public WildcardImpl() {
        this.fprocessContents = -1;
    }

    public static Wildcard convertIntoCanonicalWildcard(Wildcard wildcard) {
        int n = wildcard.getType();
        switch (n) {
            case 1: 
            case 4: {
                Wildcard wildcard2 = (Wildcard)((Object)SchemaObjectImpl.getDefaultXMIDocument().newInstance(FactoryImplGen.Wildcard_MOFClass));
                wildcard2.setType(WildcardImpl.getCanonicalType(n));
                TreeSet treeSet = WildcardImpl.getNamespaces(wildcard);
                if (treeSet != null) {
                    Iterator iterator = treeSet.iterator();
                    while (iterator.hasNext()) {
                        URI uRI = (URI)iterator.next();
                        wildcard2.addNamespace(uRI);
                    }
                }
                return wildcard2;
            }
        }
        return wildcard;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Wildcard)) {
            return false;
        }
        Wildcard wildcard = (Wildcard)object;
        int n = WildcardImpl.getCanonicalType(this.ftype);
        if (n != WildcardImpl.getCanonicalType(wildcard.getType())) {
            return false;
        }
        if (this.getProcessContents() != wildcard.getProcessContents()) {
            return false;
        }
        if (n == 0) {
            return true;
        }
        return WildcardImpl.getNamespaces(this).equals(WildcardImpl.getNamespaces(wildcard));
    }

    public static int getCanonicalType(int n) {
        switch (n) {
            case 1: {
                return 2;
            }
            case 4: {
                return 3;
            }
        }
        return n;
    }

    public static int getIntersection(Wildcard[] wildcardArray, Vector vector) {
        if (wildcardArray.length == 1) {
            vector.addAll(Arrays.asList(wildcardArray[0].listNamespace()));
            return wildcardArray[0].getType();
        }
        vector.clear();
        int n = wildcardArray[0].intersection(wildcardArray[1], vector);
        if (n == -1) {
            return -1;
        }
        if (wildcardArray.length > 2) {
            Wildcard wildcard = (Wildcard)((Object)SchemaObjectImpl.getDefaultXMIDocument().newInstance(FactoryImplGen.Wildcard_MOFClass));
            wildcard.setType(n);
            int n2 = 0;
            while (n2 < vector.size()) {
                wildcard.addNamespace((URI)vector.get(n2));
                ++n2;
            }
            vector.clear();
            Wildcard[] wildcardArray2 = new Wildcard[wildcardArray.length - 1];
            wildcardArray2[0] = wildcard;
            System.arraycopy(wildcardArray, 2, wildcardArray2, 1, wildcardArray.length - 2);
            return WildcardImpl.getIntersection(wildcardArray2, vector);
        }
        return n;
    }

    private static TreeSet getNamespaces(Wildcard wildcard) {
        TreeSet<URI> treeSet = new TreeSet<URI>(new URIComparator());
        URI[] uRIArray = wildcard.listNamespace();
        treeSet.addAll(Arrays.asList(uRIArray));
        if (wildcard.getType() == 4 || wildcard.getType() == 1) {
            treeSet.add(wildcard.getTargetNamespace());
        }
        if (WildcardImpl.getCanonicalType(wildcard.getType()) == 2 && treeSet.size() > 0 && !treeSet.contains(null)) {
            treeSet.add(null);
        }
        return treeSet;
    }

    public int getSchemaComponentType() {
        return 123;
    }

    public URI getTargetNamespace() {
        if (this.targetNamespace != null) {
            return this.targetNamespace;
        }
        Schema schema = this.getSchema();
        if (schema != null) {
            return schema.getTargetNamespace();
        }
        return null;
    }

    public int getType() {
        return this.ftype;
    }

    public static int getUnion(Wildcard[] wildcardArray, Vector vector) {
        if (wildcardArray.length == 1) {
            vector.addAll(Arrays.asList(wildcardArray[0].listNamespace()));
            return wildcardArray[0].getType();
        }
        vector.clear();
        int n = wildcardArray[0].union(wildcardArray[1], vector);
        if (n == -1) {
            return -1;
        }
        if (wildcardArray.length > 2) {
            Wildcard wildcard = (Wildcard)((Object)SchemaObjectImpl.getDefaultXMIDocument().newInstance(FactoryImplGen.Wildcard_MOFClass));
            wildcard.setType(n);
            int n2 = 0;
            while (n2 < vector.size()) {
                wildcard.addNamespace((URI)vector.get(n2));
                ++n2;
            }
            vector.clear();
            Wildcard[] wildcardArray2 = new Wildcard[wildcardArray.length - 1];
            wildcardArray2[0] = wildcard;
            System.arraycopy(wildcardArray, 2, wildcardArray2, 1, wildcardArray.length - 2);
            return WildcardImpl.getUnion(wildcardArray2, vector);
        }
        return n;
    }

    public int intersection(Wildcard[] wildcardArray, Vector vector) {
        Wildcard[] wildcardArray2 = new Wildcard[wildcardArray.length + 1];
        wildcardArray2[0] = this;
        System.arraycopy(wildcardArray, 0, wildcardArray2, 1, wildcardArray.length);
        return WildcardImpl.getIntersection(wildcardArray2, vector);
    }

    public int intersection(Wildcard wildcard, Vector vector) {
        TreeSet treeSet = WildcardImpl.getNamespaces(this);
        TreeSet treeSet2 = WildcardImpl.getNamespaces(wildcard);
        int n = WildcardImpl.getCanonicalType(this.ftype);
        int n2 = WildcardImpl.getCanonicalType(wildcard.getType());
        if (n == 0) {
            if (vector != null) {
                vector.addAll(treeSet2);
            }
            return n2;
        }
        if (wildcard.getType() == 0) {
            if (vector != null) {
                vector.addAll(treeSet);
            }
            return n;
        }
        if (n == n2 && treeSet.equals(treeSet2)) {
            if (vector != null) {
                vector.addAll(treeSet);
            }
            return n;
        }
        if (n == 2 && n2 == 3) {
            if (vector != null) {
                TreeSet treeSet3 = (TreeSet)treeSet2.clone();
                treeSet3.removeAll(treeSet);
                vector.addAll(treeSet3);
            }
            return 3;
        }
        if (n2 == 2 && n == 3) {
            return wildcard.intersection(this, vector);
        }
        if (n == 3 && n2 == 3) {
            if (vector != null) {
                TreeSet treeSet4 = (TreeSet)treeSet.clone();
                treeSet4.retainAll(treeSet2);
                vector.addAll(treeSet4);
            }
            return 3;
        }
        if (n == 2 && n2 == 2) {
            if (treeSet.size() == 1 && treeSet.contains(null)) {
                if (vector != null) {
                    vector.addAll(treeSet2);
                }
                return n2;
            }
            if (treeSet2.size() == 1 && treeSet2.contains(null)) {
                if (vector != null) {
                    vector.addAll(treeSet);
                }
                return n;
            }
        }
        return -1;
    }

    public boolean isSubsetOf(Wildcard wildcard) {
        if (wildcard.getType() == 0) {
            return true;
        }
        TreeSet treeSet = WildcardImpl.getNamespaces(this);
        int n = WildcardImpl.getCanonicalType(this.ftype);
        TreeSet treeSet2 = WildcardImpl.getNamespaces(wildcard);
        int n2 = WildcardImpl.getCanonicalType(wildcard.getType());
        if (n == 2 && n2 == 2) {
            return treeSet.containsAll(treeSet2);
        }
        if (n == 3) {
            if (n2 == 3) {
                return treeSet2.containsAll(treeSet);
            }
            if (n2 == 2) {
                treeSet2.retainAll(treeSet);
                return treeSet2.isEmpty();
            }
        }
        return false;
    }

    void setTargetNamespace(URI uRI) {
        this.targetNamespace = uRI;
    }

    public Node toXMLRepresentation(Document document) {
        Object object;
        Element element = document.createElement("generalWildcard");
        this.addNamespaceDeclaration(element);
        if (this.ftype != 3 && this.ftype != 4) {
            object = document.createAttribute("namespace");
            object.setValue(WildcardImpl.wildcardCategory(this.ftype));
            element.appendChild((Node)object);
        } else {
            object = new StringBuffer();
            if (this.ftype == 4) {
                ((StringBuffer)object).append("##targetNamespace");
            }
            if (this.fnamespace != null) {
                int n = 0;
                while (n < this.fnamespace.length) {
                    if (n != 0) {
                        ((StringBuffer)object).append(" ");
                    }
                    if (this.fnamespace[n] != null) {
                        ((StringBuffer)object).append(this.fnamespace[n].toString());
                    } else {
                        ((StringBuffer)object).append("##local");
                    }
                    ++n;
                }
            }
            Attr attr = document.createAttribute("namespace");
            attr.setValue(((StringBuffer)object).toString());
            element.appendChild(attr);
        }
        object = null;
        switch (this.getProcessContents()) {
            case 1: {
                object = "skip";
                break;
            }
            case 0: {
                object = "strict";
                break;
            }
            case 2: {
                object = "lax";
            }
        }
        if (object != null) {
            Attr attr = document.createAttribute("processContents");
            attr.setValue((String)object);
            element.appendChild(attr);
        }
        return element;
    }

    public Attr[] toXMLRepresentationAsAttrs(Document document) {
        CharSequence charSequence;
        Attr attr;
        if (this.ftype != 3 && this.ftype != 4) {
            attr = document.createAttribute("namespace");
            attr.setValue(WildcardImpl.wildcardCategory(this.ftype));
        } else {
            charSequence = new StringBuffer();
            if (this.ftype == 4) {
                ((StringBuffer)charSequence).append("##targetNamespace");
            }
            if (this.fnamespace != null) {
                int n = 0;
                while (n < this.fnamespace.length) {
                    if (n != 0) {
                        ((StringBuffer)charSequence).append(" ");
                    }
                    if (this.fnamespace[n] != null) {
                        ((StringBuffer)charSequence).append(this.fnamespace[n].toString());
                    } else {
                        ((StringBuffer)charSequence).append("##local");
                    }
                    ++n;
                }
            }
            attr = document.createAttribute("namespace");
            attr.setValue(((StringBuffer)charSequence).toString());
        }
        charSequence = null;
        switch (this.getProcessContents()) {
            case 1: {
                charSequence = "skip";
                break;
            }
            case 0: {
                charSequence = "strict";
                break;
            }
            case 2: {
                charSequence = "lax";
            }
        }
        if (charSequence != null) {
            Attr attr2 = document.createAttribute("processContents");
            attr2.setValue((String)charSequence);
            Attr[] attrArray = new Attr[]{attr, attr2};
            return attrArray;
        }
        Attr[] attrArray = new Attr[]{attr};
        return attrArray;
    }

    public int union(Wildcard[] wildcardArray, Vector vector) {
        Wildcard[] wildcardArray2 = new Wildcard[wildcardArray.length + 1];
        wildcardArray2[0] = this;
        System.arraycopy(wildcardArray, 0, wildcardArray2, 1, wildcardArray.length);
        return WildcardImpl.getUnion(wildcardArray2, vector);
    }

    public int union(Wildcard wildcard, Vector vector) {
        TreeSet treeSet = WildcardImpl.getNamespaces(this);
        TreeSet treeSet2 = WildcardImpl.getNamespaces(wildcard);
        int n = WildcardImpl.getCanonicalType(this.ftype);
        int n2 = WildcardImpl.getCanonicalType(wildcard.getType());
        if (n == 0 || wildcard.getType() == 0) {
            return 0;
        }
        if (n == n2) {
            TreeSet treeSet3 = (TreeSet)treeSet.clone();
            if (n == 3) {
                if (vector != null) {
                    treeSet3.addAll(treeSet2);
                    vector.addAll(treeSet3);
                }
                return 3;
            }
            treeSet3.retainAll(treeSet2);
            if (treeSet3.isEmpty()) {
                return 0;
            }
            if (treeSet3.contains(null)) {
                if (vector != null) {
                    vector.addAll(treeSet3);
                }
                return 2;
            }
            return -1;
        }
        if (n == 2 && n2 == 3) {
            TreeSet treeSet4 = (TreeSet)treeSet.clone();
            treeSet4.removeAll(treeSet2);
            if (treeSet4.isEmpty()) {
                return 0;
            }
            if (vector != null) {
                vector.addAll(treeSet4);
            }
            return 2;
        }
        return wildcard.union(this, vector);
    }

    public boolean validate(URI uRI) {
        switch (this.ftype) {
            case 0: {
                return true;
            }
            case 1: {
                URI uRI2 = this.getTargetNamespace();
                if (uRI2 != null) {
                    return uRI != null && !uRI2.equals(uRI);
                }
                return uRI != null;
            }
            case 4: {
                URI uRI3 = this.getTargetNamespace();
                if (uRI3 != null ? uRI3.equals(uRI) : uRI == null) {
                    return true;
                }
            }
            case 3: {
                int n = 0;
                while (n < this.fnamespace.length) {
                    if (this.fnamespace[n] != null ? this.fnamespace[n].equals(uRI) : uRI == null) {
                        return true;
                    }
                    ++n;
                }
                break;
            }
        }
        return false;
    }

    public static String wildcardCategory(int n) {
        switch (n) {
            case 0: {
                return "##any";
            }
            case 1: {
                return "##other";
            }
            case 3: {
                return "##list";
            }
            case 2: {
                return "##not";
            }
        }
        return null;
    }
}

