/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.ecm.schema.impl;

import com.ibm.sketch.util.xpath.NeedEncodingSupportException;
import com.ibm.xml.ecm.schema.SchemaException;
import com.ibm.xml.ecm.schema.XPathSchemaException;
import com.ibm.xml.ecm.schema.impl.AbstractChecker;
import com.ibm.xml.ecm.schema.impl.CheckType;
import com.ibm.xml.ecm.schema.impl.WhiteSpaceFacetStrategy;
import com.ibm.xml.ecm.schema.impl.XpathContainerImpl;
import org.apache.xerces.impl.xpath.regex.Match;
import org.apache.xerces.impl.xpath.regex.ParseException;
import org.apache.xerces.impl.xpath.regex.RegularExpression;

public class XPathContainer_Checker
extends AbstractChecker {
    private SchemaException[] fExceptions;
    public static CheckType ID = new CheckType("Xpath  checker");
    private static final String SELECTOR_XPATH_REGEX_STR = "(\\.//)?(((child::)?((\\i\\c*:)?(\\i\\c*|\\*)))|\\.)(/(((child::)?((\\i\\c*:)?(\\i\\c*|\\*)))|\\.))*(\\|(\\.//)?(((child::)?((\\i\\c*:)?(\\i\\c*|\\*)))|\\.)(/(((child::)?((\\i\\c*:)?(\\i\\c*|\\*)))|\\.))*)*";
    private static final String FIELD_XPATH_REGEX_STR = "(\\.//)?((((child::)?((\\i\\c*:)?(\\i\\c*|\\*)))|\\.)/)*((((child::)?((\\i\\c*:)?(\\i\\c*|\\*)))|\\.)|((attribute::|@)((\\i\\c*:)?(\\i\\c*|\\*))))(\\|(\\.//)?((((child::)?((\\i\\c*:)?(\\i\\c*|\\*)))|\\.)/)*((((child::)?((\\i\\c*:)?(\\i\\c*|\\*)))|\\.)|((attribute::|@)((\\i\\c*:)?(\\i\\c*|\\*)))))*";
    private static RegularExpression SELECTOR_XPATH_REGEX;
    private static RegularExpression FIELD_XPATH_REGEX;
    static /* synthetic */ Class class$com$ibm$xml$ecm$schema$impl$XpathContainerImpl;

    public XPathContainer_Checker(XpathContainerImpl xpathContainerImpl) {
        super(xpathContainerImpl);
        if (SELECTOR_XPATH_REGEX == null) {
            SELECTOR_XPATH_REGEX = new RegularExpression(SELECTOR_XPATH_REGEX_STR, "X");
        }
        if (FIELD_XPATH_REGEX == null) {
            FIELD_XPATH_REGEX = new RegularExpression(FIELD_XPATH_REGEX_STR, "X");
        }
    }

    public boolean check(boolean bl) {
        this.fExceptions = null;
        XpathContainerImpl xpathContainerImpl = (XpathContainerImpl)this.subject;
        try {
            xpathContainerImpl.getXPath();
        }
        catch (XPathSchemaException xPathSchemaException) {
            if (xPathSchemaException.getException() instanceof NeedEncodingSupportException) {
                RegularExpression regularExpression = null;
                if (xpathContainerImpl.getType() == 1) {
                    regularExpression = SELECTOR_XPATH_REGEX;
                } else if (xpathContainerImpl.getType() == 0) {
                    regularExpression = FIELD_XPATH_REGEX;
                }
                if (regularExpression != null && xpathContainerImpl.getValue() != null) {
                    Match match;
                    String string = WhiteSpaceFacetStrategy.normalize(xpathContainerImpl.getValue(), "collapse");
                    if (regularExpression.matches(string, match = new Match()) && match.getCapturedText(0).equals(string)) {
                        return true;
                    }
                    this.fExceptions = new SchemaException[]{new XPathSchemaException(xpathContainerImpl.getValue(), null)};
                    return false;
                }
                return true;
            }
            this.fExceptions = new SchemaException[]{xPathSchemaException};
            return false;
        }
        return true;
    }

    public CheckType getCheckType() {
        return ID;
    }

    public int getCost() {
        return 3;
    }

    public SchemaException[] getExceptions() {
        return this.fExceptions;
    }

    public Class getSubjectClass() {
        return class$com$ibm$xml$ecm$schema$impl$XpathContainerImpl == null ? (class$com$ibm$xml$ecm$schema$impl$XpathContainerImpl = XPathContainer_Checker.class$("com.ibm.xml.ecm.schema.impl.XpathContainerImpl")) : class$com$ibm$xml$ecm$schema$impl$XpathContainerImpl;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        CheckType.register(ID);
        try {
            FIELD_XPATH_REGEX = new RegularExpression(FIELD_XPATH_REGEX_STR, "X");
            SELECTOR_XPATH_REGEX = new RegularExpression(SELECTOR_XPATH_REGEX_STR, "X");
        }
        catch (ParseException parseException) {
            new RuntimeException("Fatal Application Error in XPathContaint_Checker : " + parseException.getMessage());
        }
    }
}

