/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.ecm.schema.impl;

import com.ibm.xml.ecm.schema.DatatypeFormatException;
import com.ibm.xml.ecm.schema.impl.BuiltInDatatypeFactory;
import com.ibm.xml.ecm.schema.impl.DateTimeLiteral;
import com.ibm.xml.ecm.schema.impl.LiteralValueImpl;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.GregorianCalendar;
import java.util.Locale;
import org.apache.xerces.impl.xpath.regex.Match;
import org.apache.xerces.impl.xpath.regex.RegularExpression;

public class YearLiteral
extends DateTimeLiteral {
    public static final String copyright = "Licensed Materials - Property of IBM (C) Copyright IBM Corp. 2000, 2001, 2002    All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public YearLiteral(String string) throws DatatypeFormatException {
        super(string);
    }

    public Object clone() {
        try {
            return new YearLiteral(new String(this.valueAsString));
        }
        catch (DatatypeFormatException datatypeFormatException) {
            datatypeFormatException.printStackTrace(System.err);
            return null;
        }
    }

    protected void conversion(String string) throws DatatypeFormatException {
        this.valueAsString = string;
        try {
            this.pattern = "yyyy";
            RegularExpression regularExpression = new RegularExpression("(?:(?:BC)|(?:AD))?\\d{4,}(?:Z|(?:(?:-|\\+)(?:14:00|(?:0[0-9]|1[0-3]):(?:[0-5][0-9]))))?");
            string = this.dateWithEra(string);
            Match match = new Match();
            if (this.valueAsString.startsWith("0000") || this.valueAsString.startsWith("-0000") || !regularExpression.matches(string, match) || !match.getCapturedText(0).equals(string)) {
                throw new DatatypeFormatException(BuiltInDatatypeFactory.getInstance().getBuiltInDatatype("gYear"), this.valueAsString);
            }
            this.XMLSchemaZoneTimeFormat(string, new SimpleDateFormat(this.pattern));
        }
        catch (ParseException parseException) {
            throw new DatatypeFormatException(BuiltInDatatypeFactory.getInstance().getBuiltInDatatype("gYear"), this.valueAsString);
        }
    }

    protected int getTimeZoneIndex(String string) {
        int n = string.indexOf("Z");
        if (n == -1 && (n = string.indexOf("+")) == -1) {
            n = string.lastIndexOf("-");
        }
        return n;
    }

    public static void main(String[] stringArray) throws Exception {
        int n = 0;
        while (n < stringArray.length) {
            YearLiteral yearLiteral = new YearLiteral(stringArray[n]);
            System.out.println("current year = " + yearLiteral);
            System.out.println("previous year = " + yearLiteral.previous());
            System.out.println("next year = " + yearLiteral.next());
            ++n;
        }
    }

    public LiteralValueImpl next() {
        try {
            int n;
            GregorianCalendar gregorianCalendar = this.isTimeZoneSpecified() ? new GregorianCalendar(this.getTimeZone(), Locale.getDefault()) : new GregorianCalendar();
            gregorianCalendar.setTime(this.value);
            int n2 = gregorianCalendar.get(1);
            int n3 = gregorianCalendar.get(0);
            if (n3 == 0) {
                n2 = -n2;
            }
            if ((n = n2 + 1) == 0) {
                n = 1;
            }
            if (this.isTimeZoneSpecified()) {
                return new YearLiteral(this.formatYear(n) + this.zoneOffSet(this.getTimeZone().getRawOffset()));
            }
            return new YearLiteral(this.formatYear(n));
        }
        catch (DatatypeFormatException datatypeFormatException) {
            throw new RuntimeException("Application fatal error " + datatypeFormatException);
        }
    }

    public LiteralValueImpl previous() {
        try {
            int n;
            GregorianCalendar gregorianCalendar = this.isTimeZoneSpecified() ? new GregorianCalendar(this.getTimeZone(), Locale.getDefault()) : new GregorianCalendar();
            gregorianCalendar.setTime(this.value);
            int n2 = gregorianCalendar.get(1);
            int n3 = gregorianCalendar.get(0);
            if (n3 == 0) {
                n2 = -n2;
            }
            if ((n = n2 - 1) == 0) {
                n = -1;
            }
            if (this.isTimeZoneSpecified()) {
                return new YearLiteral(this.formatYear(n) + this.zoneOffSet(this.getTimeZone().getRawOffset()));
            }
            return new YearLiteral(this.formatYear(n));
        }
        catch (DatatypeFormatException datatypeFormatException) {
            throw new RuntimeException("Application fatal error " + datatypeFormatException);
        }
    }
}

