/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.ecm.schema.impl;

import com.ibm.xml.ecm.schema.DatatypeFormatException;
import com.ibm.xml.ecm.schema.impl.BuiltInDatatypeFactory;
import com.ibm.xml.ecm.schema.impl.DateTimeLiteral;
import com.ibm.xml.ecm.schema.impl.LiteralValueImpl;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.GregorianCalendar;
import java.util.Locale;
import org.apache.xerces.impl.xpath.regex.Match;
import org.apache.xerces.impl.xpath.regex.RegularExpression;

public class YearMonthLiteral
extends DateTimeLiteral {
    public static final String copyright = "Licensed Materials - Property of IBM (C) Copyright IBM Corp. 2000, 2001, 2002    All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public YearMonthLiteral(String string) throws DatatypeFormatException {
        super(string);
    }

    public Object clone() {
        try {
            return new YearMonthLiteral(new String(this.valueAsString));
        }
        catch (DatatypeFormatException datatypeFormatException) {
            datatypeFormatException.printStackTrace(System.err);
            return null;
        }
    }

    protected void conversion(String string) throws DatatypeFormatException {
        this.valueAsString = string;
        try {
            this.pattern = "yyyy-MM";
            RegularExpression regularExpression = new RegularExpression("(?:(?:BC)|(?:AD))?\\d{4,}-(?:(?:0[1-9])|(?:1[0-2]))(?:Z|(?:(?:-|\\+)(?:14:00|(?:0[0-9]|1[0-3]):(?:[0-5][0-9]))))?");
            string = this.dateWithEra(string);
            Match match = new Match();
            if (this.valueAsString.startsWith("0000") || this.valueAsString.startsWith("-0000") || !regularExpression.matches(string, match) || !match.getCapturedText(0).equals(string)) {
                throw new DatatypeFormatException(BuiltInDatatypeFactory.getInstance().getBuiltInDatatype("gYearMonth"), this.valueAsString);
            }
            this.XMLSchemaZoneTimeFormat(string, new SimpleDateFormat(this.pattern));
        }
        catch (ParseException parseException) {
            throw new DatatypeFormatException(BuiltInDatatypeFactory.getInstance().getBuiltInDatatype("gYearMonth"), this.valueAsString);
        }
    }

    protected int getTimeZoneIndex(String string) {
        int n = string.indexOf("Z");
        if (n == -1 && (n = string.indexOf("+")) == -1 && this.hasMoreThanXMinus(1, string)) {
            n = string.lastIndexOf("-");
        }
        return n;
    }

    public static void main(String[] stringArray) throws Exception {
        int n = 0;
        while (n < stringArray.length) {
            YearMonthLiteral yearMonthLiteral = new YearMonthLiteral(stringArray[n]);
            System.out.println("current yearMonth = " + yearMonthLiteral);
            System.out.println("previous yearMonth = " + yearMonthLiteral.previous());
            System.out.println("next yearMonth = " + yearMonthLiteral.next());
            ++n;
        }
    }

    public LiteralValueImpl next() {
        try {
            GregorianCalendar gregorianCalendar = this.isTimeZoneSpecified() ? new GregorianCalendar(this.getTimeZone(), Locale.getDefault()) : new GregorianCalendar();
            gregorianCalendar.setTime(this.value);
            int n = gregorianCalendar.get(2) + 1;
            int n2 = gregorianCalendar.get(1);
            int n3 = gregorianCalendar.get(0);
            if (n3 == 0) {
                n2 = -n2;
            }
            if (n == 12) {
                ++n2;
                n = 1;
            } else {
                ++n;
            }
            if (n2 == 0) {
                n2 = 1;
            }
            if (this.isTimeZoneSpecified()) {
                return new YearMonthLiteral(this.formatYear(n2) + "-" + this.to2charsString(n) + this.zoneOffSet(this.getTimeZone().getRawOffset()));
            }
            return new YearMonthLiteral(this.formatYear(n2) + "-" + this.to2charsString(n));
        }
        catch (DatatypeFormatException datatypeFormatException) {
            throw new RuntimeException("Application fatal error " + datatypeFormatException);
        }
    }

    public LiteralValueImpl previous() {
        try {
            GregorianCalendar gregorianCalendar = this.isTimeZoneSpecified() ? new GregorianCalendar(this.getTimeZone(), Locale.getDefault()) : new GregorianCalendar();
            gregorianCalendar.setTime(this.value);
            int n = gregorianCalendar.get(2) + 1;
            int n2 = gregorianCalendar.get(1);
            int n3 = gregorianCalendar.get(0);
            if (n3 == 0) {
                n2 = -n2;
            }
            if (n == 1) {
                --n2;
                n = 12;
            } else {
                --n;
            }
            if (n2 == 0) {
                n2 = -1;
            }
            if (this.isTimeZoneSpecified()) {
                return new YearMonthLiteral(this.formatYear(n2) + "-" + this.to2charsString(n) + this.zoneOffSet(this.getTimeZone().getRawOffset()));
            }
            return new YearMonthLiteral(this.formatYear(n2) + "-" + this.to2charsString(n));
        }
        catch (DatatypeFormatException datatypeFormatException) {
            throw new RuntimeException("Application fatal error " + datatypeFormatException);
        }
    }
}

