/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.parsers;

import com.ibm.xml.framework.EntityPool;
import com.ibm.xml.framework.ParserState;
import com.ibm.xml.framework.StringPool;
import com.ibm.xml.framework.XMLParser;
import java.io.IOException;
import org.xml.sax.DTDHandler;
import org.xml.sax.DocumentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class SAXParser
extends XMLParser {
    private DTDHandler fDTDHandler;
    private DocumentHandler fDocumentHandler;
    protected boolean fRootElement;

    public SAXParser() {
        ParserState parserState = this.getParserState();
        parserState.useDefaultStringPool();
        parserState.useDefaultAttrPool();
        parserState.useDefaultEntityPool();
        parserState.useDefaultElementDeclPool();
        this.setDocumentHandler(this);
        this.setDocumentTypeHandler(this);
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this.getEntityHandler().setEntityResolver(entityResolver);
    }

    public void setDTDHandler(DTDHandler dTDHandler) {
        this.fDTDHandler = dTDHandler;
    }

    public void setDocumentHandler(DocumentHandler documentHandler) {
        this.fDocumentHandler = documentHandler;
    }

    public void doctypeDecl(int n) throws Exception {
    }

    public void startInternalSubset() throws Exception {
    }

    public void endInternalSubset() throws Exception {
    }

    public void startExternalSubset(int n, int n2) throws Exception {
    }

    public void endExternalSubset() throws Exception {
    }

    public void elementDecl(int n) throws Exception {
    }

    public void attlistDecl(int n, int n2) throws Exception {
    }

    public void internalEntityDecl(int n) throws Exception {
    }

    public void externalEntityDecl(int n) throws Exception {
    }

    public void unparsedEntityDecl(int n) throws Exception {
        if (this.fDTDHandler != null) {
            ParserState parserState = this.getParserState();
            EntityPool entityPool = parserState.getEntityPool();
            StringPool stringPool = parserState.getStringPool();
            String string = stringPool.toString(entityPool.getEntityName(n));
            String string2 = stringPool.toString(entityPool.getPublicId(n));
            String string3 = stringPool.toString(entityPool.getSystemId(n));
            String string4 = stringPool.toString(entityPool.getNotationName(n));
            this.fDTDHandler.unparsedEntityDecl(string, string2, string3, string4);
        }
    }

    public void parameterEntityDecl(int n) {
    }

    public void notationDecl(int n) throws Exception {
        if (this.fDTDHandler != null) {
            ParserState parserState = this.getParserState();
            EntityPool entityPool = parserState.getEntityPool();
            StringPool stringPool = parserState.getStringPool();
            String string = stringPool.toString(entityPool.getNotationName(n));
            String string2 = stringPool.toString(entityPool.getPublicId(n));
            String string3 = stringPool.toString(entityPool.getSystemId(n));
            this.fDTDHandler.notationDecl(string, string2, string3);
        }
    }

    public boolean sendCharDataAsCharArray() {
        return true;
    }

    public void startDocument(int n, int n2, int n3) throws Exception {
        StringPool stringPool = this.getParserState().getStringPool();
        stringPool.orphanString(n);
        stringPool.orphanString(n2);
        stringPool.orphanString(n3);
        if (this.fDocumentHandler != null) {
            this.fDocumentHandler.setDocumentLocator(this.getLocator());
            this.fDocumentHandler.startDocument();
        }
    }

    public void endDocument() throws Exception {
        if (this.fDocumentHandler != null) {
            this.fDocumentHandler.endDocument();
        }
    }

    public void startElement(int n, int n2) throws Exception {
        this.fRootElement = true;
        if (this.fDocumentHandler != null) {
            ParserState parserState = this.getParserState();
            this.fDocumentHandler.startElement(parserState.getStringPool().toString(n), parserState.getAttrPool().getAttributeList(n2));
        }
        this.getParserState().getAttrPool().releaseAttrList(n2);
    }

    public void endElement(int n) throws Exception {
        if (this.fDocumentHandler != null) {
            this.fDocumentHandler.endElement(this.getParserState().getStringPool().toString(n));
        }
    }

    public void startEntityReference(int n) throws Exception {
    }

    public void endEntityReference(int n) throws Exception {
    }

    public void characters(int n, boolean bl) throws Exception {
    }

    public void ignorableWhitespace(int n, boolean bl) throws Exception {
    }

    public void processingInstruction(int n, int n2) throws Exception {
        StringPool stringPool = this.getParserState().getStringPool();
        String string = stringPool.orphanString(n);
        String string2 = stringPool.orphanString(n2);
        if (this.fDocumentHandler != null) {
            this.fDocumentHandler.processingInstruction(string, string2);
        }
    }

    public void comment(int n) throws Exception {
        this.getParserState().getStringPool().releaseString(n);
    }

    public void characters(char[] cArray, int n, int n2, boolean bl) throws Exception {
        if (this.fDocumentHandler != null) {
            this.fDocumentHandler.characters(cArray, n, n2);
        }
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2, boolean bl) throws Exception {
        if (this.fDocumentHandler != null) {
            this.fDocumentHandler.ignorableWhitespace(cArray, n, n2);
        }
    }

    public void parse(InputSource inputSource) throws SAXException, IOException {
        this.fRootElement = false;
        super.parse(inputSource);
        if (!this.fRootElement) {
            try {
                this.error(118);
                return;
            }
            catch (Exception exception) {
                throw new SAXException(exception);
            }
        }
    }
}

