/*
 * Decompiled with CFR 0.152.
 */
package com.sun.msv.schematron.verifier;

import com.sun.msv.schematron.grammar.SAction;
import com.sun.msv.schematron.grammar.SActions;
import com.sun.msv.schematron.grammar.SElementExp;
import com.sun.msv.schematron.grammar.SRule;
import com.sun.msv.schematron.util.DOMBuilder;
import com.sun.msv.schematron.verifier.Loc;
import com.sun.msv.verifier.DocumentDeclaration;
import com.sun.msv.verifier.IVerifier;
import com.sun.msv.verifier.ValidityViolation;
import com.sun.msv.verifier.Verifier;
import com.sun.msv.verifier.VerifierFilter;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.crimson.tree.ElementNode2;
import org.apache.xerces.dom.CoreDocumentImpl;
import org.apache.xml.utils.PrefixResolver;
import org.apache.xml.utils.PrefixResolverDefault;
import org.apache.xpath.XPathContext;
import org.relaxng.datatype.Datatype;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.LocatorImpl;

public class RelmesVerifier
implements IVerifier {
    private final VerifierFilter core;
    private final SchematronVerifier schChecker;
    private boolean schematronValid;

    public RelmesVerifier(IVerifier iVerifier) throws ParserConfigurationException {
        this.core = new VerifierFilter(iVerifier);
        this.schChecker = new SchematronVerifier();
        this.core.setContentHandler((ContentHandler)this.schChecker);
    }

    public RelmesVerifier(DocumentDeclaration documentDeclaration, ErrorHandler errorHandler) throws ParserConfigurationException {
        this((IVerifier)new Verifier(documentDeclaration, errorHandler));
    }

    public void setPanicMode(boolean bl) {
        this.core.setPanicMode(bl);
    }

    public boolean isValid() {
        return this.schematronValid && this.core.isValid();
    }

    public Object getCurrentElementType() {
        return this.core.getCurrentElementType();
    }

    public Datatype[] getLastCharacterType() {
        return this.core.getLastCharacterType();
    }

    public final Locator getLocator() {
        return this.core.getLocator();
    }

    public final ErrorHandler getErrorHandler() {
        return this.core.getErrorHandler();
    }

    public final void setErrorHandler(ErrorHandler errorHandler) {
        this.core.setErrorHandler(errorHandler);
    }

    public void setDocumentLocator(Locator locator) {
        this.core.setDocumentLocator(locator);
    }

    public void startDocument() throws SAXException {
        this.core.startDocument();
    }

    public void endDocument() throws SAXException {
        this.core.endDocument();
    }

    public void startPrefixMapping(String string, String string2) throws SAXException {
        this.core.startPrefixMapping(string, string2);
    }

    public void endPrefixMapping(String string) throws SAXException {
        this.core.endPrefixMapping(string);
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        this.core.startElement(string, string2, string3, attributes);
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        this.core.endElement(string, string2, string3);
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        this.core.characters(cArray, n, n2);
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
        this.core.ignorableWhitespace(cArray, n, n2);
    }

    public void processingInstruction(String string, String string2) throws SAXException {
        this.core.processingInstruction(string, string2);
    }

    public void skippedEntity(String string) throws SAXException {
        this.core.skippedEntity(string);
    }

    class SchematronVerifier
    extends DOMBuilder {
        private final Map idMap = new HashMap();
        private final Map locationMap = new HashMap();
        private final Map checks = new HashMap();
        private final Stack effectiveRules = new Stack();

        SchematronVerifier() throws ParserConfigurationException {
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            super.startElement(string, string2, string3, attributes);
            this.locationMap.put(this.parent, new Loc(RelmesVerifier.this.getLocator()));
            Object object = RelmesVerifier.this.getCurrentElementType();
            if (object instanceof SElementExp) {
                this.checks.put(this.parent, object);
            }
            int n = 0;
            while (n < attributes.getLength()) {
                if ("ID".equals(attributes.getType(n))) {
                    try {
                        ((CoreDocumentImpl)this.dom).putIdentifier(attributes.getValue(n), (Element)this.parent);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    try {
                        ((ElementNode2)this.parent).setIdAttributeName(attributes.getQName(n));
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                ++n;
            }
        }

        public void startDocument() throws SAXException {
            super.startDocument();
            this.checks.clear();
            this.locationMap.clear();
        }

        public void endDocument() throws SAXException {
            super.endDocument();
            RelmesVerifier.this.schematronValid = true;
            try {
                this.testNode(this.dom);
            }
            catch (TransformerException transformerException) {
                RelmesVerifier.this.getErrorHandler().error((SAXParseException)new ValidityViolation(null, "XPath error:" + transformerException.getMessage(), null));
                RelmesVerifier.this.schematronValid = false;
            }
        }

        private void testNode(Node node) throws SAXException, TransformerException {
            Object object;
            int n;
            SElementExp sElementExp = (SElementExp)((Object)this.checks.get(node));
            int n2 = 0;
            if (sElementExp != null) {
                n = 0;
                while (n < sElementExp.rules.length) {
                    if (!this.effectiveRules.contains(sElementExp.rules)) {
                        this.effectiveRules.push(sElementExp.rules[n]);
                        ++n2;
                    }
                    ++n;
                }
                this.testActions(sElementExp.actions, node);
            }
            n = this.effectiveRules.size();
            int n3 = 0;
            while (n3 < n) {
                this.testRule((SRule)this.effectiveRules.get(n3), node);
                ++n3;
            }
            if (node.getNodeType() == 1) {
                object = (Element)node;
                NamedNodeMap namedNodeMap = object.getAttributes();
                n = namedNodeMap.getLength();
                int n4 = 0;
                while (n4 < n) {
                    this.testNode(namedNodeMap.item(n4));
                    ++n4;
                }
            }
            object = node.getChildNodes();
            n = object.getLength();
            int n5 = 0;
            while (n5 < n) {
                this.testNode(object.item(n5));
                ++n5;
            }
            while (n2 > 0) {
                this.effectiveRules.pop();
                --n2;
            }
        }

        private void testRule(SRule sRule, Node node) throws SAXException, TransformerException {
            if (!sRule.matches(node)) {
                return;
            }
            this.testActions(sRule, node);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void testActions(SActions sActions, Node node) throws SAXException, TransformerException {
            PrefixResolverDefault prefixResolverDefault = new PrefixResolverDefault(node);
            SActions sActions2 = sActions;
            synchronized (sActions2) {
                int n = 0;
                while (n < sActions.asserts.length) {
                    if (!sActions.asserts[n].xpath.execute(new XPathContext(), node, (PrefixResolver)prefixResolverDefault).bool()) {
                        this.reportError(node, sActions.asserts[n]);
                    }
                    ++n;
                }
                int n2 = 0;
                while (n2 < sActions.reports.length) {
                    if (sActions.reports[n2].xpath.execute(new XPathContext(), node, (PrefixResolver)prefixResolverDefault).bool()) {
                        this.reportError(node, sActions.reports[n2]);
                    }
                    ++n2;
                }
            }
        }

        private void reportError(Node node, SAction sAction) throws SAXException {
            Loc loc = (Loc)this.locationMap.get(node);
            if (loc == null) {
                if (node instanceof Attr) {
                    this.reportError(((Attr)node).getOwnerElement(), sAction);
                    return;
                }
                if (node.getParentNode() != null) {
                    this.reportError(node.getParentNode(), sAction);
                    return;
                }
            }
            LocatorImpl locatorImpl = new LocatorImpl();
            if (loc != null) {
                locatorImpl.setLineNumber(loc.line);
                locatorImpl.setColumnNumber(loc.col);
            }
            locatorImpl.setSystemId(RelmesVerifier.this.getLocator().getSystemId());
            locatorImpl.setPublicId(RelmesVerifier.this.getLocator().getPublicId());
            RelmesVerifier.this.schematronValid = false;
            RelmesVerifier.this.getErrorHandler().error((SAXParseException)new ValidityViolation((Locator)locatorImpl, sAction.document, null));
        }

        private class XPathContextImpl
        extends XPathContext {
            private XPathContextImpl() {
            }
        }
    }
}

