<?xml version="1.0"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
	xmlns:exslt="http://exslt.org/common"
	xmlns:func="http://exslt.org/functions"
	xmlns:my="http://www.mywork.com"
	exclude-result-prefixes="my func exslt">

	<xsl:output method="xml" indent="yes"/>

	<func:function name="my:count-elements">
		<xsl:param name="p"/>
		<func:result select="count($p)"/>
	</func:function>

	<xsl:template match="/">
		<Catalog>
				<!--here how to invoke a user-defined function as prt of a Xpath expression -->
				<count number='{my:count-elements(books/book)}'/> 
				<books>
					<!--example of how to invoke a built-in EXSLT function-->
					<xsl:copy-of select="exslt:node-set(books/book)"/>
				</books>
		</Catalog>
	</xsl:template>
</xsl:stylesheet><!-- Stylus Studio meta-information - (c) 2004-2006. Progress Software Corporation. All rights reserved.
<metaInformation>
<scenarios ><scenario default="yes" name="books.xml" userelativepaths="yes" externalpreview="no" url="books.xml" htmlbaseurl="" outputurl="" processortype="xalan" useresolver="yes" profilemode="0" profiledepth="" profilelength="" urlprofilexml="" commandline="" additionalpath="" additionalclasspath="" postprocessortype="none" postprocesscommandline="" postprocessadditionalpath="" postprocessgeneratedext="" validateoutput="no" validator="internal" customvalidator=""/></scenarios><MapperMetaTag><MapperInfo srcSchemaPathIsRelative="yes" srcSchemaInterpretAsXML="no" destSchemaPath="catalog.xml" destSchemaRoot="Catalog" destSchemaPathIsRelative="yes" destSchemaInterpretAsXML="no" ><SourceSchema srcSchemaPath="books.xml" srcSchemaRoot="books" AssociatedInstance="" loaderFunction="document" loaderFunctionUsesURI="no"/></MapperInfo><MapperBlockPosition></MapperBlockPosition><TemplateContext></TemplateContext><MapperFilter side="source"></MapperFilter></MapperMetaTag>
</metaInformation>
-->