/**
 * Generated by Stylus Studio. 
 * This application skeleton demonstrates how to execute XSLT from Java using the JAXP API. 
 */



import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamSource;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.TransformerException;
import javax.xml.transform.Transformer;
import javax.xml.transform.stream.StreamResult;

import java.io.InputStream;
import java.io.FileInputStream;
import java.io.OutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.File;



import com.exln.stylus.io.StylusFileFactory;


public class sampleBooksToCatalog implements ErrorListener {

private static final int XALANJ  = 10;
private static final int SAXON6	 = 11;
private static final int SAXON8  = 12;


final private static String XALANJ_FACTORY = "org.apache.xalan.processor.TransformerFactoryImpl";

	BasicSource		m_scriptSource	  = null;
	BasicSource		m_xmlSource		  = null;
	BasicResult		m_transformResult = null;
	BasicResult		m_finalResult	  = null;

	boolean			m_useResolver	= true;
	boolean			m_useApacheFop	= false;
	int				m_selectedProcessor= 0;
	boolean			m_doValidation	= false;
	boolean			m_doCopyStep	= false;


	String			m_validatorInput  = null;
	String			m_fopInputFilename= null;
	File			m_tmpFile		  = null;

	String			m_paramNames[]	= null;
	String			m_paramValues[]	= null;



	// application constructor
	public sampleBooksToCatalog() {}

	public static void main(String[] args) throws IOException, TransformerException 
	{

		sampleBooksToCatalog app = new sampleBooksToCatalog();

		// This section lists all scenarios selected for this XSLT.
		// Uncomment the setScenario call for the scenario you want 
		// the code to run.  All other scenarios must be commented out.
		try {
			app.setScenario_books_0046_xml();

			app.initialize();
			app.process();
		} finally {
			app.cleanup();
		}
	}

	/////////////////////////////////////////////////////////////////
	// Only one of these setScenario methods can be called at a time.
	/////////////////////////////////////////////////////////////////
	public void setScenario_books_0046_xml() throws
										  IOException
	{

		// This section performs initialization required by the
		// Stylus Studio URIresolver. Further details can be found in
		// the Stylus Studio Javadoc for package com.exln.stylus.io.
		// setProp will not change any System properties that were
		// set before this method was run. 
		StylusFileFactory.unlockAPI("315146-772511120");
		setProp("bindir", "C:/Program Files/Stylus Studio 6 XML Enterprise Edition/bin");
		setProp("rootdir", "C:/Program Files/Stylus Studio 6 XML Enterprise Edition");
		setProp("appdata", "C:/Documents and Settings/All Users/Application Data/Stylus Studio");

		m_useResolver   = true;

		m_scriptSource	= new ResolverSource();
		m_xmlSource		= new ResolverSource();
		m_finalResult	= new ResolverResult();
		m_scriptSource.setFile("c:/Program Files/Stylus Studio 6 XML Enterprise Edition/examples/simpleMappings/sampleBooksToCatalog.xsl");
		m_xmlSource.setFile("c:/Program Files/Stylus Studio 6 XML Enterprise Edition/examples/simpleMappings/books.xml");
		m_finalResult.setNone();

		m_paramNames	= new String[] {};
		m_paramValues	= new String[] {};
		System.setProperty("javax.xml.transform.TransformerFactory", XALANJ_FACTORY);
		m_selectedProcessor = XALANJ;
	}

	///////////////////////////////////////////////////////////
	// Perform initialization common to all scenarios. One of
	// the setScenario methods should have been called first.
	///////////////////////////////////////////////////////////
	public void initialize() throws java.io.IOException
	{
		if (   m_paramNames != null
		    && m_paramValues != null
			&& m_paramNames.length != m_paramValues.length)
				throw new RuntimeException("Mismatching number of parameter names and values");


		if (!m_useApacheFop && !m_doValidation) {
			// In the simplest scenario, the XSLT output is sent 
			// directly to the output URL.
			//  xmlSource -> XSLT -> finalResult
			m_transformResult = m_finalResult;
		}
		else
		if (m_finalResult.isFile()) {

			// The XSLT output is being written to a file, and there
			// is also a validation and/or FOP step.  After the
			// XSLT output is written to the file, that file will be
			// used as input for the validation and/or FOP step.
			// xmlSource -> XSLT -> finalResult -> validator
			//                      finalResult -> FOP
			m_transformResult  = m_finalResult;
			m_validatorInput   = m_finalResult.getFilename();
			m_fopInputFilename = m_finalResult.getFilename();
		}
		else
		{	// The XSLT output is being written to a URL or to System.out.
			// and there is also a validation and/or FOP step.  The XSLT
			// output will first be written to a temp file.  Then, the
			// temp file will be copied to the output URL (or System.out).
			// The temp file will also be used as input for the validation
			// and/or FOP step.
			// xmlSource -> XSLT-> tmpFile -> doCopy -> finalResult
			//                     tmpFile -> validator
			//                     tmpFile -> FOP
			m_tmpFile = File.createTempFile("tmp", ".xml");
			m_tmpFile.deleteOnExit();
			m_transformResult = new BasicResult();
			m_transformResult.setFile(m_tmpFile.getAbsolutePath());
			m_doCopyStep = true;

			m_validatorInput   = m_tmpFile.getAbsolutePath();
			m_fopInputFilename = m_tmpFile.getAbsolutePath();
		}
	}


	public void process() throws TransformerException, IOException
	{
		// These checks are unnecessary if you use the setScenario and initialize methods.
		// If, however, you bypass the setScenario method and forget some of the initialization,
		// these checks make it much easier to identify the problem.
		if (m_xmlSource==null || m_xmlSource.getInputStream()==null)
			throw new TransformerException("You must initialize m_xmlSource before calling process()");
		if (m_scriptSource==null || m_scriptSource.getInputStream()==null)
			throw new TransformerException("You must initialize m_scriptSource before calling process()");
		if (m_transformResult==null || m_transformResult.getOutputStream()==null)
			throw new TransformerException("You must initialize m_transformResult before calling process()");

		TransformerFactory tFactory = TransformerFactory.newInstance();
		tFactory.setErrorListener(this);

		Transformer t = tFactory.newTransformer(m_scriptSource);
		t.setErrorListener(this);


		if (m_paramNames != null && m_paramValues != null) {
			int len = m_paramNames.length;
			if (len != m_paramValues.length) {
				throw new RuntimeException("Mismatching number of parameter names and values");
			}
			for (int i = 0; i < len; i++) {
				t.setParameter(m_paramNames[i], m_paramValues[i]);
			}
		}			

		t.transform(m_xmlSource, m_transformResult);
		m_transformResult.close(); 

		if (m_doCopyStep)   copyOutput(m_validatorInput, m_finalResult);
	}
	
	public void error(TransformerException exception) throws TransformerException {
		throw exception;
	}
	
	public void fatalError(TransformerException exception) throws TransformerException {
		throw exception;
	}
	
	public void warning(TransformerException exception) {
		System.err.println("Warning: " + exception);
	}

	public void cleanup() {
		// The following code ensures that all streams opened by setScenario are closed.
		if (m_scriptSource	  != null) m_scriptSource.close();
		if (m_xmlSource		  != null) m_xmlSource.close();
		if (m_transformResult != null) m_transformResult.close();
		if (m_finalResult	  != null) m_finalResult.close();
	}



	//////////////////
	// helper methods
	//////////////////

	/**
	 * Set 1 of the 3 system properties: com.stylusstudio.bindir, etc.
	 * If the property is already set, it is not changed.
	 */
	void setProp(String suffix, String val) {
		String prop = "com.stylusstudio." + suffix;
		if (System.getProperty(prop) == null)
			System.setProperty(prop, val);
	}


	/**
	 * Copy the XQuery or XSLT output from the temp output file to the
	 * proper result file.  
	 * The XQuery or XSLT output was left in a temporary file. 
	 * This routine copies it to the proper result: m_transformResult
	 */
	void copyOutput(String inFilename, StreamResult result) throws IOException {
		InputStream is = null;
		OutputStream os = null;
		try {
			is	= new FileInputStream(inFilename);
			os = result.getOutputStream();
			byte buffer[] = new byte[8000];
			int bytesRead = 0;
			while ((bytesRead = is.read(buffer)) != -1) 
				os.write(buffer, 0, bytesRead);
		} finally {
			if (is != null) try{is.close();} catch(Throwable t) {}
		}
	}



	//////////////////
	// helper classes
	//////////////////

	// These helper classes are used to convert a URL string into a Source or Result:
	// BasicSource and BasicResult are used if NOT using the Stylus Studio URIResolver.
	// ResolverSource and ResolverResult are used with the Stylus Studio URIResolver.


	private class BasicSource extends StreamSource {
		protected boolean m_isOpen = false;
		void setFile(String filename) throws IOException {
			setSystemId("file:///" + filename.replaceAll(" ", "%20"));
			setInputStream(new FileInputStream(filename));
			m_isOpen = true;
		}
		void setURL(String urlString) throws IOException {
			setSystemId(urlString);
			setInputStream(new java.net.URL(urlString).openStream());
			m_isOpen = true;
		}
		void setNone() {
		}
		void close() {
			if (!m_isOpen) return;
			InputStream is = getInputStream();
			if (is!=null)
				try {is.close();} catch(Throwable t) {}
			m_isOpen = false;
		}
		protected void finalize() { close(); }
	}

	private class BasicResult extends StreamResult {
		protected boolean m_isOpen = false;
		protected boolean m_isFile = false;
		protected String  m_filename = null;
		void setFile(String filename) throws IOException {
			m_filename = filename;
			setSystemId("file:///" + filename.replaceAll(" ", "%20"));
			setOutputStream(new FileOutputStream(filename));
			m_isOpen = true;
			m_isFile = true;
		}
		boolean isFile()      { return m_isFile; }
		String  getFilename() { return m_filename; }
		void setURL(String urlString) throws IOException {
			setSystemId(urlString);
			java.net.URLConnection c = new java.net.URL(urlString).openConnection();
			c.setDoOutput(true);
			c.setDoInput(false);
			setOutputStream(c.getOutputStream());
			m_isOpen = true;
		}
		void setNone() {
			setOutputStream(System.out);
			m_isOpen = false;		// dont try to close System.out 
		}
		void close() {
			if (!m_isOpen) return;
			OutputStream os = getOutputStream();
			if (os!=null) {
				try {os.flush();} catch(Throwable t) {}
				try {os.close();} catch(Throwable t) {}
			}
			m_isOpen = false;
		}
		protected void finalize() { close(); }
	}

	private class ResolverSource extends BasicSource {
		void setURL(String urlString) throws IOException {
			setSystemId(urlString);
			setInputStream(StylusFileFactory.createInputStream(urlString, null));
			m_isOpen = true;
		}
	}


	private class ResolverResult extends BasicResult {
		void setURL(String urlString) throws IOException {
			setSystemId(urlString);
			setOutputStream(StylusFileFactory.createOutputStream(urlString, null));
			m_isOpen = true;
		}
	}

}
