import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;

import com.exln.stylus.io.StylusFileFactory;

public class EXCHANGE_2 {
	final private static String JAXB_FACTORY = "javax.xml.transform.TransformerFactory";
	final private static String SAXON8_FACTORY = "net.sf.saxon.TransformerFactoryImpl";
	final private static String STYLUS_ROOTDIR = "com.stylusstudio.rootdir";
	final private static String STYLUS_APPDATA = "com.stylusstudio.appdata";

	public static void main(String[] args) {
		System.setProperty(JAXB_FACTORY, SAXON8_FACTORY);
		System.setProperty(STYLUS_ROOTDIR, ".");
		System.setProperty(STYLUS_APPDATA, ".");
		MySerialNumber.setup();

		try {
			String xslURL = "file:///c:/Exchange/EXCHANGE.xsl";
			String xmlURL = "adapter:EXCHANGE.conv?file:///c:/Exchange/EXCHANGE.edi";
			Source xsl = StylusFileFactory.getFactory().resolve(xslURL, null);
			Source xml = StylusFileFactory.getFactory().resolve(xmlURL, null);
			Result out = new StreamResult(System.out);

			TransformerFactory factory = TransformerFactory.newInstance();
			Transformer t = factory.newTransformer(xsl);
			t.transform(xml, out);
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
}
