import java.io.OutputStream;

import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;

import com.exln.stylus.io.StylusFile;
import com.exln.stylus.io.StylusFileFactory;

public class EXCHANGE_3 {
	final private static String JAXB_FACTORY = "javax.xml.transform.TransformerFactory";
	final private static String SAXON8_FACTORY = "net.sf.saxon.TransformerFactoryImpl";
	final private static String STYLUS_ROOTDIR = "com.stylusstudio.rootdir";
	final private static String STYLUS_APPDATA = "com.stylusstudio.appdata";

	public static void main(String[] args) {
		System.setProperty(JAXB_FACTORY, SAXON8_FACTORY);
		System.setProperty(STYLUS_ROOTDIR, ".");
		System.setProperty(STYLUS_APPDATA, ".");
		MySerialNumber.setup();

		try {
			String xslURL = "file:///c:/Exchange/EXCHANGE.xsl";
			Source xsl = StylusFileFactory.getFactory().resolve(xslURL, null);
			String xmlURL = "adapter:EXCHANGE.conv?file:///c:/Exchange/EXCHANGE.edi";
			Source xml = StylusFileFactory.getFactory().resolve(xmlURL, null);
			String outURL = "adapter:CSV:newline=crlf:sep= :first=no:escape=~:quotes=\"'";
			StylusFileFactory sff = StylusFileFactory.getFactory();
			StylusFile outSF = sff.createStylusFile(outURL, System.out);
			OutputStream outStr = outSF.getOutputStream();
			Result out = new StreamResult(outStr);

			TransformerFactory factory = TransformerFactory.newInstance();
			Transformer t = factory.newTransformer(xsl);
			t.transform(xml, out);
			outStr.flush();
			outStr.close();

		} catch (Exception e) {
			e.printStackTrace();
		}
	}
}
