package com.stylusstudio.msv;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;

/*
 * Copyright (c) 2006 Progress Software Corporation. All rights reserved.
 * http://www.progress.com/
 *
 * Stylus Studio
 * http://www.stylusstudio.com/
 */

class DialectHandler implements ContentHandler, LexicalHandler {

	static final public String NSXSI = "http://www.w3.org/2001/XMLSchema-instance";
	
	private String m_xsdUri = null;
	private String m_publicId = null;
	private String m_systemId = null;

	String getXsdUri() { return m_xsdUri; }
	String getPublicId() { return m_publicId; }
	String getSystemId() { return m_systemId; }

	public DialectHandler() {
		super();
	}

	public void setDocumentLocator(Locator locator) {
	}

	public void startDocument() throws SAXException {
	}

	public void endDocument() throws SAXException {
	}

	public void startPrefixMapping(String prefix, String uri) throws SAXException {
	}

	public void endPrefixMapping(String prefix) throws SAXException {
	}

	public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
		for (int a = 0; a < atts.getLength(); a++) {
			if (!atts.getURI(a).equals(NSXSI))
				continue;
			if (atts.getLocalName(a).equals("noNamespaceSchemaLocation")) {
				m_xsdUri = atts.getValue(a);
			}
			else
			if (atts.getLocalName(a).equals("schemaLocation")) {
				String v = normalize(atts.getValue(a));
				int i = v.indexOf(' ');
				if (i == -1)
					continue;
				v = v.substring(i + 1);
				i = v.indexOf(' ');
				if (i > -1)
					v = v.substring(0, i);
				m_xsdUri = v;
			}
		}
		throw new FoundNeededInfoException();
	}

	public void endElement(String uri, String localName, String qName) throws SAXException {
	}

	public void characters(char[] ch, int start, int length) throws SAXException {
	}

	public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
	}

	public void processingInstruction(String target, String data) throws SAXException {
	}

	public void comment(char[] ch, int start, int length) throws SAXException {
	}

	public void endCDATA() throws SAXException {
	}

	public void endDTD() throws SAXException {
	}

	public void skippedEntity(String name) throws SAXException {
	}

	public void endEntity(String name) throws SAXException {
	}

	public void startCDATA() throws SAXException {
	}

	public void startDTD(String name, String publicId, String systemId) throws SAXException {
		m_publicId = publicId;
		m_systemId = systemId;
	}

	public void startEntity(String name) throws SAXException {
	}

	static private String normalize(String input)
	{
		if (input == null || input.length() == 0)
			return input;
		StringBuffer output = new StringBuffer(input.length());
		int start = 0;
		int end   = input.length();
		char c;
		while (start < end) {
			c = input.charAt(start);
			if (" \t\r\n".indexOf(c) == -1)
				break;
			start++;
		}
		while (start < end) {
			c = input.charAt(end - 1);
			if (" \t\r\n".indexOf(c) == -1)
				break;
			end--;
		}
		boolean changed = (start > 0 || end < input.length());
		boolean last = false;
		for (int i = start; i < end; i++) {
			c = input.charAt(i);
			if (" \t\r\n".indexOf(c) == -1) {
				last = false;
				output.append(c);
			} else {
				if (last) {
					changed = true;
				} else {
					if (c != ' ')
						changed = true;
					output.append(' ');
					last = true;
				}
			}
		}
		return changed ? output.toString() : input;
	}
}
