/*
 * Copyright (c) 2006 Progress Software Corporation. All rights reserved.
 * http://www.progress.com/
 *
 * Stylus Studio
 * http://www.stylusstudio.com/
*/
package com.stylusstudio.msv;

import org.iso_relax.dispatcher.Dispatcher;
import org.iso_relax.dispatcher.SchemaProvider;
import org.iso_relax.dispatcher.impl.DispatcherImpl;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

import com.sun.msv.driver.textui.ReportErrorHandler;

// validates a document by using divide & validate framework.
class RelaxVerifier implements DocumentVerifier {
	private final SchemaProvider m_sp;
	
	RelaxVerifier( SchemaProvider sp ) { m_sp = sp; }
	
	public boolean verify( XMLReader p, InputSource instance, boolean panicMode ) throws Exception {
		Dispatcher dispatcher = new DispatcherImpl(m_sp);
		dispatcher.attachXMLReader(p);
		ReportErrorHandler errorHandler = new ReportErrorHandler();
		dispatcher.setErrorHandler( errorHandler );
		
		p.parse(instance);
		return !errorHandler.hadError;
	}
}
