/*
 * Copyright (c) 2006 Progress Software Corporation. All rights reserved.
 * http://www.progress.com/
 *
 * Stylus Studio
 * http://www.stylusstudio.com/
*/
package com.stylusstudio.msv;

import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

import com.sun.msv.driver.textui.ReportErrorHandler;
import com.sun.msv.verifier.DocumentDeclaration;
import com.sun.msv.verifier.Verifier;

class SimpleVerifier implements DocumentVerifier {
	private final DocumentDeclaration m_docDecl;
	
	SimpleVerifier( DocumentDeclaration docDecl ) { m_docDecl = docDecl; }

	public boolean verify( XMLReader p, InputSource instance, boolean panicMode ) throws Exception {
		ReportErrorHandler reh = new ReportErrorHandler();
		Verifier v = new Verifier( m_docDecl, reh );
        v.setPanicMode(panicMode);
	
		p.setDTDHandler(v);
		p.setContentHandler(v);
		p.setErrorHandler(reh);
	
		p.parse( instance );
		return v.isValid();
	}
}
