/*
 * Copyright (c) 2006 Progress Software Corporation. All rights reserved.
 * http://www.progress.com/
 *
 * Stylus Studio
 * http://www.stylusstudio.com/
*/
package com.stylusstudio.msv;

import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

import com.sun.msv.driver.textui.ReportErrorHandler;
import com.sun.msv.grammar.xmlschema.XMLSchemaGrammar;
import com.sun.msv.verifier.Verifier;
import com.sun.msv.verifier.identity.IDConstraintChecker;

class XMLSchemaVerifier implements DocumentVerifier {
	private final XMLSchemaGrammar m_grammar;
	
	XMLSchemaVerifier( XMLSchemaGrammar grammar ) { m_grammar = grammar; }

	public boolean verify( XMLReader p, InputSource instance, boolean panicMode ) throws Exception {
		ReportErrorHandler reh = new ReportErrorHandler();
		Verifier v = new IDConstraintChecker( m_grammar, reh );
        v.setPanicMode(panicMode);
	
		p.setDTDHandler(v);
		p.setContentHandler(v);
		p.setErrorHandler(reh);
	
		p.parse( instance );
		return v.isValid();
	}
}