<?xml version='1.0' encoding='US-ASCII' ?>
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:output method="xml" encoding="US-ASCII" indent="yes"/>
	<xsl:template match="/">
		<EDIFACT>
			<UNB>
				<UNB01-SyntaxIdentifier>
					<UNB0101-SyntaxIdentifier>UNOA</UNB0101-SyntaxIdentifier>
					<UNB0102-SyntaxVersionNumber>4</UNB0102-SyntaxVersionNumber>
				</UNB01-SyntaxIdentifier>
				<UNB02-InterchangeSender>
					<UNB0201-InterchangeSenderIdentification>STYLUSSTUDIO</UNB0201-InterchangeSenderIdentification>
					<UNB0202-IdentificationCodeQualifier>1</UNB0202-IdentificationCodeQualifier>
				</UNB02-InterchangeSender>
				<UNB03-InterchangeRecipient>
					<UNB0301-InterchangeRecipientIdentification>DATADIRECT</UNB0301-InterchangeRecipientIdentification>
					<UNB0302-IdentificationCodeQualifier>1</UNB0302-IdentificationCodeQualifier>
				</UNB03-InterchangeRecipient>
				<UNB04-DateAndTimeOfPreparation>
					<UNB0401-Date>
						<xsl:value-of select="translate(substring(string(current-date()),1,10),'-','')"/>
					</UNB0401-Date>
					<UNB0402-Time>
						<xsl:value-of select="translate(substring(string(current-time()),1,5),':','')"/>
					</UNB0402-Time>
				</UNB04-DateAndTimeOfPreparation>
				<UNB05-InterchangeControlReference>
					<xsl:value-of select="translate(substring-before(string(current-time()),'-'),':.','')"/>
				</UNB05-InterchangeControlReference>
			</UNB>
			<INVRPT>
				<UNH>
					<UNH01-MessageReferenceNumber>
						<xsl:value-of select="translate(substring-before(string(current-time()),'-'),':.','')"/>
					</UNH01-MessageReferenceNumber>
					<UNH02-MessageIdentifier>
						<UNH0201-MessageType>INVRPT</UNH0201-MessageType>
						<UNH0202-MessageVersionNumber>D</UNH0202-MessageVersionNumber>
						<UNH0203-MessageReleaseNumber>04B</UNH0203-MessageReleaseNumber>
						<UNH0204-ControllingAgencyCoded>UN</UNH0204-ControllingAgencyCoded>
					</UNH02-MessageIdentifier>
				</UNH>
				<BGM>
					<BGM01-DocumentMessageName>
						<BGM0101-DocumentNameCode>9</BGM0101-DocumentNameCode>
					</BGM01-DocumentMessageName>
				</BGM>
				<DTM>
					<DTM01-DateTimePeriod>
						<DTM0101-DateOrTimeOrPeriodFunctionCodeQualifier>5</DTM0101-DateOrTimeOrPeriodFunctionCodeQualifier>
						<DTM0102-DateOrTimeOrPeriodText>
							<xsl:value-of select="translate(substring(string(current-date()),1,10),'-','')"/>
						</DTM0102-DateOrTimeOrPeriodText>
						<DTM0103-DateOrTimeOrPeriodFormatCode>102</DTM0103-DateOrTimeOrPeriodFormatCode>
					</DTM01-DateTimePeriod>
				</DTM>
				<xsl:for-each select="inventory/item">
					<GROUP_9>
						<LIN>
							<LIN01-LineItemIdentifier>
								<xsl:value-of select="position()"/>
							</LIN01-LineItemIdentifier>
							<LIN02-ActionRequestNotificationDescriptionCode>3</LIN02-ActionRequestNotificationDescriptionCode>
							<LIN03-ItemNumberIdentification>
								<LIN0301-ItemIdentifier>
									<xsl:value-of select="sku"/>
								</LIN0301-ItemIdentifier>
								<LIN0302-ItemTypeIdentificationCode>SK</LIN0302-ItemTypeIdentificationCode>
							</LIN03-ItemNumberIdentification>
						</LIN>
						<FTX>
							<FTX01-TextSubjectCodeQualifier>AAA</FTX01-TextSubjectCodeQualifier>
							<FTX04-TextLiteral>
								<FTX0401-FreeText>
									<xsl:value-of select="color"/>
								</FTX0401-FreeText>
								<FTX0402-FreeText>
									<xsl:value-of select="name"/>
								</FTX0402-FreeText>
								<FTX0403-FreeText>
									<xsl:value-of select="size"/>
								</FTX0403-FreeText>
							</FTX04-TextLiteral>
						</FTX>
						<GROUP_11>
							<INV/>
							<QTY>
								<QTY01-QuantityDetails>
									<QTY0101-QuantityTypeCodeQualifier>1</QTY0101-QuantityTypeCodeQualifier>
									<QTY0102-Quantity>
										<xsl:value-of select="avail"/>
									</QTY0102-Quantity>
								</QTY01-QuantityDetails>
							</QTY>
						</GROUP_11>
					</GROUP_9>
				</xsl:for-each>
				<UNT>
					<UNT01-NumberOfSegmentsInAMessage>
						<xsl:value-of select="count(//item) * 4 + 5"/>
					</UNT01-NumberOfSegmentsInAMessage>
					<UNT02-MessageReferenceNumber>
						<xsl:value-of select="translate(substring-before(string(current-time()),'-'),':.','')"/>
					</UNT02-MessageReferenceNumber>
				</UNT>
			</INVRPT>
			<UNZ>
				<UNZ01-InterchangeControlCount>1</UNZ01-InterchangeControlCount>
				<UNZ02-InterchangeControlReference>
					<xsl:value-of select="translate(substring-before(string(current-time()),'-'),':.','')"/>
				</UNZ02-InterchangeControlReference>
			</UNZ>
		</EDIFACT>
	</xsl:template>
</xsl:stylesheet><!-- Stylus Studio meta-information - (c) 2004-2006. Progress Software Corporation. All rights reserved.
<metaInformation>
<scenarios ><scenario default="yes" name="Scenario1" userelativepaths="yes" externalpreview="no" url="shirts.xml" htmlbaseurl="http://www.stylusstudio.com/images/publish" outputurl="" processortype="saxon8" useresolver="yes" profilemode="0" profiledepth="" profilelength="" urlprofilexml="" commandline="" additionalpath="" additionalclasspath="" postprocessortype="none" postprocesscommandline="" postprocessadditionalpath="" postprocessgeneratedext="" validateoutput="yes" validator="custom" customvalidator="Saxonica" ><validatorSchema value="EDIFACT&#x2D;INVRPT&#x2D;D04B.xsd"/></scenario></scenarios><MapperMetaTag><MapperInfo srcSchemaPathIsRelative="yes" srcSchemaInterpretAsXML="no" destSchemaPath="EDIFACT&#x2D;INVRPT&#x2D;D04B.xsd" destSchemaRoot="EDIFACT" destSchemaPathIsRelative="yes" destSchemaInterpretAsXML="no" ><SourceSchema srcSchemaPath="shirts.xml" srcSchemaRoot="inventory" AssociatedInstance="" loaderFunction="document" loaderFunctionUsesURI="no"/></MapperInfo><MapperBlockPosition><template match="/"><block path="EDIFACT/UNB/UNB04&#x2D;DateAndTimeOfPreparation/UNB0401&#x2D;Date/xsl:value&#x2D;of" x="283" y="126"/><block path="EDIFACT/UNB/UNB04&#x2D;DateAndTimeOfPreparation/UNB0402&#x2D;Time/xsl:value&#x2D;of" x="203" y="144"/><block path="EDIFACT/UNB/UNB05&#x2D;InterchangeControlReference/xsl:value&#x2D;of" x="283" y="162"/><block path="EDIFACT/INVRPT/UNH/UNH01&#x2D;MessageReferenceNumber/xsl:value&#x2D;of" x="163" y="149"/><block path="EDIFACT/INVRPT/DTM/DTM01&#x2D;DateTimePeriod/DTM0102&#x2D;DateOrTimeOrPeriodText/xsl:value&#x2D;of" x="83" y="149"/><block path="EDIFACT/INVRPT/xsl:for&#x2D;each" x="323" y="149"/><block path="EDIFACT/INVRPT/xsl:for&#x2D;each/GROUP_9/LIN/LIN01&#x2D;LineItemIdentifier/xsl:value&#x2D;of" x="323" y="109"/><block path="EDIFACT/INVRPT/UNT/UNT01&#x2D;NumberOfSegmentsInAMessage/xsl:value&#x2D;of" x="123" y="149"/><block path="EDIFACT/INVRPT/UNT/UNT02&#x2D;MessageReferenceNumber/xsl:value&#x2D;of" x="123" y="149"/><block path="EDIFACT/UNZ/UNZ02&#x2D;InterchangeControlReference/xsl:value&#x2D;of" x="243" y="149"/></template></MapperBlockPosition><TemplateContext></TemplateContext><MapperFilter side="source"></MapperFilter></MapperMetaTag>
</metaInformation>
-->